/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.phonos.util.piano;

import io.github.foundationgames.phonos.util.PhonosUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public class PianoRoll {
    private final List<Stage> stages;

    public PianoRoll(List<Stage> stages) {
        this.stages = stages;
    }

    public Player createPlayable(Consumer<Float> player) {
        return new Player(new ArrayDeque<Stage>(this.stages), player);
    }

    public int duration() {
        int dur = 0;
        for (Stage stage : this.stages) {
            dur += 1 + stage.delay;
        }
        return dur;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        class_2499 stageList = new class_2499();
        this.stages.forEach(s -> stageList.add((Object)s.toNbt()));
        nbt.method_10566("stages", (class_2520)stageList);
        nbt.method_10569("duration", this.duration());
        return nbt;
    }

    @Nullable
    public static PianoRoll fromNbt(@Nullable class_2487 nbt) {
        if (nbt != null) {
            if (!nbt.method_10545("stages")) {
                return null;
            }
            class_2499 stageList = nbt.method_10554("stages", 10);
            ArrayList<Stage> stages = new ArrayList<Stage>();
            for (class_2520 el : stageList) {
                if (!(el instanceof class_2487)) continue;
                class_2487 com = (class_2487)el;
                stages.add(Stage.fromNbt(com));
            }
            return new PianoRoll(stages);
        }
        return null;
    }

    public static class Player {
        private final Deque<Stage> stages;
        private final Consumer<Float> player;
        private int delay = 0;

        public Player(Deque<Stage> stages, Consumer<Float> player) {
            this.stages = stages;
            this.player = player;
        }

        public void tick() {
            if (!this.done()) {
                if (this.delay <= 0) {
                    Stage stage = this.stages.removeFirst();
                    this.delay = stage.delay;
                    for (float pitch : stage.pitches) {
                        this.player.accept(Float.valueOf(pitch));
                    }
                } else {
                    --this.delay;
                }
            }
        }

        public boolean done() {
            return this.stages.size() <= 0;
        }
    }

    public record Stage(float[] pitches, int delay) {
        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10539("pitches", PhonosUtil.toIntBytesArr(this.pitches));
            nbt.method_10569("delay", this.delay);
            return nbt;
        }

        public static Stage fromNbt(class_2487 nbt) {
            return new Stage(PhonosUtil.fromIntBytesArr(nbt.method_10561("pitches")), nbt.method_10550("delay"));
        }
    }

    public static class Recorder {
        private final Set<Float> currentPitches = new HashSet<Float>();
        private int currentDelay = 0;
        private final List<Stage> stages = new ArrayList<Stage>();

        public void pushStage() {
            this.stages.add(new Stage(PhonosUtil.arrFromList(this.currentPitches), Math.max(this.currentDelay - 1, 0)));
            this.currentPitches.clear();
            this.currentDelay = 0;
        }

        public void tick() {
            if (this.currentPitches.size() > 0) {
                ++this.currentDelay;
            }
        }

        public void applyNote(float pitch) {
            if (this.currentDelay > 0) {
                this.pushStage();
            }
            this.currentPitches.add(Float.valueOf(pitch));
        }

        public int size() {
            return this.stages.size();
        }

        public PianoRoll build() {
            if (this.currentPitches.size() > 0) {
                this.pushStage();
            }
            return new PianoRoll(this.stages);
        }
    }
}

