/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.actors.PortableStorageInterfaceBlock;
import com.simibubi.create.content.contraptions.components.actors.PortableStorageInterfaceMovement;
import com.simibubi.create.content.contraptions.components.actors.PortableStorageInterfaceTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderDispatcher;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.function.Consumer;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class PortableStorageInterfaceRenderer
extends SafeTileEntityRenderer<PortableStorageInterfaceTileEntity> {
    public PortableStorageInterfaceRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(PortableStorageInterfaceTileEntity te, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (Backend.canUseInstancing((class_1937)te.method_10997())) {
            return;
        }
        class_2680 blockState = te.method_11010();
        float progress = te.getExtensionDistance(partialTicks);
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        PortableStorageInterfaceRenderer.render(blockState, te.isConnected(), progress, null, sbb -> sbb.light(light).renderInto(ms, vb));
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, class_4597 buffer) {
        class_2680 blockState = context.state;
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        float renderPartialTicks = AnimationTickHolder.getPartialTicks();
        LerpedFloat animation = PortableStorageInterfaceMovement.getAnimation(context);
        float progress = animation.getValue(renderPartialTicks);
        boolean lit = animation.settled();
        PortableStorageInterfaceRenderer.render(blockState, lit, progress, matrices.getModel(), sbb -> sbb.light(matrices.getWorld(), ContraptionRenderDispatcher.getContraptionWorldLight(context, renderWorld)).renderInto(matrices.getViewProjection(), vb));
    }

    private static void render(class_2680 blockState, boolean lit, float progress, class_4587 local, Consumer<SuperByteBuffer> drawCallback) {
        SuperByteBuffer middle = CachedBufferer.partial(PortableStorageInterfaceRenderer.getMiddleForState(blockState, lit), blockState);
        SuperByteBuffer top = CachedBufferer.partial(PortableStorageInterfaceRenderer.getTopForState(blockState), blockState);
        if (local != null) {
            middle.transform(local);
            top.transform(local);
        }
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)PortableStorageInterfaceBlock.field_10927);
        PortableStorageInterfaceRenderer.rotateToFacing(middle, facing);
        PortableStorageInterfaceRenderer.rotateToFacing(top, facing);
        middle.translate(0.0, progress * 0.5f + 0.375f, 0.0);
        top.translate(0.0, progress, 0.0);
        drawCallback.accept(middle);
        drawCallback.accept(top);
    }

    private static void rotateToFacing(SuperByteBuffer buffer, class_2350 facing) {
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)buffer.centre()).rotateY(AngleHelper.horizontalAngle(facing))).rotateX(facing == class_2350.field_11036 ? 0.0 : (facing == class_2350.field_11033 ? 180.0 : 90.0))).unCentre();
    }

    static PortableStorageInterfaceTileEntity getTargetPSI(MovementContext context) {
        String _workingPos_ = "WorkingPos";
        if (!context.data.method_10545(_workingPos_)) {
            return null;
        }
        class_2338 pos = class_2512.method_10691((class_2487)context.data.method_10562(_workingPos_));
        class_2586 tileEntity = context.world.method_8321(pos);
        if (!(tileEntity instanceof PortableStorageInterfaceTileEntity)) {
            return null;
        }
        PortableStorageInterfaceTileEntity psi = (PortableStorageInterfaceTileEntity)tileEntity;
        if (!psi.isTransferring()) {
            return null;
        }
        return psi;
    }

    static PartialModel getMiddleForState(class_2680 state, boolean lit) {
        if (AllBlocks.PORTABLE_FLUID_INTERFACE.has(state)) {
            return lit ? AllBlockPartials.PORTABLE_FLUID_INTERFACE_MIDDLE_POWERED : AllBlockPartials.PORTABLE_FLUID_INTERFACE_MIDDLE;
        }
        return lit ? AllBlockPartials.PORTABLE_STORAGE_INTERFACE_MIDDLE_POWERED : AllBlockPartials.PORTABLE_STORAGE_INTERFACE_MIDDLE;
    }

    static PartialModel getTopForState(class_2680 state) {
        if (AllBlocks.PORTABLE_FLUID_INTERFACE.has(state)) {
            return AllBlockPartials.PORTABLE_FLUID_INTERFACE_TOP;
        }
        return AllBlockPartials.PORTABLE_STORAGE_INTERFACE_TOP;
    }
}

