/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.crafter;

import com.google.common.base.Predicates;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.content.contraptions.components.crafter.CrafterHelper;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCrafterBlock;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCrafterTileEntity;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCraftingInventory;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pointing;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1851;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import org.apache.commons.lang3.tuple.Pair;

public class RecipeGridHandler {
    public static List<MechanicalCrafterTileEntity> getAllCraftersOfChain(MechanicalCrafterTileEntity root) {
        return RecipeGridHandler.getAllCraftersOfChainIf(root, (Predicate<MechanicalCrafterTileEntity>)Predicates.alwaysTrue());
    }

    public static List<MechanicalCrafterTileEntity> getAllCraftersOfChainIf(MechanicalCrafterTileEntity root, Predicate<MechanicalCrafterTileEntity> test) {
        return RecipeGridHandler.getAllCraftersOfChainIf(root, test, false);
    }

    public static List<MechanicalCrafterTileEntity> getAllCraftersOfChainIf(MechanicalCrafterTileEntity root, Predicate<MechanicalCrafterTileEntity> test, boolean poweredStart) {
        ArrayList<MechanicalCrafterTileEntity> crafters = new ArrayList<MechanicalCrafterTileEntity>();
        ArrayList<Pair> frontier = new ArrayList<Pair>();
        HashSet<MechanicalCrafterTileEntity> visited = new HashSet<MechanicalCrafterTileEntity>();
        frontier.add(Pair.of((Object)root, null));
        boolean powered = false;
        boolean empty = false;
        boolean allEmpty = true;
        while (!frontier.isEmpty()) {
            Pair pair = (Pair)frontier.remove(0);
            MechanicalCrafterTileEntity current = (MechanicalCrafterTileEntity)pair.getKey();
            MechanicalCrafterTileEntity last = (MechanicalCrafterTileEntity)pair.getValue();
            if (visited.contains(current)) {
                return null;
            }
            if (!test.test(current)) {
                empty = true;
            } else {
                allEmpty = false;
            }
            if (poweredStart && current.method_10997().method_8479(current.method_11016())) {
                powered = true;
            }
            crafters.add(current);
            visited.add(current);
            MechanicalCrafterTileEntity target = RecipeGridHandler.getTargetingCrafter(current);
            if (target != last && target != null) {
                frontier.add(Pair.of((Object)target, (Object)current));
            }
            for (MechanicalCrafterTileEntity preceding : RecipeGridHandler.getPrecedingCrafters(current)) {
                if (preceding == last) continue;
                frontier.add(Pair.of((Object)preceding, (Object)current));
            }
        }
        return empty && !powered || allEmpty ? null : crafters;
    }

    public static MechanicalCrafterTileEntity getTargetingCrafter(MechanicalCrafterTileEntity crafter) {
        class_2680 state = crafter.method_11010();
        if (!RecipeGridHandler.isCrafter(state)) {
            return null;
        }
        class_2338 targetPos = crafter.method_11016().method_10093(MechanicalCrafterBlock.getTargetDirection(state));
        MechanicalCrafterTileEntity targetTE = CrafterHelper.getCrafter((class_1920)crafter.method_10997(), targetPos);
        if (targetTE == null) {
            return null;
        }
        class_2680 targetState = targetTE.method_11010();
        if (!RecipeGridHandler.isCrafter(targetState)) {
            return null;
        }
        if (state.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING) != targetState.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING)) {
            return null;
        }
        return targetTE;
    }

    public static List<MechanicalCrafterTileEntity> getPrecedingCrafters(MechanicalCrafterTileEntity crafter) {
        class_2338 pos = crafter.method_11016();
        class_1937 world = crafter.method_10997();
        ArrayList<MechanicalCrafterTileEntity> crafters = new ArrayList<MechanicalCrafterTileEntity>();
        class_2680 blockState = crafter.method_11010();
        if (!RecipeGridHandler.isCrafter(blockState)) {
            return crafters;
        }
        class_2350 blockFacing = (class_2350)blockState.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING);
        class_2350 blockPointing = MechanicalCrafterBlock.getTargetDirection(blockState);
        for (class_2350 facing : Iterate.directions) {
            MechanicalCrafterTileEntity te;
            class_2338 neighbourPos;
            class_2680 neighbourState;
            if (blockFacing.method_10166() == facing.method_10166() || blockPointing == facing || !RecipeGridHandler.isCrafter(neighbourState = world.method_8320(neighbourPos = pos.method_10093(facing))) || MechanicalCrafterBlock.getTargetDirection(neighbourState) != facing.method_10153() || blockFacing != neighbourState.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING) || (te = CrafterHelper.getCrafter((class_1920)world, neighbourPos)) == null) continue;
            crafters.add(te);
        }
        return crafters;
    }

    private static boolean isCrafter(class_2680 state) {
        return AllBlocks.MECHANICAL_CRAFTER.has(state);
    }

    public static class_1799 tryToApplyRecipe(class_1937 world, GroupedItems items) {
        items.calcStats();
        MechanicalCraftingInventory craftinginventory = new MechanicalCraftingInventory(items);
        class_1799 result = null;
        if (((Boolean)AllConfigs.SERVER.recipes.allowRegularCraftingInCrafter.get()).booleanValue()) {
            result = world.method_8433().method_8132(class_3956.field_17545, (class_1263)craftinginventory, world).filter(r -> RecipeGridHandler.isRecipeAllowed(r, craftinginventory)).map(r -> r.method_8116((class_1263)craftinginventory)).orElse(null);
        }
        if (result == null) {
            result = AllRecipeTypes.MECHANICAL_CRAFTING.find(craftinginventory, world).map(r -> r.method_8116((class_1263)craftinginventory)).orElse(null);
        }
        return result;
    }

    public static boolean isRecipeAllowed(class_3955 recipe, class_1715 inventory) {
        if (recipe instanceof class_1851) {
            int numItems = 0;
            for (int i = 0; i < inventory.method_5439(); ++i) {
                if (inventory.method_5438(i).method_7960()) continue;
                ++numItems;
            }
            if (numItems > (Integer)AllConfigs.SERVER.recipes.maxFireworkIngredientsInCrafter.get()) {
                return false;
            }
        }
        return !AllRecipeTypes.shouldIgnoreInAutomation(recipe);
    }

    public static class GroupedItems {
        Map<Pair<Integer, Integer>, class_1799> grid = new HashMap<Pair<Integer, Integer>, class_1799>();
        int minX;
        int minY;
        int maxX;
        int maxY;
        int width;
        int height;
        boolean statsReady;

        public GroupedItems() {
        }

        public GroupedItems(class_1799 stack) {
            this.grid.put((Pair<Integer, Integer>)Pair.of((Object)0, (Object)0), stack);
        }

        public void mergeOnto(GroupedItems other, Pointing pointing) {
            int xOffset;
            int n = pointing == Pointing.LEFT ? 1 : (xOffset = pointing == Pointing.RIGHT ? -1 : 0);
            int yOffset = pointing == Pointing.DOWN ? 1 : (pointing == Pointing.UP ? -1 : 0);
            this.grid.forEach((pair, stack) -> other.grid.put((Pair<Integer, Integer>)Pair.of((Object)((Integer)pair.getKey() + xOffset), (Object)((Integer)pair.getValue() + yOffset)), (class_1799)stack));
            other.statsReady = false;
        }

        public void write(class_2487 nbt) {
            class_2499 gridNBT = new class_2499();
            this.grid.forEach((pair, stack) -> {
                class_2487 entry = new class_2487();
                entry.method_10569("x", ((Integer)pair.getKey()).intValue());
                entry.method_10569("y", ((Integer)pair.getValue()).intValue());
                entry.method_10566("item", NBTSerializer.serializeNBT((Object)stack));
                gridNBT.add((Object)entry);
            });
            nbt.method_10566("Grid", (class_2520)gridNBT);
        }

        public static GroupedItems read(class_2487 nbt) {
            GroupedItems items = new GroupedItems();
            class_2499 gridNBT = nbt.method_10554("Grid", 10);
            gridNBT.forEach(inbt -> {
                class_2487 entry = (class_2487)inbt;
                int x = entry.method_10550("x");
                int y = entry.method_10550("y");
                class_1799 stack = class_1799.method_7915((class_2487)entry.method_10562("item"));
                items.grid.put((Pair<Integer, Integer>)Pair.of((Object)x, (Object)y), stack);
            });
            return items;
        }

        public void calcStats() {
            if (this.statsReady) {
                return;
            }
            this.statsReady = true;
            this.minX = 0;
            this.minY = 0;
            this.maxX = 0;
            this.maxY = 0;
            for (Pair<Integer, Integer> pair : this.grid.keySet()) {
                int x = (Integer)pair.getKey();
                int y = (Integer)pair.getValue();
                this.minX = Math.min(this.minX, x);
                this.minY = Math.min(this.minY, y);
                this.maxX = Math.max(this.maxX, x);
                this.maxY = Math.max(this.maxY, y);
            }
            this.width = this.maxX - this.minX + 1;
            this.height = this.maxY - this.minY + 1;
        }
    }
}

