/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.crank;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.base.GeneratingKineticTileEntity;
import com.simibubi.create.content.contraptions.components.crank.HandCrankBlock;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class HandCrankTileEntity
extends GeneratingKineticTileEntity {
    public int inUse;
    public boolean backwards;
    public float independentAngle;
    public float chasingVelocity;

    public HandCrankTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void turn(boolean back) {
        boolean update = false;
        if (this.getGeneratedSpeed() == 0.0f || back != this.backwards) {
            update = true;
        }
        this.inUse = 10;
        this.backwards = back;
        if (update && !this.field_11863.field_9236) {
            this.updateGeneratedRotation();
        }
    }

    @Override
    public float getGeneratedSpeed() {
        class_2248 block = this.method_11010().method_26204();
        if (!(block instanceof HandCrankBlock)) {
            return 0.0f;
        }
        HandCrankBlock crank = (HandCrankBlock)block;
        int speed = (this.inUse == 0 ? 0 : (this.backwards ? -1 : 1)) * crank.getRotationSpeed();
        return HandCrankTileEntity.convertToDirection(speed, (class_2350)this.method_11010().method_11654((class_2769)HandCrankBlock.FACING));
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10569("InUse", this.inUse);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        this.inUse = compound.method_10550("InUse");
        super.read(compound, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        float actualSpeed = this.getSpeed();
        this.chasingVelocity += (actualSpeed * 10.0f / 3.0f - this.chasingVelocity) * 0.25f;
        this.independentAngle += this.chasingVelocity;
        if (this.inUse > 0) {
            --this.inUse;
            if (this.inUse == 0 && !this.field_11863.field_9236) {
                this.updateGeneratedRotation();
            }
        }
    }

    @Override
    protected class_2248 getStressConfigKey() {
        return (class_2248)AllBlocks.HAND_CRANK.get();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.inUse > 0 && AnimationTickHolder.getTicks() % 10 == 0) {
            if (!AllBlocks.HAND_CRANK.has(this.method_11010())) {
                return;
            }
            AllSoundEvents.CRANKING.playAt(this.field_11863, (class_2382)this.field_11867, (float)this.inUse / 2.5f, 0.65f + (float)(10 - this.inUse) / 10.0f, true);
        }
    }
}

