/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.api.instance.TickableInstance;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import com.simibubi.create.content.contraptions.relays.encased.ShaftInstance;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.class_1158;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2769;
import net.minecraft.class_3532;

public class DeployerInstance
extends ShaftInstance
implements DynamicInstance,
TickableInstance {
    final DeployerTileEntity tile;
    final class_2350 facing;
    final float yRot;
    final float xRot;
    final float zRot;
    protected final OrientedData pole;
    protected OrientedData hand;
    PartialModel currentHand;
    float progress;

    public DeployerInstance(MaterialManager dispatcher, KineticTileEntity tile) {
        super(dispatcher, tile);
        this.tile = (DeployerTileEntity)this.blockEntity;
        this.facing = (class_2350)this.blockState.method_11654((class_2769)DirectionalKineticBlock.FACING);
        boolean rotatePole = (Boolean)this.blockState.method_11654((class_2769)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE) ^ this.facing.method_10166() == class_2350.class_2351.field_11051;
        this.yRot = AngleHelper.horizontalAngle(this.facing);
        this.xRot = this.facing == class_2350.field_11036 ? 270.0f : (this.facing == class_2350.field_11033 ? 90.0f : 0.0f);
        this.zRot = rotatePole ? 90.0f : 0.0f;
        this.pole = (OrientedData)this.getOrientedMaterial().getModel(AllBlockPartials.DEPLOYER_POLE, this.blockState).createInstance();
        this.currentHand = this.tile.getHandPose();
        this.hand = (OrientedData)this.getOrientedMaterial().getModel(this.currentHand, this.blockState).createInstance();
        this.progress = this.getProgress(AnimationTickHolder.getPartialTicks());
        DeployerInstance.updateRotation(this.pole, this.hand, this.yRot, this.xRot, this.zRot);
        this.updatePosition();
    }

    public void tick() {
        PartialModel handPose = this.tile.getHandPose();
        if (this.currentHand != handPose) {
            this.currentHand = handPose;
            this.getOrientedMaterial().getModel(this.currentHand, this.blockState).stealInstance((InstanceData)this.hand);
        }
    }

    public void beginFrame() {
        float newProgress = this.getProgress(AnimationTickHolder.getPartialTicks());
        if (class_3532.method_15347((float)newProgress, (float)this.progress)) {
            return;
        }
        this.progress = newProgress;
        this.updatePosition();
    }

    @Override
    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.hand, this.pole});
    }

    @Override
    public void remove() {
        super.remove();
        this.hand.delete();
        this.pole.delete();
    }

    private float getProgress(float partialTicks) {
        if (this.tile.state == DeployerTileEntity.State.EXPANDING) {
            float f = 1.0f - ((float)this.tile.timer - partialTicks * (float)this.tile.getTimerSpeed()) / 1000.0f;
            if (this.tile.fistBump) {
                f *= f;
            }
            return f;
        }
        if (this.tile.state == DeployerTileEntity.State.RETRACTING) {
            return ((float)this.tile.timer - partialTicks * (float)this.tile.getTimerSpeed()) / 1000.0f;
        }
        return 0.0f;
    }

    private void updatePosition() {
        float handLength = this.currentHand == AllBlockPartials.DEPLOYER_HAND_POINTING ? 0.0f : (this.currentHand == AllBlockPartials.DEPLOYER_HAND_HOLDING ? 0.25f : 0.1875f);
        float distance = Math.min(class_3532.method_15363((float)this.progress, (float)0.0f, (float)1.0f) * (this.tile.reach + handLength), 1.3125f);
        class_2382 facingVec = this.facing.method_10163();
        class_2338 blockPos = this.getInstancePosition();
        float x = (float)blockPos.method_10263() + (float)facingVec.method_10263() * distance;
        float y = (float)blockPos.method_10264() + (float)facingVec.method_10264() * distance;
        float z = (float)blockPos.method_10260() + (float)facingVec.method_10260() * distance;
        this.pole.setPosition(x, y, z);
        this.hand.setPosition(x, y, z);
    }

    static void updateRotation(OrientedData pole, OrientedData hand, float yRot, float xRot, float zRot) {
        class_1158 q = class_2350.field_11036.method_23955().method_23214(yRot);
        q.method_4925(class_2350.field_11034.method_23955().method_23214(xRot));
        hand.setRotation(q);
        q.method_4925(class_2350.field_11035.method_23955().method_23214(zRot));
        pole.setRotation(q);
    }
}

