/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.simibubi.create.content.contraptions.components.deployer.DeployerFakePlayer;
import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_3902;

public class DeployerItemHandler
extends SnapshotParticipant<class_3902>
implements Storage<ItemVariant> {
    private DeployerTileEntity te;
    private DeployerFakePlayer player;

    public DeployerItemHandler(DeployerTileEntity te) {
        this.te = te;
        this.player = te.player;
    }

    public class_1799 getHeld() {
        if (this.player == null) {
            return class_1799.field_8037;
        }
        return this.player.method_6047();
    }

    public void set(class_1799 stack) {
        if (this.player == null) {
            return;
        }
        if (this.te.method_10997().field_9236) {
            return;
        }
        this.player.method_6122(class_1268.field_5808, stack);
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        int maxInsert = Math.min((int)maxAmount, resource.getItem().method_7882());
        class_1799 stack = resource.toStack(maxInsert);
        if (!this.isItemValid(stack)) {
            return 0L;
        }
        class_1799 held = this.getHeld();
        if (held.method_7960()) {
            this.te.snapshotParticipant.updateSnapshots(transaction);
            this.set(stack);
            return maxInsert;
        }
        if (!ItemHandlerHelper.canItemStacksStack((class_1799)held, (class_1799)stack)) {
            return 0L;
        }
        int space = held.method_7914() - held.method_7947();
        if (space == 0) {
            return 0L;
        }
        int toInsert = Math.min(maxInsert, space);
        class_1799 newStack = held.method_7972();
        newStack.method_7933(toInsert);
        this.te.snapshotParticipant.updateSnapshots(transaction);
        this.set(newStack);
        return toInsert;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        long extracted = this.extractFromOverflow(resource, maxAmount, transaction);
        if (extracted == maxAmount) {
            return extracted;
        }
        extracted += this.extractFromHeld(resource, maxAmount - extracted, transaction);
        return extracted;
    }

    public long extractFromOverflow(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        long extracted = 0L;
        for (int i = 0; i < this.te.overflowItems.size(); ++i) {
            class_1799 itemStack = this.te.overflowItems.get(i);
            if (itemStack.method_7960() || !resource.matches(itemStack)) continue;
            int toExtract = (int)Math.min(maxAmount - extracted, (long)itemStack.method_7947());
            if (extracted == 0L) {
                this.te.snapshotParticipant.updateSnapshots(transaction);
            }
            extracted += (long)toExtract;
            class_1799 newStack = itemStack.method_7972();
            newStack.method_7934(toExtract);
            this.te.overflowItems.set(i, newStack);
        }
        return extracted;
    }

    public long extractFromHeld(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        class_1799 held = this.getHeld();
        if (held.method_7960() || !resource.matches(held)) {
            return 0L;
        }
        if (!this.te.filtering.getFilter().method_7960() && this.te.filtering.test(held)) {
            return 0L;
        }
        int toExtract = (int)Math.min(maxAmount, (long)held.method_7947());
        this.te.snapshotParticipant.updateSnapshots(transaction);
        class_1799 newStack = held.method_7972();
        newStack.method_7934(toExtract);
        this.set(newStack);
        return toExtract;
    }

    public boolean isItemValid(class_1799 stack) {
        FilteringBehaviour filteringBehaviour = this.te.getBehaviour(FilteringBehaviour.TYPE);
        return filteringBehaviour == null || filteringBehaviour.test(stack);
    }

    protected class_3902 createSnapshot() {
        return class_3902.field_17274;
    }

    protected void readSnapshot(class_3902 snapshot) {
    }

    protected void onFinalCommit() {
        super.onFinalCommit();
        this.te.method_5431();
        this.te.sendData();
    }

    public Iterator<? extends StorageView<ItemVariant>> iterator(TransactionContext transaction) {
        return new DeployerItemHandlerIterator(transaction);
    }

    public class DeployerItemHandlerIterator
    implements Iterator<StorageView<ItemVariant>> {
        private boolean open = true;
        private int index;

        public DeployerItemHandlerIterator(TransactionContext transaction) {
            transaction.addCloseCallback((t, r) -> {
                this.open = false;
            });
            this.index = DeployerItemHandler.this.te.overflowItems.size() != 0 ? 0 : -1;
        }

        @Override
        public boolean hasNext() {
            return this.open && this.index < DeployerItemHandler.this.te.overflowItems.size();
        }

        @Override
        public StorageView<ItemVariant> next() {
            int indexFinal = this.index;
            Supplier<class_1799> heldGetter = () -> DeployerItemHandler.this.te.overflowItems.get(indexFinal);
            Consumer<class_1799> heldSetter = stack -> DeployerItemHandler.this.te.overflowItems.set(indexFinal, (class_1799)stack);
            Predicate<class_1799> mayExtract = stack -> true;
            if (this.index == -1) {
                heldGetter = () -> ((DeployerFakePlayer)DeployerItemHandler.this.player).method_6047();
                heldSetter = s -> DeployerItemHandler.this.player.method_6122(class_1268.field_5808, (class_1799)s);
                mayExtract = s -> DeployerItemHandler.this.te.filtering.getFilter().method_7960() || !DeployerItemHandler.this.te.filtering.test((class_1799)s);
                this.index = DeployerItemHandler.this.te.overflowItems.size();
            }
            ++this.index;
            if (this.index == DeployerItemHandler.this.te.overflowItems.size()) {
                this.index = -1;
            }
            return new DeployerSlotView(heldGetter, heldSetter, mayExtract);
        }
    }

    public class DeployerSlotView
    extends SnapshotParticipant<class_3902>
    implements StorageView<ItemVariant> {
        public final Supplier<class_1799> heldGetter;
        public final Consumer<class_1799> heldSetter;
        public final Predicate<class_1799> mayExtract;

        public DeployerSlotView(Supplier<class_1799> heldGetter, Consumer<class_1799> heldSetter, Predicate<class_1799> mayExtract) {
            this.heldGetter = heldGetter;
            this.heldSetter = heldSetter;
            this.mayExtract = mayExtract;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            class_1799 stack = this.getStack();
            if (stack.method_7960() || !resource.matches(stack) || !this.mayExtract.test(stack)) {
                return 0L;
            }
            int toExtract = (int)Math.min(maxAmount, (long)stack.method_7947());
            this.updateSnapshots(transaction);
            class_1799 newStack = ItemHandlerHelper.copyStackWithSize((class_1799)stack, (int)(stack.method_7947() - toExtract));
            this.heldSetter.accept(newStack);
            return toExtract;
        }

        public boolean isResourceBlank() {
            return this.getResource().isBlank();
        }

        public ItemVariant getResource() {
            class_1799 stack = this.getStack();
            return stack.method_7960() ? ItemVariant.blank() : ItemVariant.of((class_1799)stack);
        }

        public long getAmount() {
            return this.getStack().method_7947();
        }

        public long getCapacity() {
            return this.getStack().method_7914();
        }

        public class_1799 getStack() {
            return this.heldGetter.get();
        }

        public void updateSnapshots(TransactionContext transaction) {
            super.updateSnapshots(transaction);
            DeployerItemHandler.this.te.snapshotParticipant.updateSnapshots(transaction);
        }

        protected class_3902 createSnapshot() {
            return class_3902.field_17274;
        }

        protected void readSnapshot(class_3902 snapshot) {
        }

        protected void onFinalCommit() {
            super.onFinalCommit();
            DeployerItemHandler.this.onFinalCommit();
        }
    }
}

