/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.fluids.FluidPropagator;
import com.simibubi.create.content.contraptions.fluids.FluidReactions;
import com.simibubi.create.content.contraptions.fluids.PipeConnection;
import com.simibubi.create.content.contraptions.fluids.PumpBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.WorldAttached;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public abstract class FluidTransportBehaviour
extends TileEntityBehaviour {
    public static final BehaviourType<FluidTransportBehaviour> TYPE = new BehaviourType();
    public Map<class_2350, PipeConnection> interfaces;
    public UpdatePhase phase = UpdatePhase.WAIT_FOR_PUMPS;
    public static final WorldAttached<Map<class_2338, Map<class_2350, PipeConnection>>> interfaceTransfer = new WorldAttached<Map>($ -> new HashMap());

    public FluidTransportBehaviour(SmartTileEntity te) {
        super(te);
    }

    public boolean canPullFluidFrom(FluidStack fluid, class_2680 state, class_2350 direction) {
        return true;
    }

    public abstract boolean canHaveFlowToward(class_2680 var1, class_2350 var2);

    @Override
    public void initialize() {
        super.initialize();
        this.createConnectionData();
    }

    @Override
    public void tick() {
        boolean onServer;
        super.tick();
        class_1937 world = this.getWorld();
        class_2338 pos = this.getPos();
        boolean bl = onServer = !world.field_9236 || this.tileEntity.isVirtual();
        if (this.interfaces == null) {
            return;
        }
        Collection<PipeConnection> connections = this.interfaces.values();
        PipeConnection singleSource = null;
        if (this.phase == UpdatePhase.WAIT_FOR_PUMPS) {
            this.phase = UpdatePhase.FLIP_FLOWS;
            return;
        }
        if (onServer) {
            boolean sendUpdate = false;
            for (PipeConnection pipeConnection : connections) {
                sendUpdate |= pipeConnection.flipFlowsIfPressureReversed();
                pipeConnection.manageSource(world, pos);
            }
            if (sendUpdate) {
                this.tileEntity.notifyUpdate();
            }
        }
        if (this.phase == UpdatePhase.FLIP_FLOWS) {
            this.phase = UpdatePhase.IDLE;
            return;
        }
        if (onServer) {
            int n;
            FluidStack availableFlow = FluidStack.EMPTY;
            FluidStack collidingFlow = FluidStack.EMPTY;
            for (PipeConnection connection : connections) {
                FluidStack fluidInFlow = connection.getProvidedFluid();
                if (fluidInFlow.isEmpty()) continue;
                if (availableFlow.isEmpty()) {
                    singleSource = connection;
                    availableFlow = fluidInFlow;
                    continue;
                }
                if (availableFlow.isFluidEqual(fluidInFlow)) {
                    singleSource = null;
                    availableFlow = fluidInFlow;
                    continue;
                }
                collidingFlow = fluidInFlow;
                break;
            }
            if (!collidingFlow.isEmpty()) {
                FluidReactions.handlePipeFlowCollision(world, pos, availableFlow, collidingFlow);
                return;
            }
            boolean bl2 = false;
            for (PipeConnection connection : connections) {
                FluidStack internalFluid = singleSource != connection ? availableFlow : FluidStack.EMPTY;
                Predicate<FluidStack> extractionPredicate = extracted -> this.canPullFluidFrom((FluidStack)extracted, this.tileEntity.method_11010(), connection.side);
                n |= connection.manageFlows(world, pos, internalFluid, extractionPredicate);
            }
            if (n != 0) {
                this.tileEntity.notifyUpdate();
            }
        }
        for (PipeConnection connection : connections) {
            connection.tickFlowProgress(world, pos);
        }
    }

    @Override
    public void read(class_2487 nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (this.interfaces == null) {
            this.interfaces = new IdentityHashMap<class_2350, PipeConnection>();
        }
        for (class_2350 face : Iterate.directions) {
            if (!nbt.method_10545(face.method_10151())) continue;
            this.interfaces.computeIfAbsent(face, d -> new PipeConnection((class_2350)d));
        }
        if (this.interfaces.isEmpty()) {
            this.interfaces = null;
            return;
        }
        this.interfaces.values().forEach(connection -> connection.deserializeNBT(nbt, this.tileEntity.method_11016(), clientPacket));
    }

    @Override
    public void write(class_2487 nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        if (clientPacket) {
            this.createConnectionData();
        }
        if (this.interfaces == null) {
            return;
        }
        this.interfaces.values().forEach(connection -> connection.serializeNBT(nbt, clientPacket));
    }

    public FluidStack getProvidedOutwardFluid(class_2350 side) {
        this.createConnectionData();
        if (!this.interfaces.containsKey(side)) {
            return FluidStack.EMPTY;
        }
        return this.interfaces.get(side).provideOutboundFlow();
    }

    @Nullable
    public PipeConnection getConnection(class_2350 side) {
        this.createConnectionData();
        return this.interfaces.get(side);
    }

    public boolean hasAnyPressure() {
        this.createConnectionData();
        for (PipeConnection pipeConnection : this.interfaces.values()) {
            if (!pipeConnection.hasPressure()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public PipeConnection.Flow getFlow(class_2350 side) {
        this.createConnectionData();
        if (!this.interfaces.containsKey(side)) {
            return null;
        }
        return this.interfaces.get((Object)side).flow.orElse(null);
    }

    public void addPressure(class_2350 side, boolean inbound, float pressure) {
        this.createConnectionData();
        if (!this.interfaces.containsKey(side)) {
            return;
        }
        this.interfaces.get(side).addPressure(inbound, pressure);
        this.tileEntity.sendData();
    }

    public void wipePressure() {
        if (this.interfaces != null) {
            for (class_2350 d : Iterate.directions) {
                if (!this.canHaveFlowToward(this.tileEntity.method_11010(), d)) {
                    this.interfaces.remove(d);
                    continue;
                }
                this.interfaces.computeIfAbsent(d, PipeConnection::new);
            }
        }
        this.phase = UpdatePhase.WAIT_FOR_PUMPS;
        this.createConnectionData();
        this.interfaces.values().forEach(PipeConnection::wipePressure);
        this.tileEntity.sendData();
    }

    private void createConnectionData() {
        if (this.interfaces != null) {
            return;
        }
        this.interfaces = new IdentityHashMap<class_2350, PipeConnection>();
        for (class_2350 d : Iterate.directions) {
            if (!this.canHaveFlowToward(this.tileEntity.method_11010(), d)) continue;
            this.interfaces.put(d, new PipeConnection(d));
        }
    }

    public AttachmentTypes getRenderedRimAttachment(class_1920 world, class_2338 pos, class_2680 state, class_2350 direction) {
        if (!this.canHaveFlowToward(state, direction)) {
            return AttachmentTypes.NONE;
        }
        class_2338 offsetPos = pos.method_10093(direction);
        class_2680 facingState = world.method_8320(offsetPos);
        if (facingState.method_26204() instanceof PumpBlock && facingState.method_11654((class_2769)PumpBlock.FACING) == direction.method_10153()) {
            return AttachmentTypes.NONE;
        }
        if (AllBlocks.ENCASED_FLUID_PIPE.has(facingState) && ((Boolean)facingState.method_11654((class_2769)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(direction.method_10153()))).booleanValue()) {
            return AttachmentTypes.RIM;
        }
        if (FluidPropagator.hasFluidCapability((class_1922)world, offsetPos, direction.method_10153()) && !AllBlocks.HOSE_PULLEY.has(facingState)) {
            return AttachmentTypes.DRAIN;
        }
        return AttachmentTypes.RIM;
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public static void cacheFlows(class_1936 world, class_2338 pos) {
        FluidTransportBehaviour pipe = TileEntityBehaviour.get((class_1922)world, pos, TYPE);
        if (pipe != null) {
            interfaceTransfer.get(world).put(pos, pipe.interfaces);
        }
    }

    public static void loadFlows(class_1936 world, class_2338 pos) {
        FluidTransportBehaviour newPipe = TileEntityBehaviour.get((class_1922)world, pos, TYPE);
        if (newPipe != null) {
            newPipe.interfaces = interfaceTransfer.get(world).remove(pos);
        }
    }

    public static enum UpdatePhase {
        WAIT_FOR_PUMPS,
        FLIP_FLOWS,
        IDLE;

    }

    public static enum AttachmentTypes {
        NONE(new ComponentPartials[0]),
        CONNECTION(ComponentPartials.CONNECTION),
        RIM(ComponentPartials.RIM_CONNECTOR, ComponentPartials.RIM),
        PARTIAL_RIM(ComponentPartials.RIM),
        DRAIN(ComponentPartials.RIM_CONNECTOR, ComponentPartials.DRAIN),
        PARTIAL_DRAIN(ComponentPartials.DRAIN);

        public final ComponentPartials[] partials;

        private AttachmentTypes(ComponentPartials ... partials) {
            this.partials = partials;
        }

        public AttachmentTypes withoutConnector() {
            if (this == RIM) {
                return PARTIAL_RIM;
            }
            if (this == DRAIN) {
                return PARTIAL_DRAIN;
            }
            return this;
        }

        public static enum ComponentPartials {
            CONNECTION,
            RIM_CONNECTOR,
            RIM,
            DRAIN;

        }
    }
}

