/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.components.mixer.MechanicalMixerTileEntity;
import com.simibubi.create.content.contraptions.fluids.FluidFX;
import com.simibubi.create.content.contraptions.fluids.particle.FluidParticleData;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.processing.BasinBlock;
import com.simibubi.create.content.contraptions.processing.BasinInventory;
import com.simibubi.create.content.contraptions.processing.BasinOperatingTileEntity;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.CapManipulationBehaviourBase;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.LongAttached;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import io.github.fabricators_of_create.porting_lib.transfer.StorageProvider;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTransferable;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemTransferable;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class BasinTileEntity
extends SmartTileEntity
implements IHaveGoggleInformation,
FluidTransferable,
ItemTransferable {
    private boolean needsUpdate;
    private boolean areFluidsMoving;
    LerpedFloat ingredientRotationSpeed;
    LerpedFloat ingredientRotation;
    public BasinInventory inputInventory;
    public SmartFluidTankBehaviour inputTank;
    protected SmartInventory outputInventory;
    protected SmartFluidTankBehaviour outputTank;
    private FilteringBehaviour filtering;
    private boolean contentsChanged;
    private Couple<SmartInventory> invs;
    private Couple<SmartFluidTankBehaviour> tanks;
    protected Storage<ItemVariant> itemCapability;
    protected Storage<FluidVariant> fluidCapability;
    List<class_2350> disabledSpoutputs;
    class_2350 preferredSpoutput;
    protected List<class_1799> spoutputBuffer;
    protected List<FluidStack> spoutputFluidBuffer;
    int recipeBackupCheck;
    public static final int OUTPUT_ANIMATION_TIME = 10;
    List<LongAttached<class_1799>> visualizedOutputItems;
    List<LongAttached<FluidStack>> visualizedOutputFluids;
    private final Map<class_2350, Pair<StorageProvider<ItemVariant>, StorageProvider<FluidVariant>>> spoutputOutputs = new HashMap<class_2350, Pair<StorageProvider<ItemVariant>, StorageProvider<FluidVariant>>>();
    SnapshotParticipant<Data> snapshotParticipant = new SnapshotParticipant<Data>(){

        protected Data createSnapshot() {
            return new Data(new ArrayList<class_1799>(BasinTileEntity.this.spoutputBuffer), new ArrayList<FluidStack>(BasinTileEntity.this.spoutputFluidBuffer));
        }

        protected void readSnapshot(Data snapshot) {
            BasinTileEntity.this.spoutputBuffer = snapshot.spoutputBuffer;
            BasinTileEntity.this.spoutputFluidBuffer = snapshot.spoutputFluidBuffer;
        }
    };

    public BasinTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.inputInventory = new BasinInventory(9, this);
        this.inputInventory.whenContentsChanged(() -> {
            this.contentsChanged = true;
        });
        this.outputInventory = new BasinInventory(9, this).forbidInsertion().withMaxStackSize(64);
        this.areFluidsMoving = false;
        this.itemCapability = new CombinedStorage(List.of(this.inputInventory, this.outputInventory));
        this.contentsChanged = true;
        this.ingredientRotation = LerpedFloat.angular().startWithValue(0.0);
        this.ingredientRotationSpeed = LerpedFloat.linear().startWithValue(0.0);
        this.invs = Couple.create(this.inputInventory, this.outputInventory);
        this.tanks = Couple.create(this.inputTank, this.outputTank);
        this.visualizedOutputItems = Collections.synchronizedList(new ArrayList());
        this.visualizedOutputFluids = Collections.synchronizedList(new ArrayList());
        this.disabledSpoutputs = new ArrayList<class_2350>();
        this.preferredSpoutput = null;
        this.spoutputBuffer = new ArrayList<class_1799>();
        this.spoutputFluidBuffer = new ArrayList<FluidStack>();
        this.recipeBackupCheck = 20;
    }

    public void method_31662(class_1937 level) {
        super.method_31662(level);
        this.spoutputOutputs.clear();
        for (class_2350 direction : Iterate.horizontalDirections) {
            class_2338 pos = this.method_11016().method_10074().method_10093(direction);
            StorageProvider items = StorageProvider.createForItems((class_1937)level, (class_2338)pos);
            StorageProvider fluids = StorageProvider.createForFluids((class_1937)level, (class_2338)pos);
            this.spoutputOutputs.put(direction, (Pair<StorageProvider<ItemVariant>, StorageProvider<FluidVariant>>)Pair.of((Object)items, (Object)fluids));
        }
    }

    public Storage<ItemVariant> getItemSpoutputOutput(class_2350 facing) {
        Pair<StorageProvider<ItemVariant>, StorageProvider<FluidVariant>> providers = this.spoutputOutputs.get(facing);
        return providers == null ? null : ((StorageProvider)providers.first()).get(facing.method_10153());
    }

    public Storage<FluidVariant> getFluidSpoutputOutput(class_2350 facing) {
        Pair<StorageProvider<ItemVariant>, StorageProvider<FluidVariant>> providers = this.spoutputOutputs.get(facing);
        return providers == null ? null : ((StorageProvider)providers.second()).get(facing.method_10153());
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this));
        this.filtering = new FilteringBehaviour(this, new BasinValueBox()).moveText(new class_243(2.0, -8.0, 0.0)).withCallback(newFilter -> {
            this.contentsChanged = true;
        }).forRecipes();
        behaviours.add(this.filtering);
        this.inputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, this, 2, 81000L, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        });
        this.outputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.OUTPUT, this, 2, 81000L, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        }).forbidInsertion();
        behaviours.add(this.inputTank);
        behaviours.add(this.outputTank);
        this.fluidCapability = new CombinedTankWrapper(this.inputTank.getCapability(), this.outputTank.getCapability());
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.inputInventory.deserializeNBT(compound.method_10562("InputItems"));
        this.outputInventory.deserializeNBT(compound.method_10562("OutputItems"));
        this.preferredSpoutput = null;
        if (compound.method_10545("PreferredSpoutput")) {
            this.preferredSpoutput = NBTHelper.readEnum(compound, "PreferredSpoutput", class_2350.class);
        }
        this.disabledSpoutputs.clear();
        class_2499 disabledList = compound.method_10554("DisabledSpoutput", 8);
        disabledList.forEach(d -> this.disabledSpoutputs.add(class_2350.valueOf((String)((class_2519)d).method_10714())));
        this.spoutputBuffer = NBTHelper.readItemList(compound.method_10554("Overflow", 10));
        this.spoutputFluidBuffer = NBTHelper.readCompoundList(compound.method_10554("FluidOverflow", 10), FluidStack::loadFluidStackFromNBT);
        if (!clientPacket) {
            return;
        }
        NBTHelper.iterateCompoundList(compound.method_10554("VisualizedItems", 10), c -> this.visualizedOutputItems.add(LongAttached.with(10L, class_1799.method_7915((class_2487)c))));
        NBTHelper.iterateCompoundList(compound.method_10554("VisualizedFluids", 10), c -> this.visualizedOutputFluids.add(LongAttached.with(10L, FluidStack.loadFluidStackFromNBT((class_2487)c))));
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10566("InputItems", (class_2520)this.inputInventory.serializeNBT());
        compound.method_10566("OutputItems", (class_2520)this.outputInventory.serializeNBT());
        if (this.preferredSpoutput != null) {
            NBTHelper.writeEnum(compound, "PreferredSpoutput", this.preferredSpoutput);
        }
        class_2499 disabledList = new class_2499();
        this.disabledSpoutputs.forEach(d -> disabledList.add((Object)class_2519.method_23256((String)d.name())));
        compound.method_10566("DisabledSpoutput", (class_2520)disabledList);
        compound.method_10566("Overflow", (class_2520)NBTHelper.writeItemList(this.spoutputBuffer));
        compound.method_10566("FluidOverflow", (class_2520)NBTHelper.writeCompoundList(this.spoutputFluidBuffer, fs -> fs.writeToNBT(new class_2487())));
        if (!clientPacket) {
            return;
        }
        compound.method_10566("VisualizedItems", (class_2520)NBTHelper.writeCompoundList(this.visualizedOutputItems, ia -> NBTSerializer.serializeNBTCompound(ia.getValue())));
        compound.method_10566("VisualizedFluids", (class_2520)NBTHelper.writeCompoundList(this.visualizedOutputFluids, ia -> ((FluidStack)ia.getValue()).writeToNBT(new class_2487())));
        this.visualizedOutputItems.clear();
        this.visualizedOutputFluids.clear();
    }

    @Override
    public void destroy() {
        super.destroy();
        ItemHelper.dropContents(this.field_11863, this.field_11867, (Storage<ItemVariant>)this.inputInventory);
        ItemHelper.dropContents(this.field_11863, this.field_11867, (Storage<ItemVariant>)this.outputInventory);
        this.spoutputBuffer.forEach(is -> class_2248.method_9577((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1799)is));
    }

    @Override
    public void remove() {
        super.remove();
        this.onEmptied();
    }

    public void onEmptied() {
        this.getOperator().ifPresent(te -> {
            te.basinRemoved = true;
        });
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }

    @Override
    public void notifyUpdate() {
        this.needsUpdate = true;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (!this.field_11863.field_9236) {
            this.updateSpoutput();
            if (this.recipeBackupCheck-- > 0) {
                return;
            }
            this.recipeBackupCheck = 20;
            if (this.isEmpty()) {
                return;
            }
            this.notifyChangeOfContents();
            return;
        }
        class_2586 tileEntity = this.field_11863.method_8321(this.field_11867.method_10086(2));
        if (!(tileEntity instanceof MechanicalMixerTileEntity)) {
            this.setAreFluidsMoving(false);
            return;
        }
        MechanicalMixerTileEntity mixer = (MechanicalMixerTileEntity)tileEntity;
        this.setAreFluidsMoving(mixer.running && mixer.runningTicks <= 20);
    }

    public boolean isEmpty() {
        return this.inputInventory.method_5442() && this.outputInventory.method_5442() && this.inputTank.isEmpty() && this.outputTank.isEmpty();
    }

    public void onWrenched(class_2350 face) {
        class_2680 blockState = this.method_11010();
        class_2350 currentFacing = (class_2350)blockState.method_11654((class_2769)BasinBlock.FACING);
        this.disabledSpoutputs.remove(face);
        if (currentFacing == face) {
            if (this.preferredSpoutput == face) {
                this.preferredSpoutput = null;
            }
            this.disabledSpoutputs.add(face);
        } else {
            this.preferredSpoutput = face;
        }
        this.updateSpoutput();
    }

    private void updateSpoutput() {
        class_2680 blockState = this.method_11010();
        class_2350 currentFacing = (class_2350)blockState.method_11654((class_2769)BasinBlock.FACING);
        class_2350 newFacing = class_2350.field_11033;
        for (class_2350 test : Iterate.horizontalDirections) {
            boolean canOutputTo = BasinBlock.canOutputTo((class_1922)this.field_11863, this.field_11867, test);
            if (!canOutputTo || this.disabledSpoutputs.contains(test)) continue;
            newFacing = test;
        }
        if (this.preferredSpoutput != null && BasinBlock.canOutputTo((class_1922)this.field_11863, this.field_11867, this.preferredSpoutput) && this.preferredSpoutput != class_2350.field_11036) {
            newFacing = this.preferredSpoutput;
        }
        if (newFacing == currentFacing) {
            return;
        }
        this.field_11863.method_8501(this.field_11867, (class_2680)blockState.method_11657((class_2769)BasinBlock.FACING, (Comparable)newFacing));
        if (newFacing.method_10166().method_10178()) {
            return;
        }
        try (Transaction t = TransferUtil.getTransaction();){
            ItemVariant variant;
            for (StorageView view : TransferUtil.getNonEmpty((Storage)this.outputInventory, (TransactionContext)t)) {
                variant = (ItemVariant)view.getResource();
                class_1799 stack = variant.toStack(ItemHelper.truncateLong(view.getAmount()));
                if (!this.acceptOutputs((List<class_1799>)ImmutableList.of((Object)stack), (List<FluidStack>)ImmutableList.of(), (TransactionContext)t)) continue;
                view.extract((Object)variant, (long)stack.method_7947(), (TransactionContext)t);
            }
            for (StorageView view : TransferUtil.getNonEmpty(this.outputTank.getCapability(), (TransactionContext)t)) {
                variant = (FluidVariant)view.getResource();
                FluidStack stack = new FluidStack(view);
                if (!this.acceptOutputs((List<class_1799>)ImmutableList.of(), (List<FluidStack>)ImmutableList.of((Object)stack), (TransactionContext)t)) continue;
                view.extract((Object)variant, stack.getAmount(), (TransactionContext)t);
            }
            t.commit();
        }
        this.notifyChangeOfContents();
        this.notifyUpdate();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.needsUpdate) {
            this.needsUpdate = false;
            super.notifyUpdate();
        }
        if (this.field_11863.field_9236) {
            this.createFluidParticles();
            this.tickVisualizedOutputs();
            this.ingredientRotationSpeed.tickChaser();
            this.ingredientRotation.setValue(this.ingredientRotation.getValue() + this.ingredientRotationSpeed.getValue());
        }
        if (!(this.spoutputBuffer.isEmpty() && this.spoutputFluidBuffer.isEmpty() || this.field_11863.field_9236)) {
            this.tryClearingSpoutputOverflow();
        }
        if (!this.contentsChanged) {
            return;
        }
        this.contentsChanged = false;
        this.sendData();
        this.getOperator().ifPresent(te -> te.basinChecker.scheduleUpdate());
        for (class_2350 offset : Iterate.horizontalDirections) {
            class_2586 te2;
            class_2338 toUpdate = this.field_11867.method_10084().method_10093(offset);
            class_2680 stateToUpdate = this.field_11863.method_8320(toUpdate);
            if (!(stateToUpdate.method_26204() instanceof BasinBlock) || stateToUpdate.method_11654((class_2769)BasinBlock.FACING) != offset.method_10153() || !((te2 = this.field_11863.method_8321(toUpdate)) instanceof BasinTileEntity)) continue;
            ((BasinTileEntity)te2).contentsChanged = true;
        }
    }

    private void tryClearingSpoutputOverflow() {
        Object targetInv;
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof BasinBlock)) {
            return;
        }
        class_2350 direction = (class_2350)blockState.method_11654((class_2769)BasinBlock.FACING);
        class_2586 te = this.field_11863.method_8321(this.field_11867.method_10074().method_10093(direction));
        FilteringBehaviour filter = null;
        CapManipulationBehaviourBase inserter = null;
        if (te != null) {
            filter = TileEntityBehaviour.get((class_1922)this.field_11863, te.method_11016(), FilteringBehaviour.TYPE);
            inserter = TileEntityBehaviour.get((class_1922)this.field_11863, te.method_11016(), InvManipulationBehaviour.TYPE);
        }
        if ((targetInv = this.getItemSpoutputOutput(direction)) == null && inserter != null) {
            targetInv = inserter.getInventory();
        }
        Storage<FluidVariant> targetTank = this.getFluidSpoutputOutput(direction);
        boolean update = false;
        try (Transaction t = TransferUtil.getTransaction();){
            Transaction nested;
            Iterator<class_1799> iterator = this.spoutputBuffer.iterator();
            while (iterator.hasNext()) {
                class_1799 itemStack = iterator.next();
                if (itemStack.method_7960()) continue;
                if (direction == class_2350.field_11033) {
                    class_2248.method_9577((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1799)itemStack);
                    iterator.remove();
                    update = true;
                    continue;
                }
                if (targetInv == null) break;
                nested = t.openNested();
                try {
                    long inserted = targetInv.insert((Object)ItemVariant.of((class_1799)itemStack), (long)itemStack.method_7947(), (TransactionContext)nested);
                    if ((long)itemStack.method_7947() != inserted || filter != null && !filter.test(itemStack)) continue;
                    update = true;
                    iterator.remove();
                    this.visualizedOutputItems.add(LongAttached.withZero(itemStack));
                    nested.commit();
                }
                finally {
                    if (nested == null) continue;
                    nested.close();
                }
            }
            iterator = this.spoutputFluidBuffer.iterator();
            while (iterator.hasNext()) {
                FluidStack fluidStack = (FluidStack)iterator.next();
                if (direction == class_2350.field_11033) {
                    iterator.remove();
                    update = true;
                    continue;
                }
                if (targetTank == null) break;
                nested = t.openNested();
                try {
                    long fill;
                    long l = fill = targetTank instanceof SmartFluidTankBehaviour.InternalFluidHandler ? ((SmartFluidTankBehaviour.InternalFluidHandler)targetTank).forceFill(fluidStack.copy(), (TransactionContext)nested) : targetTank.insert((Object)fluidStack.getType(), fluidStack.getAmount(), (TransactionContext)nested);
                    if (fill != fluidStack.getAmount()) break;
                    update = true;
                    iterator.remove();
                    this.visualizedOutputFluids.add(LongAttached.withZero(fluidStack));
                    nested.commit();
                }
                finally {
                    if (nested == null) continue;
                    nested.close();
                }
            }
            if (update) {
                this.notifyChangeOfContents();
                this.sendData();
            }
            t.commit();
        }
    }

    public float getTotalFluidUnits(float partialTicks) {
        int renderedFluids = 0;
        float totalUnits = 0.0f;
        for (SmartFluidTankBehaviour behaviour : this.getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                float units;
                if (tankSegment.getRenderedFluid().isEmpty() || (units = tankSegment.getTotalUnits(partialTicks)) < 1.0f) continue;
                totalUnits += units;
                ++renderedFluids;
            }
        }
        if (renderedFluids == 0) {
            return 0.0f;
        }
        if (totalUnits < 1.0f) {
            return 0.0f;
        }
        return totalUnits;
    }

    private Optional<BasinOperatingTileEntity> getOperator() {
        if (this.field_11863 == null) {
            return Optional.empty();
        }
        class_2586 te = this.field_11863.method_8321(this.field_11867.method_10086(2));
        if (te instanceof BasinOperatingTileEntity) {
            return Optional.of((BasinOperatingTileEntity)te);
        }
        return Optional.empty();
    }

    public FilteringBehaviour getFilter() {
        return this.filtering;
    }

    public void notifyChangeOfContents() {
        this.contentsChanged = true;
    }

    public SmartInventory getInputInventory() {
        return this.inputInventory;
    }

    public SmartInventory getOutputInventory() {
        return this.outputInventory;
    }

    public boolean canContinueProcessing() {
        return this.spoutputBuffer.isEmpty() && this.spoutputFluidBuffer.isEmpty();
    }

    public boolean acceptOutputs(List<class_1799> outputItems, List<FluidStack> outputFluids, TransactionContext ctx) {
        this.outputInventory.allowInsertion();
        this.outputTank.allowInsertion();
        boolean acceptOutputsInner = this.acceptOutputsInner(outputItems, outputFluids, ctx);
        this.outputInventory.forbidInsertion();
        this.outputTank.forbidInsertion();
        return acceptOutputsInner;
    }

    private boolean acceptOutputsInner(List<class_1799> outputItems, List<FluidStack> outputFluids, TransactionContext ctx) {
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof BasinBlock)) {
            return false;
        }
        class_2350 direction = (class_2350)blockState.method_11654((class_2769)BasinBlock.FACING);
        this.snapshotParticipant.updateSnapshots(ctx);
        if (direction != class_2350.field_11033) {
            Storage<FluidVariant> targetTank;
            boolean externalTankNotPresent;
            class_2586 te = this.field_11863.method_8321(this.field_11867.method_10074().method_10093(direction));
            InvManipulationBehaviour inserter = te == null ? null : TileEntityBehaviour.get((class_1922)this.field_11863, te.method_11016(), InvManipulationBehaviour.TYPE);
            Object targetInv = this.getItemSpoutputOutput(direction);
            if (targetInv == null && inserter != null) {
                targetInv = inserter.getInventory();
            }
            boolean bl = externalTankNotPresent = (targetTank = this.getFluidSpoutputOutput(direction)) == null;
            if (!outputItems.isEmpty() && targetInv == null) {
                return false;
            }
            if (!outputFluids.isEmpty() && externalTankNotPresent) {
                targetTank = this.outputTank.getCapability();
                if (targetTank == null) {
                    return false;
                }
                if (!this.acceptFluidOutputsIntoBasin(outputFluids, ctx, targetTank)) {
                    return false;
                }
            }
            for (class_1799 itemStack : outputItems) {
                class_1799 remainder = itemStack.getRecipeRemainder();
                if (!remainder.method_7960() && itemStack.method_7962(remainder)) continue;
                this.spoutputBuffer.add(itemStack.method_7972());
            }
            if (!externalTankNotPresent) {
                for (FluidStack fluidStack : outputFluids) {
                    this.spoutputFluidBuffer.add(fluidStack.copy());
                }
            }
            return true;
        }
        SmartInventory targetInv = this.outputInventory;
        Storage<FluidVariant> targetTank = this.outputTank.getCapability();
        if (targetInv == null && !outputItems.isEmpty()) {
            return false;
        }
        if (!this.acceptItemOutputsIntoBasin(outputItems, ctx, (Storage<ItemVariant>)targetInv)) {
            return false;
        }
        if (outputFluids.isEmpty()) {
            return true;
        }
        if (targetTank == null) {
            return false;
        }
        return this.acceptFluidOutputsIntoBasin(outputFluids, ctx, targetTank);
    }

    private boolean acceptFluidOutputsIntoBasin(List<FluidStack> outputFluids, TransactionContext ctx, Storage<FluidVariant> targetTank) {
        Iterator<FluidStack> iterator = outputFluids.iterator();
        while (iterator.hasNext()) {
            FluidStack fluidStack;
            long fill = targetTank instanceof SmartFluidTankBehaviour.InternalFluidHandler ? ((SmartFluidTankBehaviour.InternalFluidHandler)targetTank).forceFill(fluidStack.copy(), ctx) : targetTank.insert((Object)fluidStack.getType(), fluidStack.getAmount(), ctx);
            if (fill == (fluidStack = iterator.next()).getAmount()) continue;
            return false;
        }
        return true;
    }

    private boolean acceptItemOutputsIntoBasin(List<class_1799> outputItems, TransactionContext ctx, Storage<ItemVariant> targetInv) {
        for (class_1799 itemStack : outputItems) {
            long inserted;
            class_1799 remainder = itemStack.getRecipeRemainder();
            if (!remainder.method_7960() && remainder.method_7962(itemStack) || (inserted = targetInv.insert((Object)ItemVariant.of((class_1799)itemStack), (long)itemStack.method_7947(), ctx)) == (long)itemStack.method_7947()) continue;
            return false;
        }
        return true;
    }

    public void readOnlyItems(class_2487 compound) {
        this.inputInventory.deserializeNBT(compound.method_10562("InputItems"));
        this.outputInventory.deserializeNBT(compound.method_10562("OutputItems"));
    }

    public static BlazeBurnerBlock.HeatLevel getHeatLevelOf(class_2680 state) {
        if (state.method_28498(BlazeBurnerBlock.HEAT_LEVEL)) {
            return (BlazeBurnerBlock.HeatLevel)((Object)state.method_11654(BlazeBurnerBlock.HEAT_LEVEL));
        }
        return AllTags.AllBlockTags.PASSIVE_BOILER_HEATERS.matches(state) ? BlazeBurnerBlock.HeatLevel.SMOULDERING : BlazeBurnerBlock.HeatLevel.NONE;
    }

    public Couple<SmartFluidTankBehaviour> getTanks() {
        return this.tanks;
    }

    public Couple<SmartInventory> getInvs() {
        return this.invs;
    }

    private void tickVisualizedOutputs() {
        this.visualizedOutputFluids.forEach(LongAttached::decrement);
        this.visualizedOutputItems.forEach(LongAttached::decrement);
        this.visualizedOutputFluids.removeIf(LongAttached::isOrBelowZero);
        this.visualizedOutputItems.removeIf(LongAttached::isOrBelowZero);
    }

    private void createFluidParticles() {
        Random r = this.field_11863.field_9229;
        if (!this.visualizedOutputFluids.isEmpty()) {
            this.createOutputFluidParticles(r);
        }
        if (!this.areFluidsMoving && r.nextFloat() > 0.125f) {
            return;
        }
        int segments = 0;
        for (SmartFluidTankBehaviour behaviour : this.getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                if (tankSegment.isEmpty(0.0f)) continue;
                ++segments;
            }
        }
        if (segments < 2) {
            return;
        }
        float totalUnits = this.getTotalFluidUnits(0.0f);
        if (totalUnits == 0.0f) {
            return;
        }
        float fluidLevel = class_3532.method_15363((float)(totalUnits / 2000.0f), (float)0.0f, (float)1.0f);
        float rim = 0.125f;
        float space = 0.75f;
        float surface = (float)this.field_11867.method_10264() + rim + space * fluidLevel + 0.03125f;
        if (this.areFluidsMoving) {
            this.createMovingFluidParticles(surface, segments);
            return;
        }
        for (SmartFluidTankBehaviour behaviour : this.getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                if (tankSegment.isEmpty(0.0f)) continue;
                float x = (float)this.field_11867.method_10263() + rim + space * r.nextFloat();
                float z = (float)this.field_11867.method_10260() + rim + space * r.nextFloat();
                this.field_11863.method_8494((class_2394)new FluidParticleData(AllParticleTypes.BASIN_FLUID.get(), tankSegment.getRenderedFluid()), (double)x, (double)surface, (double)z, 0.0, 0.0, 0.0);
            }
        }
    }

    private void createOutputFluidParticles(Random r) {
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof BasinBlock)) {
            return;
        }
        class_2350 direction = (class_2350)blockState.method_11654((class_2769)BasinBlock.FACING);
        if (direction == class_2350.field_11033) {
            return;
        }
        class_243 directionVec = class_243.method_24954((class_2382)direction.method_10163());
        class_243 outVec = VecHelper.getCenterOf((class_2382)this.field_11867).method_1019(directionVec.method_1021(0.65).method_1023(0.0, 0.25, 0.0));
        class_243 outMotion = directionVec.method_1021(0.0625).method_1031(0.0, -0.0625, 0.0);
        for (int i = 0; i < 2; ++i) {
            this.visualizedOutputFluids.forEach(ia -> {
                FluidStack fluidStack = (FluidStack)ia.getValue();
                class_2394 fluidParticle = FluidFX.getFluidParticle(fluidStack);
                class_243 m = VecHelper.offsetRandomly(outMotion, r, 0.0625f);
                this.field_11863.method_8494(fluidParticle, outVec.field_1352, outVec.field_1351, outVec.field_1350, m.field_1352, m.field_1351, m.field_1350);
            });
        }
    }

    private void createMovingFluidParticles(float surface, int segments) {
        class_243 pointer = new class_243(1.0, 0.0, 0.0).method_1021(0.0625);
        float interval = 360.0f / (float)segments;
        class_243 centerOf = VecHelper.getCenterOf((class_2382)this.field_11867);
        float intervalOffset = AnimationTickHolder.getTicks() * 18 % 360;
        int currentSegment = 0;
        for (SmartFluidTankBehaviour behaviour : this.getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                if (tankSegment.isEmpty(0.0f)) continue;
                float angle = interval * (float)(1 + currentSegment) + intervalOffset;
                class_243 vec = centerOf.method_1019(VecHelper.rotate(pointer, angle, class_2350.class_2351.field_11052));
                this.field_11863.method_8494((class_2394)new FluidParticleData(AllParticleTypes.BASIN_FLUID.get(), tankSegment.getRenderedFluid()), vec.method_10216(), (double)surface, vec.method_10215(), 1.0, 0.0, 0.0);
                ++currentSegment;
            }
        }
    }

    public boolean areFluidsMoving() {
        return this.areFluidsMoving;
    }

    public boolean setAreFluidsMoving(boolean areFluidsMoving) {
        this.areFluidsMoving = areFluidsMoving;
        this.ingredientRotationSpeed.chase(areFluidsMoving ? 20.0 : 0.0, 0.1f, LerpedFloat.Chaser.EXP);
        return areFluidsMoving;
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getFluidStorage(null));
    }

    @Nullable
    public Storage<FluidVariant> getFluidStorage(@Nullable class_2350 face) {
        return this.fluidCapability;
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 face) {
        return this.itemCapability;
    }

    class BasinValueBox
    extends ValueBoxTransform.Sided {
        BasinValueBox() {
        }

        @Override
        protected class_243 getSouthLocation() {
            return VecHelper.voxelSpace(8.0, 12.0, 15.75);
        }

        @Override
        protected boolean isSideActive(class_2680 state, class_2350 direction) {
            return direction.method_10166().method_10179();
        }
    }

    record Data(List<class_1799> spoutputBuffer, List<FluidStack> spoutputFluidBuffer) {
    }
}

