/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.components.deployer.ManualApplicationRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingOutput;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.contraptions.processing.burner.LitBlazeBurnerBlock;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerContainer;
import io.github.fabricators_of_create.porting_lib.util.DamageSourceHelper;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1160;
import net.minecraft.class_1263;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1498;
import net.minecraft.class_1506;
import net.minecraft.class_1542;
import net.minecraft.class_1560;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3922;
import net.minecraft.class_3956;

public class InWorldProcessing {
    private static final class_1282 FIRE_DAMAGE_SOURCE = DamageSourceHelper.port_lib$createFireDamageSource((String)"create.fan_fire").method_5516();
    private static final class_1282 LAVA_DAMAGE_SOURCE = DamageSourceHelper.port_lib$createFireDamageSource((String)"create.fan_lava").method_5516();
    private static final class_1263 RECIPE_WRAPPER = new ItemStackHandlerContainer(1);
    private static final SplashingWrapper SPLASHING_WRAPPER = new SplashingWrapper();
    private static final HauntingWrapper HAUNTING_WRAPPER = new HauntingWrapper();

    public static boolean canProcess(class_1542 entity, Type type) {
        class_2487 compound;
        if (entity.getExtraCustomData().method_10545("CreateData") && (compound = entity.getExtraCustomData().method_10562("CreateData")).method_10545("Processing")) {
            class_2487 processing = compound.method_10562("Processing");
            if (Type.valueOf(processing.method_10558("Type")) != type) {
                return type.canProcess(entity.method_6983(), entity.field_6002);
            }
            if (processing.method_10550("Time") >= 0) {
                return true;
            }
            if (processing.method_10550("Time") == -1) {
                return false;
            }
        }
        return type.canProcess(entity.method_6983(), entity.field_6002);
    }

    public static boolean isWashable(class_1799 stack, class_1937 world) {
        SPLASHING_WRAPPER.method_5447(0, stack);
        Optional recipe = AllRecipeTypes.SPLASHING.find(SPLASHING_WRAPPER, world);
        return recipe.isPresent();
    }

    public static boolean isHauntable(class_1799 stack, class_1937 world) {
        HAUNTING_WRAPPER.method_5447(0, stack);
        Optional recipe = AllRecipeTypes.HAUNTING.find(HAUNTING_WRAPPER, world);
        return recipe.isPresent();
    }

    public static boolean applyProcessing(class_1542 entity, Type type) {
        if (InWorldProcessing.decrementProcessingTime(entity, type) != 0) {
            return false;
        }
        List<class_1799> stacks = InWorldProcessing.process(entity.method_6983(), type, entity.field_6002);
        if (stacks == null) {
            return false;
        }
        if (stacks.isEmpty()) {
            entity.method_31472();
            return false;
        }
        entity.method_6979(stacks.remove(0));
        for (class_1799 additional : stacks) {
            class_1542 entityIn = new class_1542(entity.field_6002, entity.method_23317(), entity.method_23318(), entity.method_23321(), additional);
            entityIn.method_18799(entity.method_18798());
            entity.field_6002.method_8649((class_1297)entityIn);
        }
        return true;
    }

    public static TransportedItemStackHandlerBehaviour.TransportedResult applyProcessing(TransportedItemStack transported, class_1937 world, Type type) {
        TransportedItemStackHandlerBehaviour.TransportedResult ignore = TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
        if (transported.processedBy != type) {
            int processingTime;
            transported.processedBy = type;
            int timeModifierForStackSize = (transported.stack.method_7947() - 1) / 16 + 1;
            transported.processingTime = processingTime = (Integer)AllConfigs.SERVER.kinetics.inWorldProcessingTime.get() * timeModifierForStackSize + 1;
            if (!type.canProcess(transported.stack, world)) {
                transported.processingTime = -1;
            }
            return ignore;
        }
        if (transported.processingTime == -1) {
            return ignore;
        }
        if (transported.processingTime-- > 0) {
            return ignore;
        }
        List<class_1799> stacks = InWorldProcessing.process(transported.stack, type, world);
        if (stacks == null) {
            return ignore;
        }
        ArrayList<TransportedItemStack> transportedStacks = new ArrayList<TransportedItemStack>();
        for (class_1799 additional : stacks) {
            TransportedItemStack newTransported = transported.getSimilar();
            newTransported.stack = additional.method_7972();
            transportedStacks.add(newTransported);
        }
        return TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(transportedStacks);
    }

    private static List<class_1799> process(class_1799 stack, Type type, class_1937 world) {
        if (type == Type.SPLASHING) {
            SPLASHING_WRAPPER.method_5447(0, stack);
            Optional recipe = AllRecipeTypes.SPLASHING.find(SPLASHING_WRAPPER, world);
            if (recipe.isPresent()) {
                return InWorldProcessing.applyRecipeOn(stack, (class_1860)recipe.get());
            }
            return null;
        }
        if (type == Type.HAUNTING) {
            HAUNTING_WRAPPER.method_5447(0, stack);
            Optional recipe = AllRecipeTypes.HAUNTING.find(HAUNTING_WRAPPER, world);
            if (recipe.isPresent()) {
                return InWorldProcessing.applyRecipeOn(stack, (class_1860)recipe.get());
            }
            return null;
        }
        RECIPE_WRAPPER.method_5447(0, stack);
        Optional smokingRecipe = world.method_8433().method_8132(class_3956.field_17548, RECIPE_WRAPPER, world);
        if (type == Type.BLASTING) {
            if (!smokingRecipe.isPresent()) {
                RECIPE_WRAPPER.method_5447(0, stack);
                Optional smeltingRecipe = world.method_8433().method_8132(class_3956.field_17546, RECIPE_WRAPPER, world);
                if (smeltingRecipe.isPresent()) {
                    return InWorldProcessing.applyRecipeOn(stack, (class_1860)smeltingRecipe.get());
                }
                RECIPE_WRAPPER.method_5447(0, stack);
                Optional blastingRecipe = world.method_8433().method_8132(class_3956.field_17547, RECIPE_WRAPPER, world);
                if (blastingRecipe.isPresent()) {
                    return InWorldProcessing.applyRecipeOn(stack, (class_1860)blastingRecipe.get());
                }
            }
            return Collections.emptyList();
        }
        if (type == Type.SMOKING && smokingRecipe.isPresent()) {
            return InWorldProcessing.applyRecipeOn(stack, (class_1860)smokingRecipe.get());
        }
        return null;
    }

    private static int decrementProcessingTime(class_1542 entity, Type type) {
        class_2487 processing;
        class_2487 createData;
        class_2487 nbt = entity.getExtraCustomData();
        if (!nbt.method_10545("CreateData")) {
            nbt.method_10566("CreateData", (class_2520)new class_2487());
        }
        if (!(createData = nbt.method_10562("CreateData")).method_10545("Processing")) {
            createData.method_10566("Processing", (class_2520)new class_2487());
        }
        if (!(processing = createData.method_10562("Processing")).method_10545("Type") || Type.valueOf(processing.method_10558("Type")) != type) {
            processing.method_10582("Type", type.name());
            int timeModifierForStackSize = (entity.method_6983().method_7947() - 1) / 16 + 1;
            int processingTime = (Integer)AllConfigs.SERVER.kinetics.inWorldProcessingTime.get() * timeModifierForStackSize + 1;
            processing.method_10569("Time", processingTime);
        }
        int value = processing.method_10550("Time") - 1;
        processing.method_10569("Time", value);
        return value;
    }

    public static void applyRecipeOn(class_1542 entity, class_1860<?> recipe) {
        List<class_1799> stacks = InWorldProcessing.applyRecipeOn(entity.method_6983(), recipe);
        if (stacks == null) {
            return;
        }
        if (stacks.isEmpty()) {
            entity.method_31472();
            return;
        }
        entity.method_6979(stacks.remove(0));
        for (class_1799 additional : stacks) {
            class_1542 entityIn = new class_1542(entity.field_6002, entity.method_23317(), entity.method_23318(), entity.method_23321(), additional);
            entityIn.method_18799(entity.method_18798());
            entity.field_6002.method_8649((class_1297)entityIn);
        }
    }

    public static List<class_1799> applyRecipeOn(class_1799 stackIn, class_1860<?> recipe) {
        ArrayList<class_1799> stacks;
        if (recipe instanceof ProcessingRecipe) {
            ProcessingRecipe pr = (ProcessingRecipe)recipe;
            stacks = new ArrayList();
            for (int i = 0; i < stackIn.method_7947(); ++i) {
                List<ProcessingOutput> list;
                if (pr instanceof ManualApplicationRecipe) {
                    ManualApplicationRecipe mar = (ManualApplicationRecipe)pr;
                    list = mar.getRollableResults();
                } else {
                    list = pr.getRollableResults();
                }
                List<ProcessingOutput> outputs = list;
                for (class_1799 stack : pr.rollResults(outputs)) {
                    for (class_1799 previouslyRolled : stacks) {
                        if (stack.method_7960() || !ItemHandlerHelper.canItemStacksStack((class_1799)stack, (class_1799)previouslyRolled)) continue;
                        int amount = Math.min(previouslyRolled.method_7914() - previouslyRolled.method_7947(), stack.method_7947());
                        previouslyRolled.method_7933(amount);
                        stack.method_7934(amount);
                    }
                    if (stack.method_7960()) continue;
                    stacks.add(stack);
                }
            }
        } else {
            class_1799 out = recipe.method_8110().method_7972();
            stacks = ItemHelper.multipliedOutput(stackIn, out);
        }
        return stacks;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Type {
        SPLASHING{

            @Override
            public void spawnParticlesForProcessing(class_1937 level, class_243 pos) {
                if (level.field_9229.nextInt(8) != 0) {
                    return;
                }
                class_1160 color = new Color(22015).asVectorF();
                level.method_8406((class_2394)new class_2390(color, 1.0f), pos.field_1352 + (double)((level.field_9229.nextFloat() - 0.5f) * 0.5f), pos.field_1351 + 0.5, pos.field_1350 + (double)((level.field_9229.nextFloat() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
                level.method_8406((class_2394)class_2398.field_11228, pos.field_1352 + (double)((level.field_9229.nextFloat() - 0.5f) * 0.5f), pos.field_1351 + 0.5, pos.field_1350 + (double)((level.field_9229.nextFloat() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            }

            @Override
            public void affectEntity(class_1297 entity, class_1937 level) {
                if (level.field_9236) {
                    return;
                }
                if (entity instanceof class_1560 || entity.method_5864() == class_1299.field_6047 || entity.method_5864() == class_1299.field_6099) {
                    entity.method_5643(class_1282.field_5859, 2.0f);
                }
                if (entity.method_5809()) {
                    entity.method_5646();
                    level.method_8396(null, entity.method_24515(), class_3417.field_15222, class_3419.field_15254, 0.7f, 1.6f + (level.field_9229.nextFloat() - level.field_9229.nextFloat()) * 0.4f);
                }
            }

            @Override
            public boolean canProcess(class_1799 stack, class_1937 level) {
                return InWorldProcessing.isWashable(stack, level);
            }
        }
        ,
        SMOKING{

            @Override
            public void spawnParticlesForProcessing(class_1937 level, class_243 pos) {
                if (level.field_9229.nextInt(8) != 0) {
                    return;
                }
                level.method_8406((class_2394)class_2398.field_11203, pos.field_1352, pos.field_1351 + 0.25, pos.field_1350, 0.0, 0.0625, 0.0);
            }

            @Override
            public void affectEntity(class_1297 entity, class_1937 level) {
                if (level.field_9236) {
                    return;
                }
                if (!entity.method_5753()) {
                    entity.method_5639(2);
                    entity.method_5643(FIRE_DAMAGE_SOURCE, 2.0f);
                }
            }

            @Override
            public boolean canProcess(class_1799 stack, class_1937 level) {
                RECIPE_WRAPPER.method_5447(0, stack);
                Optional recipe = level.method_8433().method_8132(class_3956.field_17548, RECIPE_WRAPPER, level);
                return recipe.isPresent();
            }
        }
        ,
        HAUNTING{

            @Override
            public void spawnParticlesForProcessing(class_1937 level, class_243 pos) {
                if (level.field_9229.nextInt(8) != 0) {
                    return;
                }
                pos = pos.method_1019(VecHelper.offsetRandomly(class_243.field_1353, level.field_9229, 1.0f).method_18805(1.0, (double)0.05f, 1.0).method_1029().method_1021((double)0.15f));
                level.method_8406((class_2394)class_2398.field_22246, pos.field_1352, pos.field_1351 + (double)0.45f, pos.field_1350, 0.0, 0.0, 0.0);
                if (level.field_9229.nextInt(2) == 0) {
                    level.method_8406((class_2394)class_2398.field_11251, pos.field_1352, pos.field_1351 + 0.25, pos.field_1350, 0.0, 0.0, 0.0);
                }
            }

            @Override
            public void affectEntity(class_1297 entity, class_1937 level) {
                if (level.field_9236) {
                    if (entity instanceof class_1498) {
                        class_243 p = entity.method_30950(0.0f);
                        class_243 v = p.method_1031(0.0, 0.5, 0.0).method_1019(VecHelper.offsetRandomly(class_243.field_1353, level.field_9229, 1.0f).method_18805(1.0, (double)0.2f, 1.0).method_1029().method_1021(1.0));
                        level.method_8406((class_2394)class_2398.field_22246, v.field_1352, v.field_1351, v.field_1350, 0.0, (double)0.1f, 0.0);
                        if (level.field_9229.nextInt(3) == 0) {
                            level.method_8406((class_2394)class_2398.field_11237, p.field_1352, p.field_1351 + 0.5, p.field_1350, (double)((level.field_9229.nextFloat() - 0.5f) * 0.5f), (double)0.1f, (double)((level.field_9229.nextFloat() - 0.5f) * 0.5f));
                        }
                    }
                    return;
                }
                if (entity instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)entity;
                    livingEntity.method_6092(new class_1293(class_1294.field_5919, 30, 0, false, false));
                    livingEntity.method_6092(new class_1293(class_1294.field_5909, 20, 1, false, false));
                }
                if (entity instanceof class_1498) {
                    class_1498 horse = (class_1498)entity;
                    int progress = horse.getExtraCustomData().method_10550("CreateHaunting");
                    if (progress < 100) {
                        if (progress % 10 == 0) {
                            level.method_8396(null, entity.method_24515(), class_3417.field_23060, class_3419.field_15254, 1.0f, 1.5f * (float)progress / 100.0f);
                        }
                        horse.getExtraCustomData().method_10569("CreateHaunting", progress + 1);
                        return;
                    }
                    level.method_8396(null, entity.method_24515(), class_3417.field_15222, class_3419.field_15254, 1.25f, 0.65f);
                    class_1506 skeletonHorse = (class_1506)class_1299.field_6075.method_5883(level);
                    class_2487 serializeNBT = horse.method_5647(new class_2487());
                    serializeNBT.method_10551("UUID");
                    if (!horse.method_6786().method_7960()) {
                        horse.method_5775(horse.method_6786());
                    }
                    NBTSerializer.deserializeNBT((Object)skeletonHorse, (class_2520)serializeNBT);
                    skeletonHorse.method_33574(horse.method_30950(0.0f));
                    level.method_8649((class_1297)skeletonHorse);
                    horse.method_31472();
                }
            }

            @Override
            public boolean canProcess(class_1799 stack, class_1937 level) {
                return InWorldProcessing.isHauntable(stack, level);
            }
        }
        ,
        BLASTING{

            @Override
            public void spawnParticlesForProcessing(class_1937 level, class_243 pos) {
                if (level.field_9229.nextInt(8) != 0) {
                    return;
                }
                level.method_8406((class_2394)class_2398.field_11237, pos.field_1352, pos.field_1351 + 0.25, pos.field_1350, 0.0, 0.0625, 0.0);
            }

            @Override
            public void affectEntity(class_1297 entity, class_1937 level) {
                if (level.field_9236) {
                    return;
                }
                if (!entity.method_5753()) {
                    entity.method_5639(10);
                    entity.method_5643(LAVA_DAMAGE_SOURCE, 4.0f);
                }
            }

            @Override
            public boolean canProcess(class_1799 stack, class_1937 level) {
                RECIPE_WRAPPER.method_5447(0, stack);
                Optional smeltingRecipe = level.method_8433().method_8132(class_3956.field_17546, RECIPE_WRAPPER, level);
                if (smeltingRecipe.isPresent()) {
                    return true;
                }
                RECIPE_WRAPPER.method_5447(0, stack);
                Optional blastingRecipe = level.method_8433().method_8132(class_3956.field_17547, RECIPE_WRAPPER, level);
                if (blastingRecipe.isPresent()) {
                    return true;
                }
                return !stack.method_7909().method_24358();
            }
        }
        ,
        NONE{

            @Override
            public void spawnParticlesForProcessing(class_1937 level, class_243 pos) {
            }

            @Override
            public void affectEntity(class_1297 entity, class_1937 level) {
            }

            @Override
            public boolean canProcess(class_1799 stack, class_1937 level) {
                return false;
            }
        };


        public abstract boolean canProcess(class_1799 var1, class_1937 var2);

        public abstract void spawnParticlesForProcessing(class_1937 var1, class_243 var2);

        public abstract void affectEntity(class_1297 var1, class_1937 var2);

        public static Type byBlock(class_1922 reader, class_2338 pos) {
            class_3610 fluidState = reader.method_8316(pos);
            if (fluidState.method_15772() == class_3612.field_15910 || fluidState.method_15772() == class_3612.field_15909) {
                return SPLASHING;
            }
            class_2680 blockState = reader.method_8320(pos);
            class_2248 block = blockState.method_26204();
            if (block == class_2246.field_22089 || block == class_2246.field_23860 && blockState.method_28500((class_2769)class_3922.field_17352).orElse(false).booleanValue() || AllBlocks.LIT_BLAZE_BURNER.has(blockState) && blockState.method_28500(LitBlazeBurnerBlock.FLAME_TYPE).map(flame -> flame == LitBlazeBurnerBlock.FlameType.SOUL).orElse(false).booleanValue()) {
                return HAUNTING;
            }
            if (block == class_2246.field_10036 || blockState.method_26164(class_3481.field_23799) && blockState.method_28500((class_2769)class_3922.field_17352).orElse(false) != false || AllBlocks.LIT_BLAZE_BURNER.has(blockState) && blockState.method_28500(LitBlazeBurnerBlock.FLAME_TYPE).map(flame -> flame == LitBlazeBurnerBlock.FlameType.REGULAR).orElse(false) != false || BlazeBurnerBlock.getHeatLevelOf(blockState) == BlazeBurnerBlock.HeatLevel.SMOULDERING) {
                return SMOKING;
            }
            if (block == class_2246.field_10164 || BlazeBurnerBlock.getHeatLevelOf(blockState).isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
                return BLASTING;
            }
            return NONE;
        }
    }

    public static class SplashingWrapper
    extends ItemStackHandlerContainer {
        public SplashingWrapper() {
            super(1);
        }
    }

    public static class HauntingWrapper
    extends ItemStackHandlerContainer {
        public HauntingWrapper() {
            super(1);
        }
    }
}

