/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.processing.HeatCondition;
import com.simibubi.create.content.contraptions.processing.ProcessingOutput;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeSerializer;
import com.simibubi.create.foundation.data.SimpleDatagenIngredient;
import com.simibubi.create.foundation.data.recipe.Mods;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.recipe.IRecipeTypeInfo;
import com.tterrag.registrate.util.DataIngredient;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.DefaultResourceConditions;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2073;
import net.minecraft.class_2371;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_6862;

public class ProcessingRecipeBuilder<T extends ProcessingRecipe<?>> {
    protected ProcessingRecipeFactory<T> factory;
    protected ProcessingRecipeParams params;
    protected List<ConditionJsonProvider> recipeConditions;
    public static final long[] SUS_AMOUNTS = new long[]{10L, 250L, 500L, 1000L};

    public ProcessingRecipeBuilder(ProcessingRecipeFactory<T> factory, class_2960 recipeId) {
        this.params = new ProcessingRecipeParams(recipeId);
        this.recipeConditions = new ArrayList<ConditionJsonProvider>();
        this.factory = factory;
    }

    public ProcessingRecipeBuilder<T> withItemIngredients(class_1856 ... ingredients) {
        return this.withItemIngredients((class_2371<class_1856>)class_2371.method_10212((Object)class_1856.field_9017, (Object[])ingredients));
    }

    public ProcessingRecipeBuilder<T> withItemIngredients(class_2371<class_1856> ingredients) {
        this.params.ingredients = ingredients;
        return this;
    }

    public ProcessingRecipeBuilder<T> withSingleItemOutput(class_1799 output) {
        return this.withItemOutputs(new ProcessingOutput(output, 1.0f));
    }

    public ProcessingRecipeBuilder<T> withItemOutputs(ProcessingOutput ... outputs) {
        return this.withItemOutputs((class_2371<ProcessingOutput>)class_2371.method_10212((Object)ProcessingOutput.EMPTY, (Object[])outputs));
    }

    public ProcessingRecipeBuilder<T> withItemOutputs(class_2371<ProcessingOutput> outputs) {
        this.params.results = outputs;
        return this;
    }

    public ProcessingRecipeBuilder<T> withFluidIngredients(FluidIngredient ... ingredients) {
        return this.withFluidIngredients((class_2371<FluidIngredient>)class_2371.method_10212((Object)FluidIngredient.EMPTY, (Object[])ingredients));
    }

    public ProcessingRecipeBuilder<T> withFluidIngredients(class_2371<FluidIngredient> ingredients) {
        this.params.fluidIngredients = ingredients;
        return this;
    }

    public ProcessingRecipeBuilder<T> withFluidOutputs(FluidStack ... outputs) {
        return this.withFluidOutputs((class_2371<FluidStack>)class_2371.method_10212((Object)FluidStack.EMPTY, (Object[])outputs));
    }

    public ProcessingRecipeBuilder<T> withFluidOutputs(class_2371<FluidStack> outputs) {
        this.params.fluidResults = outputs;
        return this;
    }

    public ProcessingRecipeBuilder<T> duration(int ticks) {
        this.params.processingDuration = ticks;
        return this;
    }

    public ProcessingRecipeBuilder<T> averageProcessingDuration() {
        return this.duration(100);
    }

    public ProcessingRecipeBuilder<T> requiresHeat(HeatCondition condition) {
        this.params.requiredHeat = condition;
        return this;
    }

    public T build() {
        this.validateFluidAmounts();
        return this.factory.create(this.params);
    }

    public void build(Consumer<class_2444> consumer) {
        consumer.accept(new DataGenResult<T>(this.build(), this.recipeConditions));
    }

    private void validateFluidAmounts() {
        for (FluidIngredient ingredient : this.params.fluidIngredients) {
            for (long amount : SUS_AMOUNTS) {
                if (ingredient.getRequiredAmount() != amount) continue;
                Create.LOGGER.warn("Suspicious fluid amount in recipe [{}]: {}", (Object)this.params.id, (Object)amount);
            }
        }
    }

    public ProcessingRecipeBuilder<T> require(class_6862<class_1792> tag) {
        return this.require(class_1856.method_8106(tag));
    }

    public ProcessingRecipeBuilder<T> require(class_1935 item) {
        return this.require(class_1856.method_8091((class_1935[])new class_1935[]{item}));
    }

    public ProcessingRecipeBuilder<T> require(class_1856 ingredient) {
        this.params.ingredients.add((Object)ingredient);
        return this;
    }

    public ProcessingRecipeBuilder<T> require(Mods mod, String id) {
        this.params.ingredients.add((Object)new SimpleDatagenIngredient(mod, id));
        return this;
    }

    public ProcessingRecipeBuilder<T> require(class_2960 ingredient) {
        this.params.ingredients.add((Object)DataIngredient.ingredient(null, (class_2960)ingredient, (class_2073[])new class_2073[0]));
        return this;
    }

    public ProcessingRecipeBuilder<T> require(class_3611 fluid, long amount) {
        return this.require(FluidIngredient.fromFluid(fluid, amount));
    }

    public ProcessingRecipeBuilder<T> require(class_6862<class_3611> fluidTag, long amount) {
        return this.require(FluidIngredient.fromTag(fluidTag, amount));
    }

    public ProcessingRecipeBuilder<T> require(FluidIngredient ingredient) {
        this.params.fluidIngredients.add((Object)ingredient);
        return this;
    }

    public ProcessingRecipeBuilder<T> output(class_1935 item) {
        return this.output(item, 1);
    }

    public ProcessingRecipeBuilder<T> output(float chance, class_1935 item) {
        return this.output(chance, item, 1);
    }

    public ProcessingRecipeBuilder<T> output(class_1935 item, int amount) {
        return this.output(1.0f, item, amount);
    }

    public ProcessingRecipeBuilder<T> output(float chance, class_1935 item, int amount) {
        return this.output(chance, new class_1799(item, amount));
    }

    public ProcessingRecipeBuilder<T> output(class_1799 output) {
        return this.output(1.0f, output);
    }

    public ProcessingRecipeBuilder<T> output(float chance, class_1799 output) {
        return this.output(new ProcessingOutput(output, chance));
    }

    public ProcessingRecipeBuilder<T> output(float chance, Mods mod, String id, int amount) {
        return this.output(new ProcessingOutput(Pair.of(mod.asResource(id), amount), chance));
    }

    public ProcessingRecipeBuilder<T> output(float chance, class_2960 registryName, int amount) {
        return this.output(new ProcessingOutput(Pair.of(registryName, amount), chance));
    }

    public ProcessingRecipeBuilder<T> output(ProcessingOutput output) {
        this.params.results.add((Object)output);
        return this;
    }

    public ProcessingRecipeBuilder<T> output(class_3611 fluid, long amount) {
        fluid = FluidHelper.convertToStill(fluid);
        return this.output(new FluidStack(fluid, amount));
    }

    public ProcessingRecipeBuilder<T> output(FluidStack fluidStack) {
        this.params.fluidResults.add((Object)fluidStack);
        return this;
    }

    public ProcessingRecipeBuilder<T> toolNotConsumed() {
        this.params.keepHeldItem = true;
        return this;
    }

    public ProcessingRecipeBuilder<T> whenModLoaded(String modid) {
        return this.withCondition(DefaultResourceConditions.allModsLoaded((String[])new String[]{modid}));
    }

    public ProcessingRecipeBuilder<T> whenModMissing(String modid) {
        return this.withCondition(DefaultResourceConditions.not((ConditionJsonProvider)DefaultResourceConditions.allModsLoaded((String[])new String[]{modid})));
    }

    public ProcessingRecipeBuilder<T> withCondition(ConditionJsonProvider condition) {
        this.recipeConditions.add(condition);
        return this;
    }

    public static class ProcessingRecipeParams {
        protected class_2960 id;
        protected class_2371<class_1856> ingredients;
        protected class_2371<ProcessingOutput> results;
        protected class_2371<FluidIngredient> fluidIngredients;
        protected class_2371<FluidStack> fluidResults;
        protected int processingDuration;
        protected HeatCondition requiredHeat;
        public boolean keepHeldItem;

        protected ProcessingRecipeParams(class_2960 id) {
            this.id = id;
            this.ingredients = class_2371.method_10211();
            this.results = class_2371.method_10211();
            this.fluidIngredients = class_2371.method_10211();
            this.fluidResults = class_2371.method_10211();
            this.processingDuration = 0;
            this.requiredHeat = HeatCondition.NONE;
            this.keepHeldItem = false;
        }
    }

    @FunctionalInterface
    public static interface ProcessingRecipeFactory<T extends ProcessingRecipe<?>> {
        public T create(ProcessingRecipeParams var1);
    }

    public static class DataGenResult<S extends ProcessingRecipe<?>>
    implements class_2444 {
        private List<ConditionJsonProvider> recipeConditions;
        private ProcessingRecipeSerializer<S> serializer;
        private class_2960 id;
        private S recipe;

        public DataGenResult(S recipe, List<ConditionJsonProvider> recipeConditions) {
            this.recipe = recipe;
            this.recipeConditions = recipeConditions;
            IRecipeTypeInfo recipeType = ((ProcessingRecipe)this.recipe).getTypeInfo();
            class_2960 typeId = recipeType.getId();
            if (!(recipeType.getSerializer() instanceof ProcessingRecipeSerializer)) {
                throw new IllegalStateException("Cannot datagen ProcessingRecipe of type: " + typeId);
            }
            this.id = new class_2960(((ProcessingRecipe)recipe).method_8114().method_12836(), typeId.method_12832() + "/" + ((ProcessingRecipe)recipe).method_8114().method_12832());
            this.serializer = (ProcessingRecipeSerializer)((ProcessingRecipe)recipe).method_8119();
        }

        public void method_10416(JsonObject json) {
            this.serializer.write(json, this.recipe);
            if (this.recipeConditions.isEmpty()) {
                return;
            }
            JsonArray conds = new JsonArray();
            this.recipeConditions.forEach(c -> conds.add((JsonElement)c.toJson()));
            json.add("fabric:load_conditions", (JsonElement)conds);
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public class_1865<?> method_17800() {
            return this.serializer;
        }

        public JsonObject method_10415() {
            return null;
        }

        public class_2960 method_10418() {
            return null;
        }
    }
}

