/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.advanced.sequencer;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.relays.advanced.sequencer.ConfigureSequencedGearshiftPacket;
import com.simibubi.create.content.contraptions.relays.advanced.sequencer.Instruction;
import com.simibubi.create.content.contraptions.relays.advanced.sequencer.InstructionSpeedModifiers;
import com.simibubi.create.content.contraptions.relays.advanced.sequencer.SequencedGearshiftTileEntity;
import com.simibubi.create.content.contraptions.relays.advanced.sequencer.SequencerInstructions;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Vector;
import me.pepperbell.simplenetworking.C2SPacket;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class SequencedGearshiftScreen
extends AbstractSimiScreen {
    private final class_1799 renderedItem = AllBlocks.SEQUENCED_GEARSHIFT.asStack();
    private final AllGuiTextures background = AllGuiTextures.SEQUENCER;
    private IconButton confirmButton;
    private class_2499 compareTag;
    private Vector<Instruction> instructions;
    private class_2338 pos;
    private Vector<Vector<ScrollInput>> inputs;

    public SequencedGearshiftScreen(SequencedGearshiftTileEntity te) {
        super((class_2561)Lang.translateDirect("gui.sequenced_gearshift.title", new Object[0]));
        this.instructions = te.instructions;
        this.pos = te.method_11016();
        this.compareTag = Instruction.serializeAll(this.instructions);
    }

    @Override
    protected void method_25426() {
        int row;
        this.setWindowSize(this.background.width, this.background.height);
        this.setWindowOffset(-20, 0);
        super.method_25426();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.inputs = new Vector(5);
        for (row = 0; row < this.inputs.capacity(); ++row) {
            this.inputs.add(new Vector(3));
        }
        for (row = 0; row < this.instructions.size(); ++row) {
            this.initInputsOfRow(row, x, y);
        }
        this.confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.method_25419());
        this.method_37063(this.confirmButton);
    }

    public void initInputsOfRow(int row, int backgroundX, int backgroundY) {
        int x = backgroundX + 30;
        int y = backgroundY + 18;
        int rowHeight = 22;
        Vector<ScrollInput> rowInputs = this.inputs.get(row);
        this.removeWidgets(rowInputs);
        rowInputs.clear();
        int index = row;
        Instruction instruction = this.instructions.get(row);
        ScrollInput type = new SelectionScrollInput(x, y + rowHeight * row, 50, 18).forOptions(SequencerInstructions.getOptions()).calling(state -> this.instructionUpdated(index, (int)state)).setState(instruction.instruction.ordinal()).titled(Lang.translateDirect("gui.sequenced_gearshift.instruction", new Object[0]));
        ScrollInput value = new ScrollInput(x + 58, y + rowHeight * row, 28, 18).calling(state -> {
            instruction.value = state;
        });
        ScrollInput direction = new SelectionScrollInput(x + 88, y + rowHeight * row, 28, 18).forOptions(InstructionSpeedModifiers.getOptions()).calling(state -> {
            instruction.speedModifier = InstructionSpeedModifiers.values()[state];
        }).titled(Lang.translateDirect("gui.sequenced_gearshift.speed", new Object[0]));
        rowInputs.add(type);
        rowInputs.add(value);
        rowInputs.add(direction);
        this.addRenderableWidgets(rowInputs);
        this.updateParamsOfRow(row);
    }

    public void updateParamsOfRow(int row) {
        Instruction instruction = this.instructions.get(row);
        Vector<ScrollInput> rowInputs = this.inputs.get(row);
        SequencerInstructions def = instruction.instruction;
        boolean hasValue = def.hasValueParameter;
        boolean hasModifier = def.hasSpeedParameter;
        ScrollInput value = rowInputs.get(1);
        value.field_22763 = value.field_22764 = hasValue;
        if (hasValue) {
            value.withRange(1, def.maxValue + 1).titled(Lang.translateDirect(def.parameterKey, new Object[0])).withShiftStep(def.shiftStep).setState(instruction.value).onChanged();
        }
        if (def == SequencerInstructions.DELAY) {
            value.withStepFunction(context -> {
                int v = context.currentValue;
                if (!context.forward) {
                    --v;
                }
                if (v < 20) {
                    return context.shift ? 20 : 1;
                }
                return context.shift ? 100 : 20;
            });
        } else {
            value.withStepFunction(value.standardStep());
        }
        ScrollInput modifier = rowInputs.get(2);
        modifier.field_22763 = modifier.field_22764 = hasModifier;
        if (hasModifier) {
            modifier.setState(instruction.speedModifier.ordinal());
        }
    }

    @Override
    protected void renderWindow(class_4587 ms, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(ms, x, y, (class_332)this);
        for (int row = 0; row < this.instructions.capacity(); ++row) {
            AllGuiTextures toDraw = AllGuiTextures.SEQUENCER_EMPTY;
            int yOffset = toDraw.height * row;
            if (row >= this.instructions.size()) {
                toDraw.render(ms, x, y + 14 + yOffset, (class_332)this);
                continue;
            }
            Instruction instruction = this.instructions.get(row);
            SequencerInstructions def = instruction.instruction;
            def.background.render(ms, x, y + 14 + yOffset, (class_332)this);
            this.label(ms, 36, yOffset - 3, (class_2561)Lang.translateDirect(def.translationKey, new Object[0]));
            if (def.hasValueParameter) {
                String text = def.formatValue(instruction.value);
                int stringWidth = this.field_22793.method_1727(text);
                this.label(ms, 90 + (12 - stringWidth / 2), yOffset - 3, (class_2561)Components.literal(text));
            }
            if (!def.hasSpeedParameter) continue;
            this.label(ms, 127, yOffset - 3, instruction.speedModifier.label);
        }
        SequencedGearshiftScreen.method_27534((class_4587)ms, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(x + (this.background.width - 8) / 2), (int)(y + 3), (int)0xFFFFFF);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of(this.renderedItem).at(x + this.background.width + 6, y + this.background.height - 56, -200.0f)).scale(5.0).render(ms);
    }

    private void label(class_4587 ms, int x, int y, class_2561 text) {
        this.field_22793.method_30881(ms, text, (float)(this.guiLeft + x), (float)(this.guiTop + 26 + y), 0xFFFFEE);
    }

    public void sendPacket() {
        class_2499 serialized = Instruction.serializeAll(this.instructions);
        if (serialized.equals((Object)this.compareTag)) {
            return;
        }
        AllPackets.channel.sendToServer((C2SPacket)new ConfigureSequencedGearshiftPacket(this.pos, serialized));
    }

    public void method_25432() {
        this.sendPacket();
    }

    private void instructionUpdated(int index, int state) {
        SequencerInstructions newValue;
        this.instructions.get((int)index).instruction = newValue = SequencerInstructions.values()[state];
        this.instructions.get((int)index).value = newValue.defaultValue;
        this.updateParamsOfRow(index);
        if (newValue == SequencerInstructions.END) {
            for (int i = this.instructions.size() - 1; i > index; --i) {
                this.instructions.remove(i);
                Vector<ScrollInput> rowInputs = this.inputs.get(i);
                this.removeWidgets(rowInputs);
                rowInputs.clear();
            }
        } else if (index + 1 < this.instructions.capacity() && index + 1 == this.instructions.size()) {
            this.instructions.add(new Instruction(SequencerInstructions.END));
            this.initInputsOfRow(index + 1, this.guiLeft, this.guiTop);
        }
    }
}

