/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.advanced.sequencer;

import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;

public enum SequencerInstructions {
    TURN_ANGLE("angle", AllGuiTextures.SEQUENCER_INSTRUCTION, true, true, 360, 45, 90),
    TURN_DISTANCE("distance", AllGuiTextures.SEQUENCER_INSTRUCTION, true, true, 128, 5, 5),
    DELAY("duration", AllGuiTextures.SEQUENCER_DELAY, true, false, 600, 20, 10),
    AWAIT("", AllGuiTextures.SEQUENCER_AWAIT),
    END("", AllGuiTextures.SEQUENCER_END);

    String translationKey;
    String descriptiveTranslationKey;
    String parameterKey;
    boolean hasValueParameter;
    boolean hasSpeedParameter;
    AllGuiTextures background;
    int maxValue;
    int shiftStep;
    int defaultValue;

    private SequencerInstructions(String parameterName, AllGuiTextures background) {
        this(parameterName, background, false, false, -1, -1, -1);
    }

    private SequencerInstructions(String parameterName, AllGuiTextures background, boolean hasValueParameter, boolean hasSpeedParameter, int maxValue, int shiftStep, int defaultValue) {
        this.hasValueParameter = hasValueParameter;
        this.hasSpeedParameter = hasSpeedParameter;
        this.background = background;
        this.maxValue = maxValue;
        this.shiftStep = shiftStep;
        this.defaultValue = defaultValue;
        this.translationKey = "gui.sequenced_gearshift.instruction." + Lang.asId(this.name());
        this.descriptiveTranslationKey = this.translationKey + ".descriptive";
        this.parameterKey = this.translationKey + "." + parameterName;
    }

    static List<class_2561> getOptions() {
        ArrayList<class_2561> options = new ArrayList<class_2561>();
        for (SequencerInstructions entry : SequencerInstructions.values()) {
            options.add((class_2561)Lang.translateDirect(entry.descriptiveTranslationKey, new Object[0]));
        }
        return options;
    }

    String formatValue(int value) {
        if (this == TURN_ANGLE) {
            return value + Lang.translateDirect("generic.unit.degrees", new Object[0]).getString();
        }
        if (this == TURN_DISTANCE) {
            return value + "m";
        }
        if (this == DELAY) {
            if (value >= 20) {
                return value / 20 + "s";
            }
            return value + "t";
        }
        return "" + value;
    }
}

