/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.belt;

import com.jozufozu.flywheel.backend.instancing.InstancedRenderDispatcher;
import com.jozufozu.flywheel.light.LightListener;
import com.jozufozu.flywheel.light.LightUpdater;
import com.jozufozu.flywheel.util.box.GridAlignedBB;
import com.jozufozu.flywheel.util.box.ImmutableBox;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.BeltPart;
import com.simibubi.create.content.contraptions.relays.belt.BeltSlope;
import com.simibubi.create.content.contraptions.relays.belt.transport.BeltInventory;
import com.simibubi.create.content.contraptions.relays.belt.transport.BeltMovementHandler;
import com.simibubi.create.content.contraptions.relays.belt.transport.BeltTunnelInteractionHandler;
import com.simibubi.create.content.contraptions.relays.belt.transport.ItemHandlerBeltSegment;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.block.belts.tunnel.BrassTunnelTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.tterrag.registrate.fabric.EnvExecutor;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemTransferable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1944;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_765;
import org.jetbrains.annotations.Nullable;

public class BeltTileEntity
extends KineticTileEntity
implements ItemTransferable,
RenderAttachmentBlockEntity {
    public Map<class_1297, BeltMovementHandler.TransportedEntityInfo> passengers;
    public Optional<class_1767> color;
    public int beltLength;
    public int index;
    public class_2350 lastInsert;
    public CasingType casing;
    protected class_2338 controller = class_2338.field_10980;
    protected BeltInventory inventory;
    protected Storage<ItemVariant> itemHandler = null;
    public class_2487 trackerUpdateTag;
    @Environment(value=EnvType.CLIENT)
    public BeltLighter lighter;

    public BeltTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.casing = CasingType.NONE;
        this.color = Optional.empty();
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.add(new DirectBeltInputBehaviour(this).onlyInsertWhen(this::canInsertFrom).setInsertionHandler(this::tryInsertingFromSide));
        behaviours.add(new TransportedItemStackHandlerBehaviour(this, this::applyToAllItems).withStackPlacement(this::getWorldPositionOf));
    }

    @Override
    public void tick() {
        if (this.beltLength == 0) {
            BeltBlock.initBelt(this.field_11863, this.field_11867);
        }
        super.tick();
        if (!AllBlocks.BELT.has(this.field_11863.method_8320(this.field_11867))) {
            return;
        }
        this.initializeItemHandler();
        if (!this.isController()) {
            return;
        }
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> {
            if (this.beltLength > 0 && this.lighter == null) {
                this.lighter = new BeltLighter();
            }
        });
        this.invalidateRenderBoundingBox();
        this.getInventory().tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.passengers == null) {
            this.passengers = new HashMap<class_1297, BeltMovementHandler.TransportedEntityInfo>();
        }
        ArrayList toRemove = new ArrayList();
        this.passengers.forEach((entity, info) -> {
            boolean leftTheBelt;
            boolean canBeTransported = BeltMovementHandler.canBeTransported(entity);
            boolean bl = leftTheBelt = info.getTicksSinceLastCollision() > (this.method_11010().method_11654(BeltBlock.SLOPE) != BeltSlope.HORIZONTAL ? 3 : 1);
            if (!canBeTransported || leftTheBelt) {
                toRemove.add(entity);
                return;
            }
            info.tick();
            BeltMovementHandler.transportEntity(this, entity, info);
        });
        toRemove.forEach(this.passengers::remove);
    }

    @Override
    public float calculateStressApplied() {
        if (!this.isController()) {
            return 0.0f;
        }
        return super.calculateStressApplied();
    }

    @Override
    public class_238 createRenderBoundingBox() {
        if (!this.isController()) {
            return super.createRenderBoundingBox();
        }
        return super.createRenderBoundingBox().method_1014((double)(this.beltLength + 1));
    }

    protected void initializeItemHandler() {
        if (this.field_11863.field_9236 || this.itemHandler != null) {
            return;
        }
        if (this.beltLength == 0 || this.controller == null) {
            return;
        }
        if (!this.field_11863.method_8477(this.controller)) {
            return;
        }
        class_2586 te = this.field_11863.method_8321(this.controller);
        if (te == null || !(te instanceof BeltTileEntity)) {
            return;
        }
        BeltInventory inventory = ((BeltTileEntity)te).getInventory();
        if (inventory == null) {
            return;
        }
        this.itemHandler = new ItemHandlerBeltSegment(inventory, this.index);
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 direction) {
        if (!this.method_11015() && this.itemHandler == null) {
            this.initializeItemHandler();
        }
        if (direction == class_2350.field_11036 || BeltBlock.canAccessFromSide(direction, this.method_11010())) {
            return this.itemHandler;
        }
        return null;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.isController()) {
            this.getInventory().ejectAll();
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.itemHandler = null;
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        if (this.controller != null) {
            compound.method_10566("Controller", (class_2520)class_2512.method_10692((class_2338)this.controller));
        }
        compound.method_10556("IsController", this.isController());
        compound.method_10569("Length", this.beltLength);
        compound.method_10569("Index", this.index);
        NBTHelper.writeEnum(compound, "Casing", this.casing);
        if (this.color.isPresent()) {
            NBTHelper.writeEnum(compound, "Dye", this.color.get());
        }
        if (this.isController()) {
            compound.method_10566("Inventory", (class_2520)this.getInventory().write());
        }
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        int prevBeltLength = this.beltLength;
        super.read(compound, clientPacket);
        if (compound.method_10577("IsController")) {
            this.controller = this.field_11867;
        }
        Optional<Object> optional = this.color = compound.method_10545("Dye") ? Optional.of(NBTHelper.readEnum(compound, "Dye", class_1767.class)) : Optional.empty();
        if (!this.wasMoved) {
            if (!this.isController()) {
                this.controller = class_2512.method_10691((class_2487)compound.method_10562("Controller"));
            }
            this.trackerUpdateTag = compound;
            this.index = compound.method_10550("Index");
            this.beltLength = compound.method_10550("Length");
            if (prevBeltLength != this.beltLength) {
                EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> {
                    if (this.lighter != null) {
                        this.lighter.initializeLight();
                    }
                });
            }
        }
        if (this.isController()) {
            this.getInventory().read(compound.method_10562("Inventory"));
        }
        CasingType casingBefore = this.casing;
        this.casing = NBTHelper.readEnum(compound, "Casing", CasingType.class);
        if (!clientPacket) {
            return;
        }
        if (casingBefore == this.casing) {
            return;
        }
        if (!this.isVirtual()) {
            this.requestModelDataUpdate();
        }
        if (this.method_11002()) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 16);
        }
    }

    @Override
    public void clearKineticInformation() {
        super.clearKineticInformation();
        this.beltLength = 0;
        this.index = 0;
        this.controller = null;
        this.trackerUpdateTag = new class_2487();
    }

    public void applyColor(class_1767 colorIn) {
        if (colorIn == null ? !this.color.isPresent() : this.color.isPresent() && this.color.get() == colorIn) {
            return;
        }
        for (class_2338 blockPos : BeltBlock.getBeltChain(this.field_11863, this.getController())) {
            BeltTileEntity belt = BeltHelper.getSegmentTE((class_1936)this.field_11863, blockPos);
            if (belt == null) continue;
            belt.color = Optional.ofNullable(colorIn);
            belt.method_5431();
            belt.sendData();
            EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> InstancedRenderDispatcher.enqueueUpdate((class_2586)belt));
        }
    }

    public BeltTileEntity getControllerTE() {
        if (this.controller == null) {
            return null;
        }
        if (!this.field_11863.method_8477(this.controller)) {
            return null;
        }
        class_2586 te = this.field_11863.method_8321(this.controller);
        if (te == null || !(te instanceof BeltTileEntity)) {
            return null;
        }
        return (BeltTileEntity)te;
    }

    public void setController(class_2338 controller) {
        this.controller = controller;
    }

    public class_2338 getController() {
        return this.controller == null ? this.field_11867 : this.controller;
    }

    public boolean isController() {
        return this.controller != null && this.field_11867.method_10263() == this.controller.method_10263() && this.field_11867.method_10264() == this.controller.method_10264() && this.field_11867.method_10260() == this.controller.method_10260();
    }

    public float getBeltMovementSpeed() {
        return this.getSpeed() / 480.0f;
    }

    public float getDirectionAwareBeltMovementSpeed() {
        int offset = this.getBeltFacing().method_10171().method_10181();
        if (this.getBeltFacing().method_10166() == class_2350.class_2351.field_11048) {
            offset *= -1;
        }
        return this.getBeltMovementSpeed() * (float)offset;
    }

    public boolean hasPulley() {
        if (!AllBlocks.BELT.has(this.method_11010())) {
            return false;
        }
        return this.method_11010().method_11654(BeltBlock.PART) != BeltPart.MIDDLE;
    }

    protected boolean isLastBelt() {
        if (this.getSpeed() == 0.0f) {
            return false;
        }
        class_2350 direction = this.getBeltFacing();
        if (this.method_11010().method_11654(BeltBlock.SLOPE) == BeltSlope.VERTICAL) {
            return false;
        }
        BeltPart part = (BeltPart)((Object)this.method_11010().method_11654(BeltBlock.PART));
        if (part == BeltPart.MIDDLE) {
            return false;
        }
        boolean movingPositively = this.getSpeed() > 0.0f == (direction.method_10171().method_10181() == 1) ^ direction.method_10166() == class_2350.class_2351.field_11048;
        return part == BeltPart.START ^ movingPositively;
    }

    public class_2382 getMovementDirection(boolean firstHalf) {
        return this.getMovementDirection(firstHalf, false);
    }

    public class_2382 getBeltChainDirection() {
        return this.getMovementDirection(true, true);
    }

    protected class_2382 getMovementDirection(boolean firstHalf, boolean ignoreHalves) {
        boolean movingUp;
        boolean onSlope;
        boolean notHorizontal;
        if (this.getSpeed() == 0.0f) {
            return class_2338.field_10980;
        }
        class_2680 blockState = this.method_11010();
        class_2350 beltFacing = (class_2350)blockState.method_11654((class_2769)class_2741.field_12481);
        BeltSlope slope = (BeltSlope)((Object)blockState.method_11654(BeltBlock.SLOPE));
        BeltPart part = (BeltPart)((Object)blockState.method_11654(BeltBlock.PART));
        class_2350.class_2351 axis = beltFacing.method_10166();
        class_2350 movementFacing = class_2350.method_10156((class_2350.class_2352)(axis == class_2350.class_2351.field_11048 ? class_2350.class_2352.field_11060 : class_2350.class_2352.field_11056), (class_2350.class_2351)axis);
        boolean bl = notHorizontal = blockState.method_11654(BeltBlock.SLOPE) != BeltSlope.HORIZONTAL;
        if (this.getSpeed() < 0.0f) {
            movementFacing = movementFacing.method_10153();
        }
        class_2382 movement = movementFacing.method_10163();
        boolean slopeBeforeHalf = part == BeltPart.END == (beltFacing.method_10171() == class_2350.class_2352.field_11056);
        boolean bl2 = onSlope = notHorizontal && (part == BeltPart.MIDDLE || slopeBeforeHalf == firstHalf || ignoreHalves);
        boolean bl3 = onSlope && slope == (movementFacing == beltFacing ? BeltSlope.UPWARD : BeltSlope.DOWNWARD) ? true : (movingUp = false);
        if (!onSlope) {
            return movement;
        }
        return new class_2382(movement.method_10263(), movingUp ? 1 : -1, movement.method_10260());
    }

    public class_2350 getMovementFacing() {
        class_2350.class_2351 axis = this.getBeltFacing().method_10166();
        return class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)(this.getBeltMovementSpeed() < 0.0f ^ axis == class_2350.class_2351.field_11048 ? class_2350.class_2352.field_11060 : class_2350.class_2352.field_11056));
    }

    protected class_2350 getBeltFacing() {
        return (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12481);
    }

    public BeltInventory getInventory() {
        if (!this.isController()) {
            BeltTileEntity controllerTE = this.getControllerTE();
            if (controllerTE != null) {
                return controllerTE.getInventory();
            }
            return null;
        }
        if (this.inventory == null) {
            this.inventory = new BeltInventory(this);
        }
        return this.inventory;
    }

    private void applyToAllItems(float maxDistanceFromCenter, Function<TransportedItemStack, TransportedItemStackHandlerBehaviour.TransportedResult> processFunction) {
        BeltTileEntity controller = this.getControllerTE();
        if (controller == null) {
            return;
        }
        BeltInventory inventory = controller.getInventory();
        if (inventory != null) {
            inventory.applyToEachWithin((float)this.index + 0.5f, maxDistanceFromCenter, processFunction);
        }
    }

    private class_243 getWorldPositionOf(TransportedItemStack transported) {
        BeltTileEntity controllerTE = this.getControllerTE();
        if (controllerTE == null) {
            return class_243.field_1353;
        }
        return BeltHelper.getVectorForOffset(controllerTE, transported.beltPosition);
    }

    public void setCasingType(CasingType type) {
        if (this.casing == type) {
            return;
        }
        if (this.casing != CasingType.NONE) {
            this.field_11863.method_20290(2001, this.field_11867, class_2248.method_9507((class_2680)(this.casing == CasingType.ANDESITE ? AllBlocks.ANDESITE_CASING.getDefaultState() : AllBlocks.BRASS_CASING.getDefaultState())));
        }
        this.casing = type;
        boolean shouldBlockHaveCasing = type != CasingType.NONE;
        class_2680 blockState = this.method_11010();
        if ((Boolean)blockState.method_11654((class_2769)BeltBlock.CASING) != shouldBlockHaveCasing) {
            KineticTileEntity.switchToBlockState(this.field_11863, this.field_11867, (class_2680)blockState.method_11657((class_2769)BeltBlock.CASING, (Comparable)Boolean.valueOf(shouldBlockHaveCasing)));
        }
        this.method_5431();
        this.sendData();
    }

    private boolean canInsertFrom(class_2350 side) {
        if (this.getSpeed() == 0.0f) {
            return false;
        }
        class_2680 state = this.method_11010();
        if (state.method_28498(BeltBlock.SLOPE) && (state.method_11654(BeltBlock.SLOPE) == BeltSlope.SIDEWAYS || state.method_11654(BeltBlock.SLOPE) == BeltSlope.VERTICAL)) {
            return false;
        }
        return this.getMovementFacing() != side.method_10153();
    }

    private class_1799 tryInsertingFromSide(TransportedItemStack transportedStack, class_2350 side, boolean simulate) {
        BrassTunnelTileEntity tunnelTE;
        BeltTileEntity nextBeltController = this.getControllerTE();
        class_1799 inserted = transportedStack.stack;
        class_1799 empty = class_1799.field_8037;
        if (nextBeltController == null) {
            return inserted;
        }
        BeltInventory nextInventory = nextBeltController.getInventory();
        if (nextInventory == null) {
            return inserted;
        }
        class_2586 teAbove = this.field_11863.method_8321(this.field_11867.method_10084());
        if (teAbove instanceof BrassTunnelTileEntity && (tunnelTE = (BrassTunnelTileEntity)teAbove).hasDistributionBehaviour()) {
            if (!tunnelTE.getStackToDistribute().method_7960()) {
                return inserted;
            }
            if (!tunnelTE.testFlapFilter(side.method_10153(), inserted)) {
                return inserted;
            }
            if (!simulate) {
                BeltTunnelInteractionHandler.flapTunnel(nextInventory, this.index, side.method_10153(), true);
                tunnelTE.setStackToDistribute(inserted, side.method_10153(), null);
            }
            return empty;
        }
        if (this.getSpeed() == 0.0f) {
            return inserted;
        }
        if (this.getMovementFacing() == side.method_10153()) {
            return inserted;
        }
        if (!nextInventory.canInsertAtFromSide(this.index, side)) {
            return inserted;
        }
        if (simulate) {
            return empty;
        }
        transportedStack = transportedStack.copy();
        transportedStack.beltPosition = (float)this.index + 0.5f - Math.signum(this.getDirectionAwareBeltMovementSpeed()) / 16.0f;
        class_2350 movementFacing = this.getMovementFacing();
        if (!side.method_10166().method_10178()) {
            if (movementFacing != side) {
                transportedStack.sideOffset = (float)side.method_10171().method_10181() * 0.35f;
                if (side.method_10166() == class_2350.class_2351.field_11048) {
                    transportedStack.sideOffset *= -1.0f;
                }
            } else {
                transportedStack.beltPosition = this.getDirectionAwareBeltMovementSpeed() > 0.0f ? (float)this.index : (float)(this.index + 1);
            }
        }
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.insertedAt = this.index;
        transportedStack.insertedFrom = side;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        BeltTunnelInteractionHandler.flapTunnel(nextInventory, this.index, side.method_10153(), true);
        nextInventory.addItem(transportedStack);
        nextBeltController.method_5431();
        nextBeltController.sendData();
        return empty;
    }

    public CasingType getRenderAttachmentData() {
        return this.casing;
    }

    @Override
    protected boolean canPropagateDiagonally(IRotate block, class_2680 state) {
        return state.method_28498(BeltBlock.SLOPE) && (state.method_11654(BeltBlock.SLOPE) == BeltSlope.UPWARD || state.method_11654(BeltBlock.SLOPE) == BeltSlope.DOWNWARD);
    }

    @Override
    public float propagateRotationTo(KineticTileEntity target, class_2680 stateFrom, class_2680 stateTo, class_2338 diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        if (target instanceof BeltTileEntity && !connectedViaAxes) {
            return this.getController().equals((Object)((BeltTileEntity)target).getController()) ? 1.0f : 0.0f;
        }
        return 0.0f;
    }

    public void invalidateItemHandler() {
        this.itemHandler = null;
    }

    public boolean shouldRenderNormally() {
        if (this.field_11863 == null) {
            return this.isController();
        }
        class_2680 state = this.method_11010();
        return state != null && state.method_28498(BeltBlock.PART) && state.method_11654(BeltBlock.PART) == BeltPart.START;
    }

    public static enum CasingType {
        NONE,
        ANDESITE,
        BRASS;

    }

    @Environment(value=EnvType.CLIENT)
    class BeltLighter
    implements LightListener {
        private byte[] light;

        public BeltLighter() {
            this.initializeLight();
            LightUpdater.get((class_1936)BeltTileEntity.this.field_11863).addListener((LightListener)this);
        }

        public int lightSegments() {
            return this.light == null ? 0 : this.light.length / 2;
        }

        public int getPackedLight(int segment) {
            return this.light == null ? 0 : class_765.method_23687((int)this.light[segment * 2], (int)this.light[segment * 2 + 1]);
        }

        public GridAlignedBB getVolume() {
            class_2338 endPos = BeltHelper.getPositionForOffset(BeltTileEntity.this, BeltTileEntity.this.beltLength - 1);
            GridAlignedBB bb = GridAlignedBB.from((class_2338)BeltTileEntity.this.field_11867, (class_2338)endPos);
            bb.fixMinMax();
            return bb;
        }

        public boolean isListenerInvalid() {
            return BeltTileEntity.this.field_11865;
        }

        public void onLightUpdate(class_1944 type, ImmutableBox changed) {
            if (BeltTileEntity.this.field_11865) {
                return;
            }
            if (BeltTileEntity.this.field_11863 == null) {
                return;
            }
            GridAlignedBB beltVolume = this.getVolume();
            if (beltVolume.intersects(changed)) {
                if (type == class_1944.field_9282) {
                    this.updateBlockLight();
                }
                if (type == class_1944.field_9284) {
                    this.updateSkyLight();
                }
            }
        }

        private void initializeLight() {
            this.light = new byte[BeltTileEntity.this.beltLength * 2];
            class_2382 vec = BeltTileEntity.this.getBeltFacing().method_10163();
            BeltSlope slope = (BeltSlope)((Object)BeltTileEntity.this.method_11010().method_11654(BeltBlock.SLOPE));
            int verticality = slope == BeltSlope.DOWNWARD ? -1 : (slope == BeltSlope.UPWARD ? 1 : 0);
            class_2338.class_2339 pos = new class_2338.class_2339(BeltTileEntity.this.controller.method_10263(), BeltTileEntity.this.controller.method_10264(), BeltTileEntity.this.controller.method_10260());
            for (int i = 0; i < BeltTileEntity.this.beltLength * 2; i += 2) {
                this.light[i] = (byte)BeltTileEntity.this.field_11863.method_8314(class_1944.field_9282, (class_2338)pos);
                this.light[i + 1] = (byte)BeltTileEntity.this.field_11863.method_8314(class_1944.field_9284, (class_2338)pos);
                pos.method_10100(vec.method_10263(), verticality, vec.method_10260());
            }
        }

        private void updateBlockLight() {
            class_2382 vec = BeltTileEntity.this.getBeltFacing().method_10163();
            BeltSlope slope = (BeltSlope)((Object)BeltTileEntity.this.method_11010().method_11654(BeltBlock.SLOPE));
            int verticality = slope == BeltSlope.DOWNWARD ? -1 : (slope == BeltSlope.UPWARD ? 1 : 0);
            class_2338.class_2339 pos = new class_2338.class_2339(BeltTileEntity.this.controller.method_10263(), BeltTileEntity.this.controller.method_10264(), BeltTileEntity.this.controller.method_10260());
            for (int i = 0; i < BeltTileEntity.this.beltLength * 2; i += 2) {
                this.light[i] = (byte)BeltTileEntity.this.field_11863.method_8314(class_1944.field_9282, (class_2338)pos);
                pos.method_10100(vec.method_10263(), verticality, vec.method_10260());
            }
        }

        private void updateSkyLight() {
            class_2382 vec = BeltTileEntity.this.getBeltFacing().method_10163();
            BeltSlope slope = (BeltSlope)((Object)BeltTileEntity.this.method_11010().method_11654(BeltBlock.SLOPE));
            int verticality = slope == BeltSlope.DOWNWARD ? -1 : (slope == BeltSlope.UPWARD ? 1 : 0);
            class_2338.class_2339 pos = new class_2338.class_2339(BeltTileEntity.this.controller.method_10263(), BeltTileEntity.this.controller.method_10264(), BeltTileEntity.this.controller.method_10260());
            for (int i = 1; i < BeltTileEntity.this.beltLength * 2; i += 2) {
                this.light[i] = (byte)BeltTileEntity.this.field_11863.method_8314(class_1944.field_9284, (class_2338)pos);
                pos.method_10100(vec.method_10263(), verticality, vec.method_10260());
            }
        }
    }
}

