/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.elementary;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.advanced.SpeedControllerBlock;
import com.simibubi.create.content.contraptions.relays.elementary.AbstractSimpleShaftBlock;
import com.simibubi.create.content.contraptions.relays.elementary.ICogWheel;
import com.simibubi.create.content.contraptions.relays.encased.EncasedCogwheelBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.utility.Iterate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public class CogWheelBlock
extends AbstractSimpleShaftBlock
implements ICogWheel {
    boolean isLarge;

    protected CogWheelBlock(boolean large, class_4970.class_2251 properties) {
        super(properties);
        this.isLarge = large;
    }

    public static CogWheelBlock small(class_4970.class_2251 properties) {
        return new CogWheelBlock(false, properties);
    }

    public static CogWheelBlock large(class_4970.class_2251 properties) {
        return new CogWheelBlock(true, properties);
    }

    @Override
    public boolean isLargeCog() {
        return this.isLarge;
    }

    @Override
    public boolean isSmallCog() {
        return !this.isLarge;
    }

    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return (this.isLarge ? AllShapes.LARGE_GEAR : AllShapes.SMALL_GEAR).get((class_2350.class_2351)state.method_11654((class_2769)AXIS));
    }

    public boolean method_9558(class_2680 state, class_4538 worldIn, class_2338 pos) {
        return CogWheelBlock.isValidCogwheelPosition(ICogWheel.isLargeCog(state), worldIn, pos, (class_2350.class_2351)state.method_11654((class_2769)AXIS));
    }

    @Override
    public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        super.method_9567(worldIn, pos, state, placer, stack);
        if (placer instanceof class_1657) {
            class_1657 player = (class_1657)placer;
            this.triggerShiftingGearsAdvancement(worldIn, pos, state, player);
        }
    }

    protected void triggerShiftingGearsAdvancement(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (world.field_9236 || player == null) {
            return;
        }
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654((class_2769)AXIS);
        for (class_2350.class_2351 perpendicular1 : Iterate.axes) {
            if (perpendicular1 == axis) continue;
            class_2350 d1 = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)perpendicular1);
            for (class_2350.class_2351 perpendicular2 : Iterate.axes) {
                if (perpendicular1 == perpendicular2 || axis == perpendicular2) continue;
                class_2350 d2 = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)perpendicular2);
                for (int offset1 : Iterate.positiveAndNegative) {
                    for (int offset2 : Iterate.positiveAndNegative) {
                        class_2338 connectedPos = pos.method_10079(d1, offset1).method_10079(d2, offset2);
                        class_2680 blockState = world.method_8320(connectedPos);
                        if (!(blockState.method_26204() instanceof CogWheelBlock) || blockState.method_11654((class_2769)AXIS) != axis || ICogWheel.isLargeCog(blockState) == this.isLarge) continue;
                        AllAdvancements.COGS.awardTo(player);
                    }
                }
            }
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 ray) {
        EncasedCogwheelBlock[] encasedBlocks;
        EncasedCogwheelBlock[] encasedCogwheelBlockArray;
        if (player.method_5715() || !player.method_7294()) {
            return class_1269.field_5811;
        }
        class_1799 heldItem = player.method_5998(hand);
        if (this.isLarge) {
            EncasedCogwheelBlock[] encasedCogwheelBlockArray2 = new EncasedCogwheelBlock[2];
            encasedCogwheelBlockArray2[0] = (EncasedCogwheelBlock)AllBlocks.ANDESITE_ENCASED_LARGE_COGWHEEL.get();
            encasedCogwheelBlockArray = encasedCogwheelBlockArray2;
            encasedCogwheelBlockArray2[1] = (EncasedCogwheelBlock)AllBlocks.BRASS_ENCASED_LARGE_COGWHEEL.get();
        } else {
            EncasedCogwheelBlock[] encasedCogwheelBlockArray3 = new EncasedCogwheelBlock[2];
            encasedCogwheelBlockArray3[0] = (EncasedCogwheelBlock)AllBlocks.ANDESITE_ENCASED_COGWHEEL.get();
            encasedCogwheelBlockArray = encasedCogwheelBlockArray3;
            encasedCogwheelBlockArray3[1] = (EncasedCogwheelBlock)AllBlocks.BRASS_ENCASED_COGWHEEL.get();
        }
        for (EncasedCogwheelBlock encasedCog : encasedBlocks = encasedCogwheelBlockArray) {
            if (!encasedCog.getCasing().isIn(heldItem)) continue;
            if (world.field_9236) {
                return class_1269.field_5812;
            }
            class_2680 encasedState = (class_2680)encasedCog.method_9564().method_11657((class_2769)AXIS, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)AXIS)));
            for (class_2350 d : Iterate.directionsInAxis((class_2350.class_2351)state.method_11654((class_2769)AXIS))) {
                IRotate def;
                class_2680 adjacentState = world.method_8320(pos.method_10093(d));
                if (!(adjacentState.method_26204() instanceof IRotate) || !(def = (IRotate)adjacentState.method_26204()).hasShaftTowards((class_4538)world, pos.method_10093(d), adjacentState, d.method_10153())) continue;
                encasedState = (class_2680)encasedState.method_28493((class_2769)(d.method_10171() == class_2350.class_2352.field_11056 ? EncasedCogwheelBlock.TOP_SHAFT : EncasedCogwheelBlock.BOTTOM_SHAFT));
            }
            KineticTileEntity.switchToBlockState(world, pos, encasedState);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public static boolean isValidCogwheelPosition(boolean large, class_4538 worldIn, class_2338 pos, class_2350.class_2351 cogAxis) {
        for (class_2350 facing : Iterate.directions) {
            class_2338 offsetPos;
            class_2680 blockState;
            if (facing.method_10166() == cogAxis || (blockState = worldIn.method_8320(offsetPos = pos.method_10093(facing))).method_28498((class_2769)AXIS) && facing.method_10166() == blockState.method_11654((class_2769)AXIS) || !ICogWheel.isLargeCog(blockState) && (!large || !ICogWheel.isSmallCog(blockState))) continue;
            return false;
        }
        return true;
    }

    protected class_2350.class_2351 getAxisForPlacement(class_1750 context) {
        if (context.method_8036() != null && context.method_8036().method_5715()) {
            return context.method_8038().method_10166();
        }
        class_1937 world = context.method_8045();
        class_2680 stateBelow = world.method_8320(context.method_8037().method_10074());
        if (AllBlocks.ROTATION_SPEED_CONTROLLER.has(stateBelow) && this.isLargeCog()) {
            return stateBelow.method_11654(SpeedControllerBlock.HORIZONTAL_AXIS) == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        }
        class_2338 placedOnPos = context.method_8037().method_10093(context.method_8038().method_10153());
        class_2680 placedAgainst = world.method_8320(placedOnPos);
        class_2248 block = placedAgainst.method_26204();
        if (ICogWheel.isSmallCog(placedAgainst)) {
            return ((IRotate)block).getRotationAxis(placedAgainst);
        }
        class_2350.class_2351 preferredAxis = CogWheelBlock.getPreferredAxis(context);
        return preferredAxis != null ? preferredAxis : context.method_8038().method_10166();
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        boolean shouldWaterlog = context.method_8045().method_8316(context.method_8037()).method_15772() == class_3612.field_15910;
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)AXIS, (Comparable)this.getAxisForPlacement(context))).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(shouldWaterlog));
    }

    @Override
    public float getParticleTargetRadius() {
        return this.isLargeCog() ? 1.125f : 0.65f;
    }

    @Override
    public float getParticleInitialRadius() {
        return this.isLargeCog() ? 1.0f : 0.75f;
    }

    @Override
    public boolean isDedicatedCogWheel() {
        return true;
    }
}

