/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.belts.tunnel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelTileEntity;
import com.simibubi.create.content.logistics.block.belts.tunnel.BrassTunnelBlock;
import com.simibubi.create.content.logistics.block.belts.tunnel.BrassTunnelFilterSlot;
import com.simibubi.create.content.logistics.block.belts.tunnel.BrassTunnelItemHandler;
import com.simibubi.create.content.logistics.block.funnel.BeltFunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.SidedFilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.INamedIconOptions;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import io.github.fabricators_of_create.porting_lib.transfer.StorageProvider;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemTransferable;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.apache.commons.lang3.tuple.Pair;

public class BrassTunnelTileEntity
extends BeltTunnelTileEntity
implements IHaveGoggleInformation,
ItemTransferable {
    SidedFilteringBehaviour filtering;
    boolean connectedLeft;
    boolean connectedRight;
    class_1799 stackToDistribute;
    class_2350 stackEnteredFrom = null;
    float distributionProgress;
    int distributionDistanceLeft;
    int distributionDistanceRight;
    int previousOutputIndex = 0;
    Couple<List<Pair<class_2338, class_2350>>> distributionTargets;
    private boolean syncedOutputActive = false;
    private Set<BrassTunnelTileEntity> syncSet;
    protected ScrollOptionBehaviour<SelectionMode> selectionMode;
    private StorageProvider<ItemVariant> beltProvider;
    private BrassTunnelItemHandler tunnelCapability;
    public final SnapshotParticipant<Data> snapshotParticipant = new SnapshotParticipant<Data>(){

        protected Data createSnapshot() {
            return new Data(BrassTunnelTileEntity.this.stackToDistribute.method_7972(), BrassTunnelTileEntity.this.distributionProgress, BrassTunnelTileEntity.this.stackEnteredFrom);
        }

        protected void readSnapshot(Data snapshot) {
            BrassTunnelTileEntity.this.stackToDistribute = snapshot.stack;
            BrassTunnelTileEntity.this.distributionProgress = snapshot.progress;
            BrassTunnelTileEntity.this.stackEnteredFrom = snapshot.enteredFrom;
        }
    };
    private static Random rand = new Random();
    private static Map<Pair<BrassTunnelTileEntity, class_2350>, class_1799> distributed = new IdentityHashMap<Pair<BrassTunnelTileEntity, class_2350>, class_1799>();
    private static Set<Pair<BrassTunnelTileEntity, class_2350>> full = new HashSet<Pair<BrassTunnelTileEntity, class_2350>>();

    public BrassTunnelTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.distributionTargets = Couple.create(ArrayList::new);
        this.syncSet = new HashSet<BrassTunnelTileEntity>();
        this.stackToDistribute = class_1799.field_8037;
        this.tunnelCapability = new BrassTunnelItemHandler(this);
    }

    @Override
    public void method_31662(class_1937 level) {
        super.method_31662(level);
        this.beltProvider = StorageProvider.createForItems((class_1937)level, (class_2338)this.field_11867.method_10074());
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.selectionMode = new ScrollOptionBehaviour<SelectionMode>(SelectionMode.class, (class_2561)Lang.translateDirect("logistics.when_multiple_outputs_available", new Object[0]), this, new CenteredSideValueBoxTransform((state, d) -> d == class_2350.field_11036));
        behaviours.add(this.selectionMode);
        this.selectionMode.requiresWrench();
        this.selectionMode.withCallback(setting -> {
            for (boolean side : Iterate.trueAndFalse) {
                BrassTunnelTileEntity adjacent;
                if (!this.isConnected(side) || (adjacent = this.getAdjacent(side)) == null) continue;
                adjacent.selectionMode.setValue((int)setting);
            }
        });
    }

    @Override
    public void tick() {
        super.tick();
        BeltTileEntity beltBelow = BeltHelper.getSegmentTE((class_1936)this.field_11863, this.field_11867.method_10074());
        if (this.distributionProgress > 0.0f) {
            this.distributionProgress -= 1.0f;
        }
        if (beltBelow == null || beltBelow.getSpeed() == 0.0f) {
            return;
        }
        if (this.stackToDistribute.method_7960() && !this.syncedOutputActive) {
            return;
        }
        if (this.field_11863.field_9236 && !this.isVirtual()) {
            return;
        }
        if (this.distributionProgress == -1.0f) {
            this.distributionTargets.forEach(List::clear);
            this.distributionDistanceLeft = 0;
            this.distributionDistanceRight = 0;
            this.syncSet.clear();
            List<Pair<BrassTunnelTileEntity, class_2350>> validOutputs = this.gatherValidOutputs();
            if (this.selectionMode.get() == SelectionMode.SYNCHRONIZE) {
                boolean notifySyncedOut;
                boolean allEmpty = true;
                boolean allFull = true;
                for (BrassTunnelTileEntity te2 : this.syncSet) {
                    boolean hasStack = !te2.stackToDistribute.method_7960();
                    allEmpty &= !hasStack;
                    allFull &= hasStack;
                }
                boolean bl = notifySyncedOut = !allEmpty;
                if (allFull || allEmpty) {
                    this.syncSet.forEach(te -> {
                        te.syncedOutputActive = notifySyncedOut;
                    });
                }
            }
            if (validOutputs == null) {
                return;
            }
            if (this.stackToDistribute.method_7960()) {
                return;
            }
            for (Pair<BrassTunnelTileEntity, class_2350> pair : validOutputs) {
                class_2350 output;
                BrassTunnelTileEntity tunnel = (BrassTunnelTileEntity)pair.getKey();
                if (this.insertIntoTunnel(tunnel, output = (class_2350)pair.getValue(), this.stackToDistribute, true) == null) continue;
                this.distributionTargets.get(!tunnel.flapFilterEmpty(output)).add((Pair<class_2338, class_2350>)Pair.of((Object)tunnel.field_11867, (Object)output));
                int distance = tunnel.field_11867.method_10263() + tunnel.field_11867.method_10260() - this.field_11867.method_10263() - this.field_11867.method_10260();
                if (distance < 0) {
                    this.distributionDistanceLeft = Math.max(this.distributionDistanceLeft, -distance);
                    continue;
                }
                this.distributionDistanceRight = Math.max(this.distributionDistanceRight, distance);
            }
            if (((List)this.distributionTargets.getFirst()).isEmpty() && ((List)this.distributionTargets.getSecond()).isEmpty()) {
                return;
            }
            if (this.selectionMode.get() != SelectionMode.SYNCHRONIZE || this.syncedOutputActive) {
                this.distributionProgress = 10.0f;
                this.sendData();
            }
            return;
        }
        if (this.distributionProgress != 0.0f) {
            return;
        }
        this.distributionTargets.forEach(list -> {
            if (this.stackToDistribute.method_7960()) {
                return;
            }
            ArrayList<Pair<BrassTunnelTileEntity, class_2350>> validTargets = new ArrayList<Pair<BrassTunnelTileEntity, class_2350>>();
            for (Pair pair : list) {
                class_2586 te;
                class_2338 tunnelPos = (class_2338)pair.getKey();
                class_2350 output = (class_2350)pair.getValue();
                if (tunnelPos.equals((Object)this.field_11867) && output == this.stackEnteredFrom || !((te = this.field_11863.method_8321(tunnelPos)) instanceof BrassTunnelTileEntity)) continue;
                validTargets.add((Pair<BrassTunnelTileEntity, class_2350>)Pair.of((Object)((BrassTunnelTileEntity)te), (Object)output));
            }
            this.distribute(validTargets);
            this.distributionProgress = -1.0f;
        });
    }

    private void distribute(List<Pair<BrassTunnelTileEntity, class_2350>> validTargets) {
        boolean robin;
        int amountTargets = validTargets.size();
        if (amountTargets == 0) {
            return;
        }
        distributed.clear();
        full.clear();
        int indexStart = this.previousOutputIndex % amountTargets;
        SelectionMode mode = this.selectionMode.get();
        boolean force = mode == SelectionMode.FORCED_ROUND_ROBIN || mode == SelectionMode.FORCED_SPLIT;
        boolean split = mode == SelectionMode.FORCED_SPLIT || mode == SelectionMode.SPLIT;
        boolean bl = robin = mode == SelectionMode.FORCED_ROUND_ROBIN || mode == SelectionMode.ROUND_ROBIN;
        if (mode == SelectionMode.RANDOMIZE) {
            indexStart = rand.nextInt(amountTargets);
        }
        if (mode == SelectionMode.PREFER_NEAREST || mode == SelectionMode.SYNCHRONIZE) {
            indexStart = 0;
        }
        class_1799 toDistribute = this.stackToDistribute.method_7972();
        for (boolean distributeAgain : Iterate.trueAndFalse) {
            class_1799 toDistributeThisCycle = null;
            int remainingOutputs = amountTargets;
            int leftovers = 0;
            block1: for (boolean simulate : Iterate.trueAndFalse) {
                if (remainingOutputs == 0) break;
                leftovers = 0;
                int index = indexStart;
                int stackSize = toDistribute.method_7947();
                int splitStackSize = stackSize / remainingOutputs;
                int splitRemainder = stackSize % remainingOutputs;
                int visited = 0;
                toDistributeThisCycle = toDistribute.method_7972();
                if (!force && !split && simulate) continue;
                while (visited < amountTargets) {
                    class_1799 remainder;
                    int increasedCount;
                    Pair<BrassTunnelTileEntity, class_2350> pair = validTargets.get(index);
                    BrassTunnelTileEntity tunnel = (BrassTunnelTileEntity)pair.getKey();
                    class_2350 side = (class_2350)pair.getValue();
                    index = (index + 1) % amountTargets;
                    ++visited;
                    if (full.contains(pair)) {
                        if (!split || !simulate) continue;
                        --remainingOutputs;
                        continue;
                    }
                    int count = split ? splitStackSize + (splitRemainder > 0 ? 1 : 0) : stackSize;
                    class_1799 toOutput = ItemHandlerHelper.copyStackWithSize((class_1799)toDistributeThisCycle, (int)count);
                    boolean testWithIncreasedCount = distributed.containsKey(pair);
                    int n = increasedCount = testWithIncreasedCount ? distributed.get(pair).method_7947() : 0;
                    if (testWithIncreasedCount) {
                        toOutput.method_7933(increasedCount);
                    }
                    if ((remainder = this.insertIntoTunnel(tunnel, side, toOutput, true)) == null || remainder.method_7947() == (testWithIncreasedCount ? count + 1 : count)) {
                        if (force) {
                            return;
                        }
                        if (split && simulate) {
                            --remainingOutputs;
                        }
                        if (!simulate) {
                            full.add(pair);
                        }
                        if (!robin) continue;
                        continue block1;
                    }
                    if (!remainder.method_7960() && !simulate) {
                        full.add(pair);
                    }
                    if (!simulate) {
                        toOutput.method_7934(remainder.method_7947());
                        distributed.put(pair, toOutput);
                    }
                    leftovers += remainder.method_7947();
                    toDistributeThisCycle.method_7934(count);
                    if (toDistributeThisCycle.method_7960()) continue block1;
                    --splitRemainder;
                    if (split) continue;
                    continue block1;
                }
            }
            toDistribute.method_7939(toDistributeThisCycle.method_7947() + leftovers);
            if (leftovers == 0 && distributeAgain || !split) break;
        }
        int failedTransferrals = 0;
        for (Map.Entry<Pair<BrassTunnelTileEntity, class_2350>, class_1799> entry : distributed.entrySet()) {
            Pair<BrassTunnelTileEntity, class_2350> pair = entry.getKey();
            failedTransferrals += this.insertIntoTunnel((BrassTunnelTileEntity)pair.getKey(), (class_2350)pair.getValue(), entry.getValue(), false).method_7947();
        }
        toDistribute.method_7933(failedTransferrals);
        this.stackToDistribute = ItemHandlerHelper.copyStackWithSize((class_1799)this.stackToDistribute, (int)toDistribute.method_7947());
        if (this.stackToDistribute.method_7960()) {
            this.stackEnteredFrom = null;
        }
        ++this.previousOutputIndex;
        this.previousOutputIndex %= amountTargets;
        this.notifyUpdate();
    }

    public void setStackToDistribute(class_1799 stack, @Nullable class_2350 enteredFrom, @Nullable TransactionContext ctx) {
        if (ctx != null) {
            this.snapshotParticipant.updateSnapshots(ctx);
        }
        this.stackToDistribute = stack;
        this.stackEnteredFrom = enteredFrom;
        this.distributionProgress = -1.0f;
    }

    public class_1799 getStackToDistribute() {
        return this.stackToDistribute;
    }

    public List<class_1799> grabAllStacksOfGroup(boolean simulate) {
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        class_1799 own = this.getStackToDistribute();
        if (!own.method_7960()) {
            list.add(own);
            if (!simulate) {
                this.setStackToDistribute(class_1799.field_8037, null, null);
            }
        }
        for (boolean left : Iterate.trueAndFalse) {
            BrassTunnelTileEntity adjacent = this;
            while (adjacent != null) {
                class_1799 other;
                if (!this.field_11863.method_8477(adjacent.method_11016())) {
                    return null;
                }
                if ((adjacent = adjacent.getAdjacent(left)) == null || (other = adjacent.getStackToDistribute()).method_7960()) continue;
                list.add(other);
                if (simulate) continue;
                adjacent.setStackToDistribute(class_1799.field_8037, null, null);
            }
        }
        return list;
    }

    @Nullable
    protected class_1799 insertIntoTunnel(BrassTunnelTileEntity tunnel, class_2350 side, class_1799 stack, boolean simulate) {
        if (stack.method_7960()) {
            return stack;
        }
        if (!tunnel.testFlapFilter(side, stack)) {
            return null;
        }
        BeltTileEntity below = BeltHelper.getSegmentTE((class_1936)this.field_11863, tunnel.field_11867.method_10074());
        if (below == null) {
            return null;
        }
        class_2338 offset = tunnel.method_11016().method_10074().method_10093(side);
        DirectBeltInputBehaviour sideOutput = TileEntityBehaviour.get((class_1922)this.field_11863, offset, DirectBeltInputBehaviour.TYPE);
        if (sideOutput != null) {
            if (!sideOutput.canInsertFromSide(side)) {
                return null;
            }
            class_1799 result = sideOutput.handleInsertion(stack, side, simulate);
            if (result.method_7960() && !simulate) {
                tunnel.flap(side, false);
            }
            return result;
        }
        class_2350 movementFacing = below.getMovementFacing();
        if (side == movementFacing && !BlockHelper.hasBlockSolidSide(this.field_11863.method_8320(offset), (class_1922)this.field_11863, offset, side.method_10153())) {
            BeltTileEntity controllerTE = below.getControllerTE();
            if (controllerTE == null) {
                return null;
            }
            if (!simulate) {
                tunnel.flap(side, true);
                class_1799 ejected = stack;
                float beltMovementSpeed = below.getDirectionAwareBeltMovementSpeed();
                float movementSpeed = Math.max(Math.abs(beltMovementSpeed), 0.125f);
                int additionalOffset = beltMovementSpeed > 0.0f ? 1 : 0;
                class_243 outPos = BeltHelper.getVectorForOffset(controllerTE, below.index + additionalOffset);
                class_243 outMotion = class_243.method_24954((class_2382)side.method_10163()).method_1021((double)movementSpeed).method_1031(0.0, 0.125, 0.0);
                outPos.method_1019(outMotion.method_1029());
                class_1542 entity = new class_1542(this.field_11863, outPos.field_1352, outPos.field_1351 + 0.375, outPos.field_1350, ejected);
                entity.method_18799(outMotion);
                entity.method_6988();
                entity.field_6037 = true;
                this.field_11863.method_8649((class_1297)entity);
            }
            return class_1799.field_8037;
        }
        return null;
    }

    public boolean testFlapFilter(class_2350 side, class_1799 stack) {
        if (this.filtering == null) {
            return false;
        }
        if (this.filtering.get(side) == null) {
            FilteringBehaviour adjacentFilter = TileEntityBehaviour.get((class_1922)this.field_11863, this.field_11867.method_10093(side), FilteringBehaviour.TYPE);
            if (adjacentFilter == null) {
                return true;
            }
            return adjacentFilter.test(stack);
        }
        return this.filtering.test(side, stack);
    }

    public boolean flapFilterEmpty(class_2350 side) {
        if (this.filtering == null) {
            return false;
        }
        if (this.filtering.get(side) == null) {
            FilteringBehaviour adjacentFilter = TileEntityBehaviour.get((class_1922)this.field_11863, this.field_11867.method_10093(side), FilteringBehaviour.TYPE);
            if (adjacentFilter == null) {
                return true;
            }
            return adjacentFilter.getFilter().method_7960();
        }
        return this.filtering.getFilter(side).method_7960();
    }

    @Override
    public void initialize() {
        if (this.filtering == null) {
            this.filtering = this.createSidedFilter();
            this.attachBehaviourLate(this.filtering);
        }
        super.initialize();
    }

    public boolean canInsert(class_2350 side, class_1799 stack) {
        if (this.filtering != null && !this.filtering.test(side, stack)) {
            return false;
        }
        if (!this.hasDistributionBehaviour()) {
            return true;
        }
        return this.stackToDistribute.method_7960();
    }

    public boolean hasDistributionBehaviour() {
        if (this.flaps.isEmpty()) {
            return false;
        }
        if (this.connectedLeft || this.connectedRight) {
            return true;
        }
        class_2680 blockState = this.method_11010();
        if (!AllBlocks.BRASS_TUNNEL.has(blockState)) {
            return false;
        }
        class_2350.class_2351 axis = (class_2350.class_2351)blockState.method_11654(BrassTunnelBlock.HORIZONTAL_AXIS);
        for (class_2350 direction : this.flaps.keySet()) {
            if (direction.method_10166() == axis) continue;
            return true;
        }
        return false;
    }

    private List<Pair<BrassTunnelTileEntity, class_2350>> gatherValidOutputs() {
        ArrayList<Pair<BrassTunnelTileEntity, class_2350>> validOutputs = new ArrayList<Pair<BrassTunnelTileEntity, class_2350>>();
        boolean synchronize = this.selectionMode.get() == SelectionMode.SYNCHRONIZE;
        this.addValidOutputsOf(this, validOutputs);
        for (boolean left : Iterate.trueAndFalse) {
            BrassTunnelTileEntity adjacent = this;
            while (adjacent != null) {
                if (!this.field_11863.method_8477(adjacent.method_11016())) {
                    return null;
                }
                if ((adjacent = adjacent.getAdjacent(left)) == null) continue;
                this.addValidOutputsOf(adjacent, validOutputs);
            }
        }
        if (!this.syncedOutputActive && synchronize) {
            return null;
        }
        return validOutputs;
    }

    private void addValidOutputsOf(BrassTunnelTileEntity tunnelTE, List<Pair<BrassTunnelTileEntity, class_2350>> validOutputs) {
        this.syncSet.add(tunnelTE);
        BeltTileEntity below = BeltHelper.getSegmentTE((class_1936)this.field_11863, tunnelTE.field_11867.method_10074());
        if (below == null) {
            return;
        }
        class_2350 movementFacing = below.getMovementFacing();
        class_2680 blockState = this.method_11010();
        if (!AllBlocks.BRASS_TUNNEL.has(blockState)) {
            return;
        }
        boolean prioritizeSides = tunnelTE == this;
        for (boolean sidePass : Iterate.trueAndFalse) {
            if (!prioritizeSides && sidePass) continue;
            for (class_2350 direction : Iterate.horizontalDirections) {
                class_2338 offset;
                class_2680 potentialFunnel;
                if (direction == movementFacing && below.getSpeed() == 0.0f || prioritizeSides && sidePass == (direction.method_10166() == movementFacing.method_10166()) || direction == movementFacing.method_10153() || !tunnelTE.sides.contains(direction) || (potentialFunnel = this.field_11863.method_8320((offset = tunnelTE.field_11867.method_10074().method_10093(direction)).method_10084())).method_26204() instanceof BeltFunnelBlock && potentialFunnel.method_11654(BeltFunnelBlock.SHAPE) == BeltFunnelBlock.Shape.PULLING && FunnelBlock.getFunnelFacing(potentialFunnel) == direction) continue;
                DirectBeltInputBehaviour inputBehaviour = TileEntityBehaviour.get((class_1922)this.field_11863, offset, DirectBeltInputBehaviour.TYPE);
                if (inputBehaviour == null) {
                    if (direction != movementFacing || BlockHelper.hasBlockSolidSide(this.field_11863.method_8320(offset), (class_1922)this.field_11863, offset, direction.method_10153())) continue;
                    validOutputs.add((Pair<BrassTunnelTileEntity, class_2350>)Pair.of((Object)tunnelTE, (Object)direction));
                    continue;
                }
                if (!inputBehaviour.canInsertFromSide(direction)) continue;
                validOutputs.add((Pair<BrassTunnelTileEntity, class_2350>)Pair.of((Object)tunnelTE, (Object)direction));
            }
        }
    }

    @Override
    public void addBehavioursDeferred(List<TileEntityBehaviour> behaviours) {
        super.addBehavioursDeferred(behaviours);
        this.filtering = this.createSidedFilter();
        behaviours.add(this.filtering);
    }

    protected SidedFilteringBehaviour createSidedFilter() {
        return new SidedFilteringBehaviour(this, new BrassTunnelFilterSlot(), this::makeFilter, this::isValidFaceForFilter);
    }

    private FilteringBehaviour makeFilter(class_2350 side, FilteringBehaviour filter) {
        return filter;
    }

    private boolean isValidFaceForFilter(class_2350 side) {
        return this.sides.contains(side);
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10556("SyncedOutput", this.syncedOutputActive);
        compound.method_10556("ConnectedLeft", this.connectedLeft);
        compound.method_10556("ConnectedRight", this.connectedRight);
        compound.method_10566("StackToDistribute", NBTSerializer.serializeNBT((Object)this.stackToDistribute));
        if (this.stackEnteredFrom != null) {
            NBTHelper.writeEnum(compound, "StackEnteredFrom", this.stackEnteredFrom);
        }
        compound.method_10548("DistributionProgress", this.distributionProgress);
        compound.method_10569("PreviousIndex", this.previousOutputIndex);
        compound.method_10569("DistanceLeft", this.distributionDistanceLeft);
        compound.method_10569("DistanceRight", this.distributionDistanceRight);
        for (boolean filtered : Iterate.trueAndFalse) {
            compound.method_10566(filtered ? "FilteredTargets" : "Targets", (class_2520)NBTHelper.writeCompoundList((Iterable)this.distributionTargets.get(filtered), pair -> {
                class_2487 nbt = new class_2487();
                nbt.method_10566("Pos", (class_2520)class_2512.method_10692((class_2338)((class_2338)pair.getKey())));
                nbt.method_10569("Face", ((class_2350)pair.getValue()).method_10146());
                return nbt;
            }));
        }
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        boolean wasConnectedLeft = this.connectedLeft;
        boolean wasConnectedRight = this.connectedRight;
        this.syncedOutputActive = compound.method_10577("SyncedOutput");
        this.connectedLeft = compound.method_10577("ConnectedLeft");
        this.connectedRight = compound.method_10577("ConnectedRight");
        this.stackToDistribute = class_1799.method_7915((class_2487)compound.method_10562("StackToDistribute"));
        this.stackEnteredFrom = compound.method_10545("StackEnteredFrom") ? NBTHelper.readEnum(compound, "StackEnteredFrom", class_2350.class) : null;
        this.distributionProgress = compound.method_10583("DistributionProgress");
        this.previousOutputIndex = compound.method_10550("PreviousIndex");
        this.distributionDistanceLeft = compound.method_10550("DistanceLeft");
        this.distributionDistanceRight = compound.method_10550("DistanceRight");
        for (boolean filtered : Iterate.trueAndFalse) {
            this.distributionTargets.set(filtered, NBTHelper.readCompoundList(compound.method_10554(filtered ? "FilteredTargets" : "Targets", 10), nbt -> {
                class_2338 pos = class_2512.method_10691((class_2487)nbt.method_10562("Pos"));
                class_2350 face = class_2350.method_10143((int)nbt.method_10550("Face"));
                return Pair.of((Object)pos, (Object)face);
            }));
        }
        super.read(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if ((wasConnectedLeft != this.connectedLeft || wasConnectedRight != this.connectedRight) && this.method_11002()) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 16);
        }
        this.filtering.updateFilterPresence();
    }

    public boolean isConnected(boolean leftSide) {
        return leftSide ? this.connectedLeft : this.connectedRight;
    }

    @Override
    public void updateTunnelConnections() {
        BrassTunnelTileEntity adjacent;
        super.updateTunnelConnections();
        boolean connectivityChanged = false;
        boolean nowConnectedLeft = this.determineIfConnected(true);
        boolean nowConnectedRight = this.determineIfConnected(false);
        if (this.connectedLeft != nowConnectedLeft) {
            this.connectedLeft = nowConnectedLeft;
            connectivityChanged = true;
            adjacent = this.getAdjacent(true);
            if (adjacent != null && !this.field_11863.field_9236) {
                adjacent.updateTunnelConnections();
                adjacent.selectionMode.setValue(this.selectionMode.getValue());
            }
        }
        if (this.connectedRight != nowConnectedRight) {
            this.connectedRight = nowConnectedRight;
            connectivityChanged = true;
            adjacent = this.getAdjacent(false);
            if (adjacent != null && !this.field_11863.field_9236) {
                adjacent.updateTunnelConnections();
                adjacent.selectionMode.setValue(this.selectionMode.getValue());
            }
        }
        if (this.filtering != null) {
            this.filtering.updateFilterPresence();
        }
        if (connectivityChanged) {
            this.sendData();
        }
    }

    protected boolean determineIfConnected(boolean leftSide) {
        if (this.flaps.isEmpty()) {
            return false;
        }
        BrassTunnelTileEntity adjacentTunnelTE = this.getAdjacent(leftSide);
        return adjacentTunnelTE != null && !adjacentTunnelTE.flaps.isEmpty();
    }

    @Nullable
    protected BrassTunnelTileEntity getAdjacent(boolean leftSide) {
        if (!this.method_11002()) {
            return null;
        }
        class_2680 blockState = this.method_11010();
        if (!AllBlocks.BRASS_TUNNEL.has(blockState)) {
            return null;
        }
        class_2350.class_2351 axis = (class_2350.class_2351)blockState.method_11654(BrassTunnelBlock.HORIZONTAL_AXIS);
        class_2350 baseDirection = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis);
        class_2350 direction = leftSide ? baseDirection.method_10160() : baseDirection.method_10170();
        class_2338 adjacentPos = this.field_11867.method_10093(direction);
        class_2680 adjacentBlockState = this.field_11863.method_8320(adjacentPos);
        if (!AllBlocks.BRASS_TUNNEL.has(adjacentBlockState)) {
            return null;
        }
        if (adjacentBlockState.method_11654(BrassTunnelBlock.HORIZONTAL_AXIS) != axis) {
            return null;
        }
        class_2586 adjacentTE = this.field_11863.method_8321(adjacentPos);
        if (adjacentTE.method_11015()) {
            return null;
        }
        if (!(adjacentTE instanceof BrassTunnelTileEntity)) {
            return null;
        }
        return (BrassTunnelTileEntity)adjacentTE;
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }

    @Override
    public void destroy() {
        super.destroy();
        class_2248.method_9577((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1799)this.stackToDistribute);
        this.stackEnteredFrom = null;
    }

    @Override
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 face) {
        return this.tunnelCapability;
    }

    public Storage<ItemVariant> getBeltCapability() {
        return this.beltProvider != null ? this.beltProvider.get(class_2350.field_11036) : null;
    }

    public boolean canTakeItems() {
        return this.stackToDistribute.method_7960() && !this.syncedOutputActive;
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        List<class_1799> allStacks = this.grabAllStacksOfGroup(true);
        if (allStacks.isEmpty()) {
            return false;
        }
        tooltip.add((class_2561)componentSpacing.method_27662().method_10852((class_2561)Lang.translateDirect("tooltip.brass_tunnel.contains", new Object[0])).method_27692(class_124.field_1068));
        for (class_1799 item : allStacks) {
            tooltip.add((class_2561)componentSpacing.method_27662().method_10852((class_2561)Lang.translateDirect("tooltip.brass_tunnel.contains_entry", Components.translatable(item.method_7922()).getString(), item.method_7947())).method_27692(class_124.field_1080));
        }
        tooltip.add((class_2561)componentSpacing.method_27662().method_10852((class_2561)Lang.translateDirect("tooltip.brass_tunnel.retrieve", new Object[0])).method_27692(class_124.field_1063));
        return true;
    }

    public static enum SelectionMode implements INamedIconOptions
    {
        SPLIT(AllIcons.I_TUNNEL_SPLIT),
        FORCED_SPLIT(AllIcons.I_TUNNEL_FORCED_SPLIT),
        ROUND_ROBIN(AllIcons.I_TUNNEL_ROUND_ROBIN),
        FORCED_ROUND_ROBIN(AllIcons.I_TUNNEL_FORCED_ROUND_ROBIN),
        PREFER_NEAREST(AllIcons.I_TUNNEL_PREFER_NEAREST),
        RANDOMIZE(AllIcons.I_TUNNEL_RANDOMIZE),
        SYNCHRONIZE(AllIcons.I_TUNNEL_SYNCHRONIZE);

        private final String translationKey;
        private final AllIcons icon;

        private SelectionMode(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "tunnel.selection_mode." + Lang.asId(this.name());
        }

        @Override
        public AllIcons getIcon() {
            return this.icon;
        }

        @Override
        public String getTranslationKey() {
            return this.translationKey;
        }
    }

    private record Data(class_1799 stack, float progress, class_2350 enteredFrom) {
    }
}

