/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.management.edgePoint.observer;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.DimensionPalette;
import com.simibubi.create.content.logistics.trains.TrackEdge;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.TrackNodeLocation;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.SignalPropagator;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.SingleTileEdgePoint;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2586;

public class TrackObserver
extends SingleTileEdgePoint {
    private int activated = 0;
    private class_1799 filter = class_1799.field_8037;
    private UUID currentTrain = null;

    @Override
    public void tileAdded(class_2586 tile, boolean front) {
        super.tileAdded(tile, front);
        FilteringBehaviour filteringBehaviour = TileEntityBehaviour.get(tile, FilteringBehaviour.TYPE);
        if (filteringBehaviour != null) {
            this.setFilterAndNotify(tile.method_10997(), filteringBehaviour.getFilter());
        }
    }

    @Override
    public void tick(TrackGraph graph, boolean preTrains) {
        super.tick(graph, preTrains);
        if (this.isActivated()) {
            --this.activated;
        }
        if (!this.isActivated()) {
            this.currentTrain = null;
        }
    }

    public void setFilterAndNotify(class_1937 level, class_1799 filter) {
        this.filter = filter;
        this.notifyTrains(level);
    }

    private void notifyTrains(class_1937 level) {
        TrackGraph graph = Create.RAILWAYS.sided((class_1936)level).getGraph((class_1936)level, (TrackNodeLocation)((Object)this.edgeLocation.getFirst()));
        if (graph == null) {
            return;
        }
        TrackEdge edge = graph.getConnection(this.edgeLocation.map(graph::locateNode));
        if (edge == null) {
            return;
        }
        SignalPropagator.notifyTrains(graph, edge);
    }

    public class_1799 getFilter() {
        return this.filter;
    }

    public UUID getCurrentTrain() {
        return this.currentTrain;
    }

    public boolean isActivated() {
        return this.activated > 0;
    }

    public void keepAlive(Train train) {
        this.activated = 8;
        this.currentTrain = train.id;
    }

    @Override
    public void read(class_2487 nbt, boolean migration, DimensionPalette dimensions) {
        super.read(nbt, migration, dimensions);
        this.activated = nbt.method_10550("Activated");
        this.filter = class_1799.method_7915((class_2487)nbt.method_10562("Filter"));
        if (nbt.method_10545("TrainId")) {
            this.currentTrain = nbt.method_25926("TrainId");
        }
    }

    @Override
    public void read(class_2540 buffer, DimensionPalette dimensions) {
        super.read(buffer, dimensions);
    }

    @Override
    public void write(class_2487 nbt, DimensionPalette dimensions) {
        super.write(nbt, dimensions);
        nbt.method_10569("Activated", this.activated);
        nbt.method_10566("Filter", (class_2520)NBTSerializer.serializeNBTCompound((Object)this.filter));
        if (this.currentTrain != null) {
            nbt.method_25927("TrainId", this.currentTrain);
        }
    }

    @Override
    public void write(class_2540 buffer, DimensionPalette dimensions) {
        super.write(buffer, dimensions);
    }
}

