/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.management.schedule;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.management.schedule.ScheduleEntry;
import com.simibubi.create.content.logistics.trains.management.schedule.condition.FluidThresholdCondition;
import com.simibubi.create.content.logistics.trains.management.schedule.condition.IdleCargoCondition;
import com.simibubi.create.content.logistics.trains.management.schedule.condition.ItemThresholdCondition;
import com.simibubi.create.content.logistics.trains.management.schedule.condition.PlayerPassengerCondition;
import com.simibubi.create.content.logistics.trains.management.schedule.condition.RedstoneLinkCondition;
import com.simibubi.create.content.logistics.trains.management.schedule.condition.ScheduleWaitCondition;
import com.simibubi.create.content.logistics.trains.management.schedule.condition.ScheduledDelay;
import com.simibubi.create.content.logistics.trains.management.schedule.condition.StationPoweredCondition;
import com.simibubi.create.content.logistics.trains.management.schedule.condition.StationUnloadedCondition;
import com.simibubi.create.content.logistics.trains.management.schedule.condition.TimeOfDayCondition;
import com.simibubi.create.content.logistics.trains.management.schedule.destination.ChangeThrottleInstruction;
import com.simibubi.create.content.logistics.trains.management.schedule.destination.ChangeTitleInstruction;
import com.simibubi.create.content.logistics.trains.management.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.logistics.trains.management.schedule.destination.ScheduleInstruction;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class Schedule {
    public static List<Pair<class_2960, Supplier<? extends ScheduleInstruction>>> INSTRUCTION_TYPES = new ArrayList<Pair<class_2960, Supplier<? extends ScheduleInstruction>>>();
    public static List<Pair<class_2960, Supplier<? extends ScheduleWaitCondition>>> CONDITION_TYPES = new ArrayList<Pair<class_2960, Supplier<? extends ScheduleWaitCondition>>>();
    public List<ScheduleEntry> entries = new ArrayList<ScheduleEntry>();
    public boolean cyclic = true;
    public int savedProgress = 0;

    private static void registerInstruction(String name, Supplier<? extends ScheduleInstruction> factory) {
        INSTRUCTION_TYPES.add(Pair.of(Create.asResource(name), factory));
    }

    private static void registerCondition(String name, Supplier<? extends ScheduleWaitCondition> factory) {
        CONDITION_TYPES.add(Pair.of(Create.asResource(name), factory));
    }

    public static <T> List<? extends class_2561> getTypeOptions(List<Pair<class_2960, T>> list) {
        String langSection = list.equals(INSTRUCTION_TYPES) ? "instruction." : "condition.";
        return list.stream().map(Pair::getFirst).map(rl -> rl.method_12836() + ".schedule." + langSection + rl.method_12832()).map(Components::translatable).toList();
    }

    public class_2487 write() {
        class_2487 tag = new class_2487();
        class_2499 list = NBTHelper.writeCompoundList(this.entries, ScheduleEntry::write);
        tag.method_10566("Entries", (class_2520)list);
        tag.method_10556("Cyclic", this.cyclic);
        if (this.savedProgress > 0) {
            tag.method_10569("Progress", this.savedProgress);
        }
        return tag;
    }

    public static Schedule fromTag(class_2487 tag) {
        Schedule schedule = new Schedule();
        schedule.entries = NBTHelper.readCompoundList(tag.method_10554("Entries", 10), ScheduleEntry::fromTag);
        schedule.cyclic = tag.method_10577("Cyclic");
        if (tag.method_10545("Progress")) {
            schedule.savedProgress = tag.method_10550("Progress");
        }
        return schedule;
    }

    static {
        Schedule.registerInstruction("destination", DestinationInstruction::new);
        Schedule.registerInstruction("rename", ChangeTitleInstruction::new);
        Schedule.registerInstruction("throttle", ChangeThrottleInstruction::new);
        Schedule.registerCondition("delay", ScheduledDelay::new);
        Schedule.registerCondition("time_of_day", TimeOfDayCondition::new);
        Schedule.registerCondition("fluid_threshold", FluidThresholdCondition::new);
        Schedule.registerCondition("item_threshold", ItemThresholdCondition::new);
        Schedule.registerCondition("redstone_link", RedstoneLinkCondition::new);
        Schedule.registerCondition("player_count", PlayerPassengerCondition::new);
        Schedule.registerCondition("idle", IdleCargoCondition::new);
        Schedule.registerCondition("unloaded", StationUnloadedCondition::new);
        Schedule.registerCondition("powered", StationPoweredCondition::new);
    }
}

