/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.track;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.light.LightListener;
import com.jozufozu.flywheel.light.LightUpdater;
import com.jozufozu.flywheel.util.box.GridAlignedBB;
import com.jozufozu.flywheel.util.box.ImmutableBox;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.logistics.trains.BezierConnection;
import com.simibubi.create.content.logistics.trains.track.TrackTileEntity;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_4587;

public class TrackInstance
extends BlockEntityInstance<TrackTileEntity> {
    private List<BezierTrackInstance> instances;

    public TrackInstance(MaterialManager materialManager, TrackTileEntity track) {
        super(materialManager, (class_2586)track);
        this.update();
    }

    public void update() {
        if (((TrackTileEntity)this.blockEntity).connections.isEmpty()) {
            return;
        }
        this.remove();
        this.instances = ((TrackTileEntity)this.blockEntity).connections.values().stream().map(this::createInstance).filter(Objects::nonNull).toList();
        LightUpdater.get((class_1936)this.world).addListener((LightListener)this);
    }

    public ImmutableBox getVolume() {
        ArrayList<class_2338> out = new ArrayList<class_2338>();
        out.addAll(((TrackTileEntity)this.blockEntity).connections.keySet());
        out.addAll(((TrackTileEntity)this.blockEntity).connections.keySet());
        return GridAlignedBB.containingAll(out);
    }

    public void updateLight() {
        if (this.instances == null) {
            return;
        }
        this.instances.forEach(BezierTrackInstance::updateLight);
    }

    @Nullable
    private BezierTrackInstance createInstance(BezierConnection bc) {
        if (!bc.isPrimary()) {
            return null;
        }
        return new BezierTrackInstance(bc);
    }

    public void remove() {
        if (this.instances == null) {
            return;
        }
        this.instances.forEach(BezierTrackInstance::delete);
    }

    private class BezierTrackInstance {
        private final ModelData[] ties;
        private final ModelData[] left;
        private final ModelData[] right;
        private final class_2338[] tiesLightPos;
        private final class_2338[] leftLightPos;
        private final class_2338[] rightLightPos;
        @Nullable
        private GirderInstance girder;

        private BezierTrackInstance(BezierConnection bc) {
            class_2338 tePosition = (class_2338)bc.tePositions.getFirst();
            this.girder = bc.hasGirder ? new GirderInstance(bc) : null;
            class_4587 pose = new class_4587();
            ((TransformStack)TransformStack.cast((class_4587)pose).translate((class_2382)TrackInstance.this.getInstancePosition())).nudge((int)((class_2338)bc.tePositions.getFirst()).method_10063());
            Material mat = TrackInstance.this.materialManager.cutout(class_1921.method_23579()).material(Materials.TRANSFORMED);
            int segCount = bc.getSegmentCount();
            this.ties = new ModelData[segCount];
            this.left = new ModelData[segCount];
            this.right = new ModelData[segCount];
            this.tiesLightPos = new class_2338[segCount];
            this.leftLightPos = new class_2338[segCount];
            this.rightLightPos = new class_2338[segCount];
            mat.getModel(AllBlockPartials.TRACK_TIE).createInstances((InstanceData[])this.ties);
            mat.getModel(AllBlockPartials.TRACK_SEGMENT_LEFT).createInstances((InstanceData[])this.left);
            mat.getModel(AllBlockPartials.TRACK_SEGMENT_RIGHT).createInstances((InstanceData[])this.right);
            BezierConnection.SegmentAngles[] segments = bc.getBakedSegments();
            for (int i = 1; i < segments.length; ++i) {
                BezierConnection.SegmentAngles segment = segments[i];
                int modelIndex = i - 1;
                this.ties[modelIndex].setTransform(pose).mulPose(segment.tieTransform.method_23761()).mulNormal(segment.tieTransform.method_23762());
                this.tiesLightPos[modelIndex] = segment.lightPosition.method_10081((class_2382)tePosition);
                for (boolean first : Iterate.trueAndFalse) {
                    class_4587.class_4665 transform = segment.railTransforms.get(first);
                    (first ? this.left : this.right)[modelIndex].setTransform(pose).mulPose(transform.method_23761()).mulNormal(transform.method_23762());
                    (first ? this.leftLightPos : this.rightLightPos)[modelIndex] = segment.lightPosition.method_10081((class_2382)tePosition);
                }
            }
            this.updateLight();
        }

        void delete() {
            for (ModelData d : this.ties) {
                d.delete();
            }
            for (ModelData d : this.left) {
                d.delete();
            }
            for (ModelData d : this.right) {
                d.delete();
            }
            if (this.girder != null) {
                this.girder.delete();
            }
        }

        void updateLight() {
            int i;
            for (i = 0; i < this.ties.length; ++i) {
                this.ties[i].updateLight((class_1920)TrackInstance.this.world, this.tiesLightPos[i]);
            }
            for (i = 0; i < this.left.length; ++i) {
                this.left[i].updateLight((class_1920)TrackInstance.this.world, this.leftLightPos[i]);
            }
            for (i = 0; i < this.right.length; ++i) {
                this.right[i].updateLight((class_1920)TrackInstance.this.world, this.rightLightPos[i]);
            }
            if (this.girder != null) {
                this.girder.updateLight();
            }
        }

        private class GirderInstance {
            private final Couple<ModelData[]> beams;
            private final Couple<Couple<ModelData[]>> beamCaps;
            private final class_2338[] lightPos;

            private GirderInstance(BezierConnection bc) {
                class_2338 tePosition = (class_2338)bc.tePositions.getFirst();
                class_4587 pose = new class_4587();
                ((TransformStack)TransformStack.cast((class_4587)pose).translate((class_2382)TrackInstance.this.getInstancePosition())).nudge((int)((class_2338)bc.tePositions.getFirst()).method_10063());
                Material mat = TrackInstance.this.materialManager.cutout(class_1921.method_23579()).material(Materials.TRANSFORMED);
                int segCount = bc.getSegmentCount();
                this.beams = Couple.create(() -> new ModelData[segCount]);
                this.beamCaps = Couple.create(() -> Couple.create(() -> new ModelData[segCount]));
                this.lightPos = new class_2338[segCount];
                this.beams.forEach(arg_0 -> ((Instancer)mat.getModel(AllBlockPartials.GIRDER_SEGMENT_MIDDLE)).createInstances(arg_0));
                this.beamCaps.forEachWithContext((c, top) -> c.forEach(arg_0 -> ((Instancer)mat.getModel(top.booleanValue() ? AllBlockPartials.GIRDER_SEGMENT_TOP : AllBlockPartials.GIRDER_SEGMENT_BOTTOM)).createInstances(arg_0)));
                BezierConnection.GirderAngles[] bakedGirders = bc.getBakedGirders();
                for (int i = 1; i < bakedGirders.length; ++i) {
                    BezierConnection.GirderAngles segment = bakedGirders[i];
                    int modelIndex = i - 1;
                    this.lightPos[modelIndex] = segment.lightPosition.method_10081((class_2382)tePosition);
                    for (boolean first : Iterate.trueAndFalse) {
                        class_4587.class_4665 beamTransform = segment.beams.get(first);
                        this.beams.get(first)[modelIndex].setTransform(pose).mulPose(beamTransform.method_23761()).mulNormal(beamTransform.method_23762());
                        for (boolean top2 : Iterate.trueAndFalse) {
                            class_4587.class_4665 beamCapTransform = segment.beamCaps.get(top2).get(first);
                            this.beamCaps.get(top2).get(first)[modelIndex].setTransform(pose).mulPose(beamCapTransform.method_23761()).mulNormal(beamCapTransform.method_23762());
                        }
                    }
                }
                this.updateLight();
            }

            void delete() {
                this.beams.forEach(arr -> {
                    for (ModelData d : arr) {
                        d.delete();
                    }
                });
                this.beamCaps.forEach(c -> c.forEach(arr -> {
                    for (ModelData d : arr) {
                        d.delete();
                    }
                }));
            }

            void updateLight() {
                this.beams.forEach(arr -> {
                    for (int i = 0; i < ((ModelData[])arr).length; ++i) {
                        arr[i].updateLight((class_1920)TrackInstance.this.world, this.lightPos[i]);
                    }
                });
                this.beamCaps.forEach(c -> c.forEach(arr -> {
                    for (int i = 0; i < ((ModelData[])arr).length; ++i) {
                        arr[i].updateLight((class_1920)TrackInstance.this.world, this.lightPos[i]);
                    }
                }));
            }
        }
    }
}

