/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.structureMovement.BlockMovementChecks;
import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.content.schematics.MaterialChecklist;
import com.simibubi.create.content.schematics.SchematicWorld;
import com.simibubi.create.content.schematics.item.SchematicItem;
import com.simibubi.create.foundation.tileEntity.IMergeableTE;
import com.simibubi.create.foundation.utility.BBHelper;
import com.simibubi.create.foundation.utility.BlockHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3341;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5425;

public class SchematicPrinter {
    private boolean schematicLoaded;
    private boolean isErrored;
    private SchematicWorld blockReader;
    private class_2338 schematicAnchor;
    private class_2338 currentPos;
    private int printingEntityIndex = -1;
    private PrintStage printStage = PrintStage.BLOCKS;
    private List<class_2338> deferredBlocks = new LinkedList<class_2338>();

    public void fromTag(class_2487 compound, boolean clientPacket) {
        if (compound.method_10545("CurrentPos")) {
            this.currentPos = class_2512.method_10691((class_2487)compound.method_10562("CurrentPos"));
        }
        if (clientPacket) {
            this.schematicLoaded = false;
            if (compound.method_10545("Anchor")) {
                this.schematicAnchor = class_2512.method_10691((class_2487)compound.method_10562("Anchor"));
                this.schematicLoaded = true;
            }
        }
        this.printingEntityIndex = compound.method_10550("EntityProgress");
        this.printStage = PrintStage.valueOf(compound.method_10558("PrintStage"));
        compound.method_10554("DeferredBlocks", 10).stream().map(p -> class_2512.method_10691((class_2487)((class_2487)p))).collect(Collectors.toCollection(() -> this.deferredBlocks));
    }

    public void write(class_2487 compound) {
        if (this.currentPos != null) {
            compound.method_10566("CurrentPos", (class_2520)class_2512.method_10692((class_2338)this.currentPos));
        }
        if (this.schematicAnchor != null) {
            compound.method_10566("Anchor", (class_2520)class_2512.method_10692((class_2338)this.schematicAnchor));
        }
        compound.method_10569("EntityProgress", this.printingEntityIndex);
        compound.method_10582("PrintStage", this.printStage.name());
        class_2499 tagDeferredBlocks = new class_2499();
        for (class_2338 p : this.deferredBlocks) {
            tagDeferredBlocks.add((Object)class_2512.method_10692((class_2338)p));
        }
        compound.method_10566("DeferredBlocks", (class_2520)tagDeferredBlocks);
    }

    public void loadSchematic(class_1799 blueprint, class_1937 originalWorld, boolean processNBT) {
        if (!blueprint.method_7985() || !blueprint.method_7969().method_10577("Deployed")) {
            return;
        }
        class_3499 activeTemplate = SchematicItem.loadSchematic(blueprint);
        class_3492 settings = SchematicItem.getSettings(blueprint, processNBT);
        this.schematicAnchor = class_2512.method_10691((class_2487)blueprint.method_7969().method_10562("Anchor"));
        this.blockReader = new SchematicWorld(this.schematicAnchor, originalWorld);
        try {
            activeTemplate.method_15172((class_5425)this.blockReader, this.schematicAnchor, this.schematicAnchor, settings, this.blockReader.method_8409(), 2);
        }
        catch (Exception e) {
            Create.LOGGER.error("Failed to load Schematic for Printing", (Throwable)e);
            this.schematicLoaded = true;
            this.isErrored = true;
            return;
        }
        class_2338 extraBounds = class_3499.method_15171((class_3492)settings, (class_2338)new class_2338(activeTemplate.method_15160()).method_10069(-1, -1, -1));
        this.blockReader.bounds = BBHelper.encapsulate(this.blockReader.bounds, extraBounds);
        StructureTransform transform = new StructureTransform(settings.method_15134(), class_2350.class_2351.field_11052, settings.method_15113(), settings.method_15114());
        for (class_2586 te : this.blockReader.tileEntities.values()) {
            transform.apply(te);
        }
        this.printingEntityIndex = -1;
        this.printStage = PrintStage.BLOCKS;
        this.deferredBlocks.clear();
        class_3341 bounds = this.blockReader.getBounds();
        this.currentPos = new class_2338(bounds.method_35415() - 1, bounds.method_35416(), bounds.method_35417());
        this.schematicLoaded = true;
    }

    public void resetSchematic() {
        this.schematicLoaded = false;
        this.schematicAnchor = null;
        this.isErrored = false;
        this.currentPos = null;
        this.blockReader = null;
        this.printingEntityIndex = -1;
        this.printStage = PrintStage.BLOCKS;
        this.deferredBlocks.clear();
    }

    public boolean isLoaded() {
        return this.schematicLoaded;
    }

    public boolean isErrored() {
        return this.isErrored;
    }

    public class_2338 getCurrentTarget() {
        if (!this.isLoaded() || this.isErrored()) {
            return null;
        }
        return this.schematicAnchor.method_10081((class_2382)this.currentPos);
    }

    public PrintStage getPrintStage() {
        return this.printStage;
    }

    public class_2338 getAnchor() {
        return this.schematicAnchor;
    }

    public boolean isWorldEmpty() {
        return this.blockReader.getAllPositions().isEmpty();
    }

    public void handleCurrentTarget(BlockTargetHandler blockHandler, EntityTargetHandler entityHandler) {
        class_2338 target = this.getCurrentTarget();
        if (this.printStage == PrintStage.ENTITIES) {
            class_1297 entity = (class_1297)this.blockReader.getEntityStream().collect(Collectors.toList()).get(this.printingEntityIndex);
            entityHandler.handle(target, entity);
        } else {
            class_2680 blockState = BlockHelper.setZeroAge(this.blockReader.method_8320(target));
            class_2586 tileEntity = this.blockReader.method_8321(target);
            blockHandler.handle(target, blockState, tileEntity);
        }
    }

    public boolean shouldPlaceCurrent(class_1937 world) {
        return this.shouldPlaceCurrent(world, (a, b, c, d, e, f) -> true);
    }

    public boolean shouldPlaceCurrent(class_1937 world, PlacementPredicate predicate) {
        if (world == null) {
            return false;
        }
        if (this.printStage == PrintStage.ENTITIES) {
            return true;
        }
        return this.shouldPlaceBlock(world, predicate, this.getCurrentTarget());
    }

    /*
     * Unable to fully structure code
     */
    public boolean shouldPlaceBlock(class_1937 world, PlacementPredicate predicate, class_2338 pos) {
        state = BlockHelper.setZeroAge(this.blockReader.method_8320(pos));
        tileEntity = this.blockReader.method_8321(pos);
        toReplace = world.method_8320(pos);
        toReplaceTE = world.method_8321(pos);
        toReplaceOther = null;
        if (state.method_28498((class_2769)class_2741.field_12483) && state.method_28498((class_2769)class_2741.field_12481) && state.method_11654((class_2769)class_2741.field_12483) == class_2742.field_12557) {
            toReplaceOther = world.method_8320(pos.method_10093((class_2350)state.method_11654((class_2769)class_2741.field_12481)));
        }
        if (state.method_28498((class_2769)class_2741.field_12533) && state.method_11654((class_2769)class_2741.field_12533) == class_2756.field_12607) {
            toReplaceOther = world.method_8320(pos.method_10084());
        }
        if (tileEntity == null || !(toReplaceTE instanceof IMergeableTE)) ** GOTO lbl-1000
        mergeTE = (IMergeableTE)toReplaceTE;
        if (toReplaceTE.method_11017().equals(tileEntity.method_11017())) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = mergeTEs = false;
        }
        if (!world.method_8477(pos)) {
            return false;
        }
        if (!world.method_8621().method_11952(pos)) {
            return false;
        }
        if (toReplace == state && !mergeTEs) {
            return false;
        }
        if (toReplace.method_26214((class_1922)world, pos) == -1.0f || toReplaceOther != null && toReplaceOther.method_26214((class_1922)world, pos) == -1.0f) {
            return false;
        }
        isNormalCube = state.method_26212((class_1922)this.blockReader, this.currentPos);
        return predicate.shouldPlace(pos, state, tileEntity, toReplace, toReplaceOther, isNormalCube);
    }

    public ItemRequirement getCurrentRequirement() {
        if (this.printStage == PrintStage.ENTITIES) {
            return ItemRequirement.of((class_1297)this.blockReader.getEntityStream().collect(Collectors.toList()).get(this.printingEntityIndex));
        }
        class_2338 target = this.getCurrentTarget();
        class_2680 blockState = BlockHelper.setZeroAge(this.blockReader.method_8320(target));
        class_2586 tileEntity = this.blockReader.method_8321(target);
        return ItemRequirement.of(blockState, tileEntity);
    }

    public int markAllBlockRequirements(MaterialChecklist checklist, class_1937 world, PlacementPredicate predicate) {
        int blocksToPlace = 0;
        for (class_2338 pos : this.blockReader.getAllPositions()) {
            ItemRequirement requirement;
            class_2338 relPos = pos.method_10081((class_2382)this.schematicAnchor);
            class_2680 required = this.blockReader.method_8320(relPos);
            class_2586 requiredTE = this.blockReader.method_8321(relPos);
            if (!world.method_8477(pos.method_10081((class_2382)this.schematicAnchor))) {
                checklist.warnBlockNotLoaded();
                continue;
            }
            if (!this.shouldPlaceBlock(world, predicate, relPos) || (requirement = ItemRequirement.of(required, requiredTE)).isEmpty() || requirement.isInvalid()) continue;
            checklist.require(requirement);
            ++blocksToPlace;
        }
        return blocksToPlace;
    }

    public void markAllEntityRequirements(MaterialChecklist checklist) {
        this.blockReader.getEntityStream().forEach(entity -> {
            ItemRequirement requirement = ItemRequirement.of(entity);
            if (requirement.isEmpty()) {
                return;
            }
            if (requirement.isInvalid()) {
                return;
            }
            checklist.require(requirement);
        });
    }

    public boolean advanceCurrentPos() {
        List entities = this.blockReader.getEntityStream().collect(Collectors.toList());
        do {
            if (this.printStage == PrintStage.BLOCKS) {
                while (this.tryAdvanceCurrentPos()) {
                    this.deferredBlocks.add(this.currentPos);
                }
            }
            if (this.printStage == PrintStage.DEFERRED_BLOCKS) {
                if (this.deferredBlocks.isEmpty()) {
                    this.printStage = PrintStage.ENTITIES;
                } else {
                    this.currentPos = this.deferredBlocks.remove(0);
                }
            }
            if (this.printStage != PrintStage.ENTITIES) continue;
            if (this.printingEntityIndex + 1 < entities.size()) {
                ++this.printingEntityIndex;
                this.currentPos = ((class_1297)entities.get(this.printingEntityIndex)).method_24515().method_10059((class_2382)this.schematicAnchor);
                continue;
            }
            return false;
        } while (!this.blockReader.getBounds().method_14662((class_2382)this.currentPos));
        return true;
    }

    public boolean tryAdvanceCurrentPos() {
        this.currentPos = this.currentPos.method_10093(class_2350.field_11034);
        class_3341 bounds = this.blockReader.getBounds();
        class_2338 posInBounds = this.currentPos.method_10069(-bounds.method_35415(), -bounds.method_35416(), -bounds.method_35417());
        if (posInBounds.method_10263() > bounds.method_35414()) {
            this.currentPos = new class_2338(bounds.method_35415(), this.currentPos.method_10264(), this.currentPos.method_10260() + 1).method_10067();
        }
        if (posInBounds.method_10260() > bounds.method_14663()) {
            this.currentPos = new class_2338(this.currentPos.method_10263(), this.currentPos.method_10264() + 1, bounds.method_35417()).method_10067();
        }
        if (this.currentPos.method_10264() > bounds.method_14660()) {
            this.printStage = PrintStage.DEFERRED_BLOCKS;
            return false;
        }
        return SchematicPrinter.shouldDeferBlock(this.blockReader.method_8320(this.getCurrentTarget()));
    }

    public static boolean shouldDeferBlock(class_2680 state) {
        return AllBlocks.GANTRY_CARRIAGE.has(state) || AllBlocks.MECHANICAL_ARM.has(state) || BlockMovementChecks.isBrittle(state);
    }

    public static enum PrintStage {
        BLOCKS,
        DEFERRED_BLOCKS,
        ENTITIES;

    }

    @FunctionalInterface
    public static interface EntityTargetHandler {
        public void handle(class_2338 var1, class_1297 var2);
    }

    @FunctionalInterface
    public static interface BlockTargetHandler {
        public void handle(class_2338 var1, class_2680 var2, class_2586 var3);
    }

    @FunctionalInterface
    public static interface PlacementPredicate {
        public boolean shouldPlace(class_2338 var1, class_2680 var2, class_2586 var3, class_2680 var4, class_2680 var5, boolean var6);
    }
}

