/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.command;

import com.mojang.logging.LogUtils;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.goggles.GoggleConfigScreen;
import com.simibubi.create.content.logistics.trains.CameraDistanceModifier;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.ui.BaseConfigScreen;
import com.simibubi.create.foundation.config.ui.ConfigHelper;
import com.simibubi.create.foundation.config.ui.SubMenuConfigScreen;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.ui.PonderIndexScreen;
import com.simibubi.create.foundation.ponder.ui.PonderUI;
import com.simibubi.create.foundation.utility.CameraAngleAnimationService;
import com.simibubi.create.foundation.utility.Components;
import com.tterrag.registrate.fabric.EnvExecutor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraftforge.fml.config.ModConfig;
import org.slf4j.Logger;

public class SConfigureConfigPacket
extends SimplePacketBase {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String option;
    private final String value;

    public SConfigureConfigPacket(String option, String value) {
        this.option = option;
        this.value = value;
    }

    public SConfigureConfigPacket(class_2540 buffer) {
        this.option = buffer.method_10800(Short.MAX_VALUE);
        this.value = buffer.method_10800(Short.MAX_VALUE);
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10814(this.option);
        buffer.method_10814(this.value);
    }

    @Override
    public void handle(Supplier<SimplePacketBase.Context> ctx) {
        ctx.get().enqueueWork(() -> EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> {
            if (this.option.startsWith("SET")) {
                SConfigureConfigPacket.trySetConfig(this.option.substring(3), this.value);
                return;
            }
            try {
                Actions.valueOf(this.option).performAction(this.value);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Received ConfigureConfigPacket with invalid Option: " + this.option);
            }
        }));
        ctx.get().setPacketHandled(true);
    }

    private static void trySetConfig(String option, String value) {
        ConfigHelper.ConfigPath configPath;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        try {
            configPath = ConfigHelper.ConfigPath.parse(option);
        }
        catch (IllegalArgumentException e) {
            player.method_7353((class_2561)Components.literal(e.getMessage()), false);
            return;
        }
        if (configPath.getType() != ModConfig.Type.CLIENT) {
            Create.LOGGER.warn("Received type-mismatched config packet on client");
            return;
        }
        try {
            ConfigHelper.setConfigValue(configPath, value);
            player.method_7353((class_2561)Components.literal("Great Success!"), false);
        }
        catch (ConfigHelper.InvalidValueException e) {
            player.method_7353((class_2561)Components.literal("Config could not be set the the specified value!"), false);
        }
        catch (Exception e) {
            player.method_7353((class_2561)Components.literal("Something went wrong while trying to set config value. Check the client logs for more information"), false);
            Create.LOGGER.warn("Exception during client-side config value set:", (Throwable)e);
        }
    }

    public static enum Actions {
        configScreen(() -> Actions::configScreen),
        rainbowDebug(() -> Actions::rainbowDebug),
        overlayScreen(() -> Actions::overlayScreen),
        fixLighting(() -> Actions::experimentalLighting),
        overlayReset(() -> Actions::overlayReset),
        openPonder(() -> Actions::openPonder),
        fabulousWarning(() -> Actions::fabulousWarning),
        zoomMultiplier(() -> Actions::zoomMultiplier),
        camAngleYawTarget(() -> value -> Actions.camAngleTarget(value, true)),
        camAnglePitchTarget(() -> value -> Actions.camAngleTarget(value, false)),
        camAngleFunction(() -> Actions::camAngleFunction);

        private final Supplier<Consumer<String>> consumer;

        private Actions(Supplier<Consumer<String>> action) {
            this.consumer = action;
        }

        void performAction(String value) {
            this.consumer.get().accept(value);
        }

        @Environment(value=EnvType.CLIENT)
        private static void configScreen(String value) {
            ConfigHelper.ConfigPath configPath;
            if (value.equals("")) {
                ScreenOpener.open(BaseConfigScreen.forCreate(null));
                return;
            }
            class_746 player = class_310.method_1551().field_1724;
            try {
                configPath = ConfigHelper.ConfigPath.parse(value);
            }
            catch (IllegalArgumentException e) {
                player.method_7353((class_2561)Components.literal(e.getMessage()), false);
                return;
            }
            try {
                ScreenOpener.open(SubMenuConfigScreen.find(configPath));
            }
            catch (Exception e) {
                player.method_7353((class_2561)Components.literal("Unable to find the specified config"), false);
            }
        }

        @Environment(value=EnvType.CLIENT)
        private static void rainbowDebug(String value) {
            class_746 player = class_310.method_1551().field_1724;
            if (player == null || "".equals(value)) {
                return;
            }
            if (value.equals("info")) {
                class_5250 text = Components.literal("Rainbow Debug Utility is currently: ").method_10852((class_2561)Actions.boolToText((Boolean)AllConfigs.CLIENT.rainbowDebug.get()));
                player.method_7353((class_2561)text, false);
                return;
            }
            AllConfigs.CLIENT.rainbowDebug.set(Boolean.parseBoolean(value));
            class_5250 text = Actions.boolToText((Boolean)AllConfigs.CLIENT.rainbowDebug.get()).method_10852((class_2561)Components.literal(" Rainbow Debug Utility").method_27692(class_124.field_1068));
            player.method_7353((class_2561)text, false);
        }

        @Environment(value=EnvType.CLIENT)
        private static void overlayReset(String value) {
            AllConfigs.CLIENT.overlayOffsetX.set(0);
            AllConfigs.CLIENT.overlayOffsetY.set(0);
        }

        @Environment(value=EnvType.CLIENT)
        private static void overlayScreen(String value) {
            ScreenOpener.open(new GoggleConfigScreen());
        }

        @Environment(value=EnvType.CLIENT)
        private static void experimentalLighting(String value) {
            class_310.method_1551().field_1769.method_3279();
        }

        @Environment(value=EnvType.CLIENT)
        private static void openPonder(String value) {
            if (value.equals("index")) {
                ScreenOpener.transitionTo(new PonderIndexScreen());
                return;
            }
            class_2960 id = new class_2960(value);
            if (!PonderRegistry.ALL.containsKey(id)) {
                Create.LOGGER.error("Could not find ponder scenes for item: " + id);
                return;
            }
            ScreenOpener.transitionTo(PonderUI.of(id));
        }

        @Environment(value=EnvType.CLIENT)
        private static void fabulousWarning(String value) {
            AllConfigs.CLIENT.ignoreFabulousWarning.set(true);
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                player.method_7353((class_2561)Components.literal("Disabled Fabulous graphics warning"), false);
            }
        }

        @Environment(value=EnvType.CLIENT)
        private static void zoomMultiplier(String value) {
            try {
                float v = Float.parseFloat(value);
                if (v <= 0.0f) {
                    return;
                }
                CameraDistanceModifier.zoomOut(v);
            }
            catch (NumberFormatException ignored) {
                Create.LOGGER.debug("Received non-float value {} in zoom packet, ignoring", (Object)value);
            }
        }

        @Environment(value=EnvType.CLIENT)
        private static void camAngleTarget(String value, boolean yaw) {
            try {
                float v = Float.parseFloat(value);
                if (yaw) {
                    CameraAngleAnimationService.setYawTarget(v);
                } else {
                    CameraAngleAnimationService.setPitchTarget(v);
                }
            }
            catch (NumberFormatException ignored) {
                Create.LOGGER.debug("Received non-float value {} in camAngle packet, ignoring", (Object)value);
            }
        }

        @Environment(value=EnvType.CLIENT)
        private static void camAngleFunction(String value) {
            CameraAngleAnimationService.Mode mode = CameraAngleAnimationService.Mode.LINEAR;
            String modeString = value;
            float speed = -1.0f;
            String[] split = value.split(":");
            if (split.length > 1) {
                modeString = split[0];
                try {
                    speed = Float.parseFloat(split[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            try {
                mode = CameraAngleAnimationService.Mode.valueOf(modeString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            CameraAngleAnimationService.setAnimationMode(mode);
            CameraAngleAnimationService.setAnimationSpeed(speed);
        }

        private static class_5250 boolToText(boolean b) {
            return b ? Components.literal("enabled").method_27692(class_124.field_1077) : Components.literal("disabled").method_27692(class_124.field_1061);
        }
    }
}

