/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.simibubi.create.foundation.ponder.PonderChapter;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderTag;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2960;

public class PonderStoryBoardEntry {
    private final PonderStoryBoard board;
    private final String namespace;
    private final class_2960 schematicLocation;
    private final class_2960 component;
    private final List<PonderTag> tags;

    public PonderStoryBoardEntry(PonderStoryBoard board, String namespace, class_2960 schematicLocation, class_2960 component) {
        this.board = board;
        this.namespace = namespace;
        this.schematicLocation = schematicLocation;
        this.component = component;
        this.tags = new ArrayList<PonderTag>();
    }

    public PonderStoryBoardEntry(PonderStoryBoard board, String namespace, String schematicPath, class_2960 component) {
        this(board, namespace, new class_2960(namespace, schematicPath), component);
    }

    public PonderStoryBoard getBoard() {
        return this.board;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public class_2960 getSchematicLocation() {
        return this.schematicLocation;
    }

    public class_2960 getComponent() {
        return this.component;
    }

    public List<PonderTag> getTags() {
        return this.tags;
    }

    public PonderStoryBoardEntry highlightTag(PonderTag tag) {
        this.tags.add(tag);
        return this;
    }

    public PonderStoryBoardEntry highlightTags(PonderTag ... tags) {
        Collections.addAll(this.tags, tags);
        return this;
    }

    public PonderStoryBoardEntry highlightAllTags() {
        this.tags.add(PonderTag.Highlight.ALL);
        return this;
    }

    public PonderStoryBoardEntry chapter(PonderChapter chapter) {
        PonderRegistry.CHAPTERS.addStoriesToChapter(chapter, this);
        return this;
    }

    public PonderStoryBoardEntry chapters(PonderChapter ... chapters) {
        for (PonderChapter c : chapters) {
            this.chapter(c);
        }
        return this;
    }

    @FunctionalInterface
    public static interface PonderStoryBoard {
        public void program(SceneBuilder var1, SceneBuildingUtil var2);
    }
}

