/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.simibubi.create.foundation.utility.outliner.Outline;
import com.simibubi.create.foundation.utility.outliner.Outliner;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3341;

public abstract class Selection
implements Predicate<class_2338> {
    public static Selection of(class_3341 bb) {
        return new Simple(bb);
    }

    public abstract Selection add(Selection var1);

    public abstract Selection substract(Selection var1);

    public abstract Selection copy();

    public abstract class_243 getCenter();

    public abstract void forEach(Consumer<class_2338> var1);

    public abstract Outline.OutlineParams makeOutline(Outliner var1, Object var2);

    public Outline.OutlineParams makeOutline(Outliner outliner) {
        return this.makeOutline(outliner, this);
    }

    private static class Simple
    extends Selection {
        private class_3341 bb;
        private class_238 aabb;

        public Simple(class_3341 bb) {
            this.bb = bb;
            this.aabb = this.getAABB();
        }

        @Override
        public boolean test(class_2338 t) {
            return this.bb.method_14662((class_2382)t);
        }

        @Override
        public Selection add(Selection other) {
            return new Compound(this).add(other);
        }

        @Override
        public Selection substract(Selection other) {
            return new Compound(this).substract(other);
        }

        @Override
        public void forEach(Consumer<class_2338> callback) {
            class_2338.method_23627((class_3341)this.bb).forEach(callback);
        }

        @Override
        public class_243 getCenter() {
            return this.aabb.method_1005();
        }

        @Override
        public Outline.OutlineParams makeOutline(Outliner outliner, Object slot) {
            return outliner.showAABB(slot, this.aabb);
        }

        private class_238 getAABB() {
            return new class_238((double)this.bb.method_35415(), (double)this.bb.method_35416(), (double)this.bb.method_35417(), (double)(this.bb.method_35418() + 1), (double)(this.bb.method_35419() + 1), (double)(this.bb.method_35420() + 1));
        }

        @Override
        public Selection copy() {
            return new Simple(new class_3341(this.bb.method_35415(), this.bb.method_35416(), this.bb.method_35417(), this.bb.method_35418(), this.bb.method_35419(), this.bb.method_35420()));
        }
    }

    private static class Compound
    extends Selection {
        Set<class_2338> posSet;
        class_243 center;

        public Compound(Simple initial) {
            this.posSet = new HashSet<class_2338>();
            this.add(initial);
        }

        private Compound(Set<class_2338> template) {
            this.posSet = new HashSet<class_2338>(template);
        }

        @Override
        public boolean test(class_2338 t) {
            return this.posSet.contains(t);
        }

        @Override
        public Selection add(Selection other) {
            other.forEach(p -> this.posSet.add(p.method_10062()));
            this.center = null;
            return this;
        }

        @Override
        public Selection substract(Selection other) {
            other.forEach(p -> this.posSet.remove(p.method_10062()));
            this.center = null;
            return this;
        }

        @Override
        public void forEach(Consumer<class_2338> callback) {
            this.posSet.forEach(callback);
        }

        @Override
        public Outline.OutlineParams makeOutline(Outliner outliner, Object slot) {
            return outliner.showCluster(slot, this.posSet);
        }

        @Override
        public class_243 getCenter() {
            return this.center == null ? (this.center = this.evalCenter()) : this.center;
        }

        private class_243 evalCenter() {
            class_243 center = class_243.field_1353;
            if (this.posSet.isEmpty()) {
                return center;
            }
            for (class_2338 blockPos : this.posSet) {
                center = center.method_1019(class_243.method_24954((class_2382)blockPos));
            }
            center = center.method_1021((double)(1.0f / (float)this.posSet.size()));
            return center.method_1019(new class_243(0.5, 0.5, 0.5));
        }

        @Override
        public Selection copy() {
            return new Compound(this.posSet);
        }
    }
}

