/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render;

import com.jozufozu.flywheel.api.vertex.ShadedVertexList;
import com.jozufozu.flywheel.api.vertex.VertexList;
import com.jozufozu.flywheel.backend.ShadersModHandler;
import com.jozufozu.flywheel.core.model.ShadeSeparatedBufferBuilder;
import com.jozufozu.flywheel.core.vertex.BlockVertexList;
import com.jozufozu.flywheel.util.DiffuseLightCalculator;
import com.jozufozu.flywheel.util.transform.TStack;
import com.jozufozu.flywheel.util.transform.Transform;
import com.mojang.datafixers.util.Pair;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.render.ForcedDiffuseState;
import com.simibubi.create.foundation.utility.Color;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.nio.ByteBuffer;
import java.util.function.IntPredicate;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_761;
import net.minecraft.class_765;

public class SuperByteBuffer
implements Transform<SuperByteBuffer>,
TStack<SuperByteBuffer> {
    private final VertexList template;
    private final IntPredicate shadedPredicate;
    private final class_4587 transforms;
    private boolean shouldColor;
    private int r;
    private int g;
    private int b;
    private int a;
    private boolean disableDiffuseMult;
    private DiffuseLightCalculator diffuseCalculator;
    private SpriteShiftFunc spriteShiftFunc;
    private boolean hasOverlay;
    private int overlay = class_4608.field_21444;
    private boolean useWorldLight;
    private class_1159 lightTransform;
    private boolean hasCustomLight;
    private int packedLightCoords;
    private boolean hybridLight;
    private boolean fullNormalTransform;
    private static final Long2IntMap WORLD_LIGHT_CACHE = new Long2IntOpenHashMap();

    public SuperByteBuffer(class_287 buf) {
        Pair pair = buf.method_22632();
        class_287.class_4574 drawState = (class_287.class_4574)pair.getFirst();
        ByteBuffer buffer = (ByteBuffer)pair.getSecond();
        int vertexCount = drawState.method_22635();
        int stride = drawState.method_22634().method_1362();
        if (buf instanceof ShadeSeparatedBufferBuilder) {
            ShadeSeparatedBufferBuilder separated = (ShadeSeparatedBufferBuilder)buf;
            BlockVertexList.Shaded template = new BlockVertexList.Shaded(buffer, vertexCount, stride, separated.getUnshadedStartVertex());
            this.shadedPredicate = arg_0 -> ((ShadedVertexList)template).isShaded(arg_0);
            this.template = template;
        } else {
            this.template = new BlockVertexList(buffer, vertexCount, stride);
            this.shadedPredicate = index -> true;
        }
        this.transforms = new class_4587();
        this.transforms.method_22903();
    }

    public void renderInto(class_4587 input, class_4588 builder) {
        boolean disableDiffuseMult;
        class_4581 normalMat;
        if (this.isEmpty()) {
            return;
        }
        class_1159 modelMat = input.method_23760().method_23761().method_22673();
        class_1159 localTransforms = this.transforms.method_23760().method_23761();
        modelMat.method_22672(localTransforms);
        if (this.fullNormalTransform) {
            normalMat = input.method_23760().method_23762().method_23296();
            class_4581 localNormalTransforms = this.transforms.method_23760().method_23762();
            normalMat.method_22855(localNormalTransforms);
        } else {
            normalMat = this.transforms.method_23760().method_23762().method_23296();
        }
        if (this.useWorldLight) {
            WORLD_LIGHT_CACHE.clear();
        }
        class_1162 pos = new class_1162();
        class_1160 normal = new class_1160();
        class_1162 lightPos = new class_1162();
        DiffuseLightCalculator diffuseCalculator = ForcedDiffuseState.getForcedCalculator();
        boolean bl = disableDiffuseMult = this.disableDiffuseMult || ShadersModHandler.isShaderPackInUse() && diffuseCalculator == null;
        if (diffuseCalculator == null && (diffuseCalculator = this.diffuseCalculator) == null) {
            diffuseCalculator = DiffuseLightCalculator.forCurrentLevel();
        }
        int vertexCount = this.template.getVertexCount();
        for (int i = 0; i < vertexCount; ++i) {
            int light;
            byte a;
            byte b;
            byte g;
            byte r;
            float x = this.template.getX(i);
            float y = this.template.getY(i);
            float z = this.template.getZ(i);
            pos.method_23851(x, y, z, 1.0f);
            pos.method_22674(modelMat);
            builder.method_22912((double)pos.method_4953(), (double)pos.method_4956(), (double)pos.method_4957());
            float normalX = this.template.getNX(i);
            float normalY = this.template.getNY(i);
            float normalZ = this.template.getNZ(i);
            normal.method_4949(normalX, normalY, normalZ);
            normal.method_23215(normalMat);
            float nx = normal.method_4943();
            float ny = normal.method_4945();
            float nz = normal.method_4947();
            if (this.shouldColor) {
                r = (byte)this.r;
                g = (byte)this.g;
                b = (byte)this.b;
                a = (byte)this.a;
            } else {
                r = this.template.getR(i);
                g = this.template.getG(i);
                b = this.template.getB(i);
                a = this.template.getA(i);
            }
            if (disableDiffuseMult) {
                builder.method_1336((int)r, (int)g, (int)b, (int)a);
            } else {
                float instanceDiffuse = diffuseCalculator.getDiffuse(nx, ny, nz, this.shadedPredicate.test(i));
                int colorR = SuperByteBuffer.transformColor(r, instanceDiffuse);
                int colorG = SuperByteBuffer.transformColor(g, instanceDiffuse);
                int colorB = SuperByteBuffer.transformColor(b, instanceDiffuse);
                builder.method_1336(colorR, colorG, colorB, (int)a);
            }
            float u = this.template.getU(i);
            float v = this.template.getV(i);
            if (this.spriteShiftFunc != null) {
                this.spriteShiftFunc.shift(builder, u, v);
            } else {
                builder.method_22913(u, v);
            }
            if (this.hasOverlay) {
                builder.method_22922(this.overlay);
            }
            if (this.useWorldLight) {
                lightPos.method_23851((x - 0.5f) * 15.0f / 16.0f + 0.5f, (y - 0.5f) * 15.0f / 16.0f + 0.5f, (z - 0.5f) * 15.0f / 16.0f + 0.5f, 1.0f);
                lightPos.method_22674(localTransforms);
                if (this.lightTransform != null) {
                    lightPos.method_22674(this.lightTransform);
                }
                light = SuperByteBuffer.getLight((class_1937)class_310.method_1551().field_1687, lightPos);
                if (this.hasCustomLight) {
                    light = SuperByteBuffer.maxLight(light, this.packedLightCoords);
                }
            } else {
                light = this.hasCustomLight ? this.packedLightCoords : this.template.getLight(i);
            }
            if (this.hybridLight) {
                builder.method_22916(SuperByteBuffer.maxLight(light, this.template.getLight(i)));
            } else {
                builder.method_22916(light);
            }
            builder.method_22914(nx, ny, nz);
            builder.method_1344();
        }
        this.reset();
    }

    public SuperByteBuffer reset() {
        while (!this.transforms.method_22911()) {
            this.transforms.method_22909();
        }
        this.transforms.method_22903();
        this.shouldColor = false;
        this.r = 0;
        this.g = 0;
        this.b = 0;
        this.a = 0;
        this.disableDiffuseMult = false;
        this.diffuseCalculator = null;
        this.spriteShiftFunc = null;
        this.hasOverlay = false;
        this.overlay = class_4608.field_21444;
        this.useWorldLight = false;
        this.lightTransform = null;
        this.hasCustomLight = false;
        this.packedLightCoords = 0;
        this.hybridLight = false;
        this.fullNormalTransform = false;
        return this;
    }

    public boolean isEmpty() {
        return this.template.isEmpty();
    }

    public class_4587 getTransforms() {
        return this.transforms;
    }

    public SuperByteBuffer translate(double x, double y, double z) {
        this.transforms.method_22904(x, y, z);
        return this;
    }

    public SuperByteBuffer multiply(class_1158 quaternion) {
        this.transforms.method_22907(quaternion);
        return this;
    }

    public SuperByteBuffer scale(float factorX, float factorY, float factorZ) {
        this.transforms.method_22905(factorX, factorY, factorZ);
        return this;
    }

    public SuperByteBuffer pushPose() {
        this.transforms.method_22903();
        return this;
    }

    public SuperByteBuffer popPose() {
        this.transforms.method_22909();
        return this;
    }

    public SuperByteBuffer mulPose(class_1159 pose) {
        this.transforms.method_23760().method_23761().method_22672(pose);
        return this;
    }

    public SuperByteBuffer mulNormal(class_4581 normal) {
        this.transforms.method_23760().method_23762().method_22855(normal);
        return this;
    }

    public SuperByteBuffer transform(class_4587 stack) {
        this.transforms.method_23760().method_23761().method_22672(stack.method_23760().method_23761());
        this.transforms.method_23760().method_23762().method_22855(stack.method_23760().method_23762());
        return this;
    }

    public SuperByteBuffer rotateCentered(class_2350 axis, float radians) {
        ((SuperByteBuffer)this.translate(0.5, 0.5, 0.5).rotate(axis, radians)).translate(-0.5, -0.5, -0.5);
        return this;
    }

    public SuperByteBuffer rotateCentered(class_1158 q) {
        this.translate(0.5, 0.5, 0.5).multiply(q).translate(-0.5, -0.5, -0.5);
        return this;
    }

    public SuperByteBuffer color(int r, int g, int b, int a) {
        this.shouldColor = true;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        return this;
    }

    public SuperByteBuffer color(int color) {
        this.shouldColor = true;
        this.r = color >> 16 & 0xFF;
        this.g = color >> 8 & 0xFF;
        this.b = color & 0xFF;
        this.a = 255;
        return this;
    }

    public SuperByteBuffer color(Color c) {
        return this.color(c.getRGB());
    }

    public SuperByteBuffer disableDiffuse() {
        this.disableDiffuseMult = true;
        return this;
    }

    public SuperByteBuffer diffuseCalculator(DiffuseLightCalculator diffuseCalculator) {
        this.diffuseCalculator = diffuseCalculator;
        return this;
    }

    public SuperByteBuffer shiftUV(SpriteShiftEntry entry) {
        this.spriteShiftFunc = (builder, u, v) -> builder.method_22913(entry.getTargetU(u), entry.getTargetV(v));
        return this;
    }

    public SuperByteBuffer shiftUVScrolling(SpriteShiftEntry entry, float scrollV) {
        return this.shiftUVScrolling(entry, 0.0f, scrollV);
    }

    public SuperByteBuffer shiftUVScrolling(SpriteShiftEntry entry, float scrollU, float scrollV) {
        this.spriteShiftFunc = (builder, u, v) -> {
            float targetU = u - entry.getOriginal().method_4594() + entry.getTarget().method_4594() + scrollU;
            float targetV = v - entry.getOriginal().method_4593() + entry.getTarget().method_4593() + scrollV;
            builder.method_22913(targetU, targetV);
        };
        return this;
    }

    public SuperByteBuffer shiftUVtoSheet(SpriteShiftEntry entry, float uTarget, float vTarget, int sheetSize) {
        this.spriteShiftFunc = (builder, u, v) -> {
            float targetU = entry.getTarget().method_4580((double)(SpriteShiftEntry.getUnInterpolatedU(entry.getOriginal(), u) / (float)sheetSize + uTarget * 16.0f));
            float targetV = entry.getTarget().method_4570((double)(SpriteShiftEntry.getUnInterpolatedV(entry.getOriginal(), v) / (float)sheetSize + vTarget * 16.0f));
            builder.method_22913(targetU, targetV);
        };
        return this;
    }

    public SuperByteBuffer overlay() {
        this.hasOverlay = true;
        return this;
    }

    public SuperByteBuffer overlay(int overlay) {
        this.hasOverlay = true;
        this.overlay = overlay;
        return this;
    }

    public SuperByteBuffer light() {
        this.useWorldLight = true;
        return this;
    }

    public SuperByteBuffer light(class_1159 lightTransform) {
        this.useWorldLight = true;
        this.lightTransform = lightTransform;
        return this;
    }

    public SuperByteBuffer light(int packedLightCoords) {
        this.hasCustomLight = true;
        this.packedLightCoords = packedLightCoords;
        return this;
    }

    public SuperByteBuffer light(class_1159 lightTransform, int packedLightCoords) {
        this.light(lightTransform);
        this.light(packedLightCoords);
        return this;
    }

    public SuperByteBuffer hybridLight() {
        this.hybridLight = true;
        return this;
    }

    public SuperByteBuffer fullNormalTransform() {
        this.fullNormalTransform = true;
        return this;
    }

    public SuperByteBuffer forEntityRender() {
        this.disableDiffuse();
        this.overlay();
        this.fullNormalTransform();
        return this;
    }

    public static int transformColor(byte component, float scale) {
        return class_3532.method_15340((int)((int)((float)Byte.toUnsignedInt(component) * scale)), (int)0, (int)255);
    }

    public static int transformColor(int component, float scale) {
        return class_3532.method_15340((int)((int)((float)component * scale)), (int)0, (int)255);
    }

    public static int maxLight(int packedLight1, int packedLight2) {
        int blockLight1 = class_765.method_24186((int)packedLight1);
        int skyLight1 = class_765.method_24187((int)packedLight1);
        int blockLight2 = class_765.method_24186((int)packedLight2);
        int skyLight2 = class_765.method_24187((int)packedLight2);
        return class_765.method_23687((int)Math.max(blockLight1, blockLight2), (int)Math.max(skyLight1, skyLight2));
    }

    private static int getLight(class_1937 world, class_1162 lightPos) {
        class_2338 pos = new class_2338((double)lightPos.method_4953(), (double)lightPos.method_4956(), (double)lightPos.method_4957());
        return WORLD_LIGHT_CACHE.computeIfAbsent(pos.method_10063(), $ -> class_761.method_23794((class_1920)world, (class_2338)pos));
    }

    @FunctionalInterface
    public static interface SpriteShiftFunc {
        public void shift(class_4588 var1, float var2, float var3);
    }

    @FunctionalInterface
    public static interface VertexLighter {
        public int getPackedLight(float var1, float var2, float var3);
    }
}

