/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity;

import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import java.util.ConcurrentModificationException;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public abstract class TileEntityBehaviour {
    public SmartTileEntity tileEntity;
    private int lazyTickRate;
    private int lazyTickCounter;

    public TileEntityBehaviour(SmartTileEntity te) {
        this.tileEntity = te;
        this.setLazyTickRate(10);
    }

    public abstract BehaviourType<?> getType();

    public void initialize() {
    }

    public void tick() {
        if (this.lazyTickCounter-- <= 0) {
            this.lazyTickCounter = this.lazyTickRate;
            this.lazyTick();
        }
    }

    public void read(class_2487 nbt, boolean clientPacket) {
    }

    public void write(class_2487 nbt, boolean clientPacket) {
    }

    public boolean isSafeNBT() {
        return false;
    }

    public ItemRequirement getRequiredItems() {
        return ItemRequirement.NONE;
    }

    public void onBlockChanged(class_2680 oldState) {
    }

    public void onNeighborChanged(class_2338 neighborPos) {
    }

    public void unload() {
    }

    public void destroy() {
    }

    public void setLazyTickRate(int slowTickRate) {
        this.lazyTickRate = slowTickRate;
        this.lazyTickCounter = slowTickRate;
    }

    public void lazyTick() {
    }

    public class_2338 getPos() {
        return this.tileEntity.method_11016();
    }

    public class_1937 getWorld() {
        return this.tileEntity.method_10997();
    }

    public static <T extends TileEntityBehaviour> T get(class_1922 reader, class_2338 pos, BehaviourType<T> type) {
        class_2586 te;
        try {
            te = reader.method_8321(pos);
        }
        catch (ConcurrentModificationException e) {
            te = null;
        }
        return TileEntityBehaviour.get(te, type);
    }

    public static <T extends TileEntityBehaviour> T get(class_2586 te, BehaviourType<T> type) {
        if (te == null) {
            return null;
        }
        if (!(te instanceof SmartTileEntity)) {
            return null;
        }
        SmartTileEntity ste = (SmartTileEntity)te;
        return ste.getBehaviour(type);
    }
}

