/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.filtering;

import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringCountUpdatePacket;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.pepperbell.simplenetworking.C2SPacket;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;

public class FilteringBehaviour
extends TileEntityBehaviour {
    public static final BehaviourType<FilteringBehaviour> TYPE = new BehaviourType();
    ValueBoxTransform slotPositioning;
    boolean showCount;
    class_243 textShift;
    private class_1799 filter = class_1799.field_8037;
    public int count;
    private Consumer<class_1799> callback;
    private Supplier<Boolean> isActive;
    private Supplier<Boolean> showCountPredicate;
    private Predicate<class_1657> canInteract;
    int scrollableValue;
    int ticksUntilScrollPacket;
    boolean forceClientState;
    boolean recipeFilter;
    boolean fluidFilter;

    public FilteringBehaviour(SmartTileEntity te, ValueBoxTransform slot) {
        super(te);
        this.slotPositioning = slot;
        this.showCount = false;
        this.callback = stack -> {};
        this.isActive = () -> true;
        this.textShift = class_243.field_1353;
        this.count = 0;
        this.ticksUntilScrollPacket = -1;
        this.showCountPredicate = () -> this.showCount;
        this.recipeFilter = false;
        this.fluidFilter = false;
        this.canInteract = FilteringBehaviour::playerCanInteract;
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(class_2487 nbt, boolean clientPacket) {
        nbt.method_10566("Filter", NBTSerializer.serializeNBT((Object)this.getFilter()));
        nbt.method_10569("FilterAmount", this.count);
        if (clientPacket && this.forceClientState) {
            nbt.method_10556("ForceScrollable", true);
            this.forceClientState = false;
        }
        super.write(nbt, clientPacket);
    }

    @Override
    public void read(class_2487 nbt, boolean clientPacket) {
        this.filter = class_1799.method_7915((class_2487)nbt.method_10562("Filter"));
        this.count = nbt.method_10550("FilterAmount");
        if (nbt.method_10545("ForceScrollable")) {
            this.scrollableValue = this.count;
            this.ticksUntilScrollPacket = -1;
        }
        super.read(nbt, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.getWorld().field_9236) {
            return;
        }
        if (this.ticksUntilScrollPacket == -1) {
            return;
        }
        if (this.ticksUntilScrollPacket > 0) {
            --this.ticksUntilScrollPacket;
            return;
        }
        AllPackets.channel.sendToServer((C2SPacket)new FilteringCountUpdatePacket(this.getPos(), this.scrollableValue));
        this.ticksUntilScrollPacket = -1;
    }

    public FilteringBehaviour withCallback(Consumer<class_1799> filterCallback) {
        this.callback = filterCallback;
        return this;
    }

    public FilteringBehaviour forRecipes() {
        this.recipeFilter = true;
        return this;
    }

    public FilteringBehaviour forFluids() {
        this.fluidFilter = true;
        return this;
    }

    public FilteringBehaviour onlyActiveWhen(Supplier<Boolean> condition) {
        this.isActive = condition;
        return this;
    }

    public FilteringBehaviour showCountWhen(Supplier<Boolean> condition) {
        this.showCountPredicate = condition;
        return this;
    }

    public FilteringBehaviour interactiveWhen(Predicate<class_1657> condition) {
        this.canInteract = condition;
        return this;
    }

    public FilteringBehaviour showCount() {
        this.showCount = true;
        return this;
    }

    public FilteringBehaviour moveText(class_243 shift) {
        this.textShift = shift;
        return this;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.scrollableValue = this.count;
    }

    public void setFilter(class_2350 face, class_1799 stack) {
        this.setFilter(stack);
    }

    public void setFilter(class_1799 stack) {
        boolean confirm = ItemHandlerHelper.canItemStacksStack((class_1799)stack, (class_1799)this.filter);
        this.filter = stack.method_7972();
        this.callback.accept(this.filter);
        this.count = !confirm ? 0 : (this.filter.method_7909() instanceof FilterItem ? 0 : Math.min(stack.method_7947(), stack.method_7914()));
        this.forceClientState = true;
        this.tileEntity.method_5431();
        this.tileEntity.sendData();
    }

    @Override
    public void destroy() {
        if (this.filter.method_7909() instanceof FilterItem) {
            class_243 pos = VecHelper.getCenterOf((class_2382)this.getPos());
            class_1937 world = this.getWorld();
            world.method_8649((class_1297)new class_1542(world, pos.field_1352, pos.field_1351, pos.field_1350, this.filter.method_7972()));
        }
        super.destroy();
    }

    @Override
    public ItemRequirement getRequiredItems() {
        class_1792 filterItem = this.filter.method_7909();
        if (filterItem instanceof FilterItem) {
            return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, filterItem);
        }
        return ItemRequirement.NONE;
    }

    public class_1799 getFilter(class_2350 side) {
        return this.getFilter();
    }

    public class_1799 getFilter() {
        return this.filter.method_7972();
    }

    public boolean isCountVisible() {
        return this.showCountPredicate.get();
    }

    public boolean canInteract(class_1657 player) {
        return this.canInteract.test(player);
    }

    public boolean test(class_1799 stack) {
        return !this.isActive() || this.filter.method_7960() || FilterItem.test(this.tileEntity.method_10997(), stack, this.filter);
    }

    public boolean test(FluidStack stack) {
        return !this.isActive() || this.filter.method_7960() || FilterItem.test(this.tileEntity.method_10997(), stack, this.filter);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public boolean testHit(class_243 hit) {
        class_2680 state = this.tileEntity.method_11010();
        class_243 localHit = hit.method_1020(class_243.method_24954((class_2382)this.tileEntity.method_11016()));
        return this.slotPositioning.testHit(state, localHit);
    }

    public int getAmount() {
        return this.count;
    }

    public boolean anyAmount() {
        return this.count == 0;
    }

    public boolean isActive() {
        return this.isActive.get();
    }

    public static boolean playerCanInteract(class_1657 player) {
        boolean adventure = !player.method_7294() && !player.method_7325();
        return !adventure || (Boolean)AllConfigs.SERVER.limitAdventureMode.get() == false;
    }
}

