/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.inventory;

import com.google.common.base.Predicates;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.CapManipulationBehaviourBase;
import io.github.fabricators_of_create.porting_lib.transfer.StorageProvider;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import org.jetbrains.annotations.Nullable;

public class InvManipulationBehaviour
extends CapManipulationBehaviourBase<ItemVariant, InvManipulationBehaviour> {
    public static final BehaviourType<InvManipulationBehaviour> TYPE = new BehaviourType();
    public static final BehaviourType<InvManipulationBehaviour> EXTRACT = new BehaviourType();
    public static final BehaviourType<InvManipulationBehaviour> INSERT = new BehaviourType();
    private BehaviourType<InvManipulationBehaviour> behaviourType;

    public static InvManipulationBehaviour forExtraction(SmartTileEntity te, CapManipulationBehaviourBase.InterfaceProvider target) {
        return new InvManipulationBehaviour(EXTRACT, te, target);
    }

    public static InvManipulationBehaviour forInsertion(SmartTileEntity te, CapManipulationBehaviourBase.InterfaceProvider target) {
        return new InvManipulationBehaviour(INSERT, te, target);
    }

    public InvManipulationBehaviour(SmartTileEntity te, CapManipulationBehaviourBase.InterfaceProvider target) {
        this(TYPE, te, target);
    }

    private InvManipulationBehaviour(BehaviourType<InvManipulationBehaviour> type, SmartTileEntity te, CapManipulationBehaviourBase.InterfaceProvider target) {
        super(te, target);
        this.behaviourType = type;
    }

    @Override
    protected StorageProvider<ItemVariant> getProvider(class_2338 pos, boolean bypassSided) {
        return bypassSided ? new UnsidedItemStorageProvider(this.getWorld(), pos) : StorageProvider.createForItems((class_1937)this.getWorld(), (class_2338)pos);
    }

    public class_1799 extract() {
        return this.extract(this.getAmountFromFilter());
    }

    public class_1799 extract(int amount) {
        return this.extract(amount, (Predicate<class_1799>)Predicates.alwaysTrue());
    }

    public class_1799 extract(int amount, Predicate<class_1799> filter) {
        return this.extract(amount, filter, class_1799::method_7914);
    }

    public class_1799 extract(int amount, Predicate<class_1799> filter, Function<class_1799, Integer> amountThreshold) {
        boolean shouldSimulate = this.simulateNext;
        this.simulateNext = false;
        if (this.getWorld().field_9236 || !this.hasInventory()) {
            return class_1799.field_8037;
        }
        Storage inventory = this.getInventory();
        if (inventory == null) {
            return class_1799.field_8037;
        }
        Predicate<class_1799> test = this.getFilterTest(filter);
        class_1799 simulatedItems = InvManipulationBehaviour.extractAmountOrThresh(inventory, test, amount, amountThreshold, true);
        if (shouldSimulate || simulatedItems.method_7960()) {
            return simulatedItems;
        }
        return InvManipulationBehaviour.extractAmountOrThresh(inventory, test, amount, amountThreshold, false);
    }

    private static class_1799 extractAmountOrThresh(Storage<ItemVariant> inventory, Predicate<class_1799> test, int amount, Function<class_1799, Integer> amountThreshold, boolean shouldSimulate) {
        if (amount == -1) {
            return ItemHelper.extract(inventory, test, amountThreshold, shouldSimulate);
        }
        return ItemHelper.extract(inventory, test, amount, shouldSimulate);
    }

    public class_1799 insert(class_1799 stack) {
        Storage inventory;
        boolean shouldSimulate = this.simulateNext;
        this.simulateNext = false;
        Storage storage = inventory = this.hasInventory() ? this.getInventory() : null;
        if (inventory == null) {
            return stack;
        }
        try (Transaction t = TransferUtil.getTransaction();){
            long remainder;
            long inserted = inventory.insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)t);
            if (!shouldSimulate) {
                t.commit();
            }
            if ((remainder = (long)stack.method_7947() - inserted) == 0L) {
                class_1799 class_17992 = class_1799.field_8037;
                return class_17992;
            }
            stack = stack.method_7972();
            stack.method_7939((int)remainder);
            class_1799 class_17993 = stack;
            return class_17993;
        }
    }

    protected Predicate<class_1799> getFilterTest(Predicate<class_1799> customFilter) {
        Predicate<class_1799> test = customFilter;
        FilteringBehaviour filter = this.tileEntity.getBehaviour(FilteringBehaviour.TYPE);
        if (filter != null) {
            test = customFilter.and(filter::test);
        }
        return test;
    }

    @Override
    public BehaviourType<?> getType() {
        return this.behaviourType;
    }

    public static class UnsidedItemStorageProvider
    extends CapManipulationBehaviourBase.UnsidedStorageProvider<ItemVariant> {
        protected UnsidedItemStorageProvider(class_1937 level, class_2338 pos) {
            super(ItemStorage.SIDED, level, pos);
        }

        @Override
        @Nullable
        public Storage<ItemVariant> get() {
            return TransferUtil.getItemStorage((class_1937)this.level, (class_2338)this.pos);
        }
    }
}

