/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue;

import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueUpdatePacket;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.pepperbell.simplenetworking.C2SPacket;
import net.minecraft.class_1657;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class ScrollValueBehaviour
extends TileEntityBehaviour {
    public static final BehaviourType<ScrollValueBehaviour> TYPE = new BehaviourType();
    ValueBoxTransform slotPositioning;
    class_243 textShift;
    int min = 0;
    int max = 1;
    public int value;
    public int scrollableValue;
    int ticksUntilScrollPacket;
    boolean forceClientState;
    class_2561 label;
    Consumer<Integer> callback;
    Consumer<Integer> clientCallback;
    Function<Integer, String> formatter;
    Function<Integer, class_2561> unit;
    Function<StepContext, Integer> step;
    private Supplier<Boolean> isActive;
    private Predicate<class_1657> canInteract;
    boolean needsWrench;

    public ScrollValueBehaviour(class_2561 label, SmartTileEntity te, ValueBoxTransform slot) {
        super(te);
        this.setLabel(label);
        this.slotPositioning = slot;
        this.callback = i -> {};
        this.clientCallback = i -> {};
        this.textShift = class_243.field_1353;
        this.formatter = i -> Integer.toString(i);
        this.step = c -> 1;
        this.value = 0;
        this.isActive = () -> true;
        this.ticksUntilScrollPacket = -1;
        this.canInteract = FilteringBehaviour::playerCanInteract;
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(class_2487 nbt, boolean clientPacket) {
        nbt.method_10569("ScrollValue", this.value);
        if (clientPacket && this.forceClientState) {
            nbt.method_10556("ForceScrollable", true);
            this.forceClientState = false;
        }
        super.write(nbt, clientPacket);
    }

    @Override
    public void read(class_2487 nbt, boolean clientPacket) {
        this.value = nbt.method_10550("ScrollValue");
        if (nbt.method_10545("ForceScrollable")) {
            this.ticksUntilScrollPacket = -1;
            this.scrollableValue = this.value;
        }
        super.read(nbt, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.getWorld().field_9236) {
            return;
        }
        if (this.ticksUntilScrollPacket == -1) {
            return;
        }
        if (this.ticksUntilScrollPacket > 0) {
            --this.ticksUntilScrollPacket;
            return;
        }
        AllPackets.channel.sendToServer((C2SPacket)new ScrollValueUpdatePacket(this.getPos(), this.scrollableValue));
        this.ticksUntilScrollPacket = -1;
    }

    public ScrollValueBehaviour withClientCallback(Consumer<Integer> valueCallback) {
        this.clientCallback = valueCallback;
        return this;
    }

    public ScrollValueBehaviour withCallback(Consumer<Integer> valueCallback) {
        this.callback = valueCallback;
        return this;
    }

    public ScrollValueBehaviour between(int min, int max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public ScrollValueBehaviour moveText(class_243 shift) {
        this.textShift = shift;
        return this;
    }

    public ScrollValueBehaviour requiresWrench() {
        this.needsWrench = true;
        return this;
    }

    public ScrollValueBehaviour withFormatter(Function<Integer, String> formatter) {
        this.formatter = formatter;
        return this;
    }

    public ScrollValueBehaviour withUnit(Function<Integer, class_2561> unit) {
        this.unit = unit;
        return this;
    }

    public ScrollValueBehaviour onlyActiveWhen(Supplier<Boolean> condition) {
        this.isActive = condition;
        return this;
    }

    public ScrollValueBehaviour interactiveWhen(Predicate<class_1657> condition) {
        this.canInteract = condition;
        return this;
    }

    public ScrollValueBehaviour withStepFunction(Function<StepContext, Integer> step) {
        this.step = step;
        return this;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.setValue(this.value);
        this.scrollableValue = this.value;
    }

    public void setValue(int value) {
        if ((value = class_3532.method_15340((int)value, (int)this.min, (int)this.max)) == this.value) {
            return;
        }
        this.value = value;
        this.forceClientState = true;
        this.callback.accept(value);
        this.tileEntity.method_5431();
        this.tileEntity.sendData();
        this.scrollableValue = value;
    }

    public int getValue() {
        return this.value;
    }

    public String formatValue() {
        return this.formatter.apply(this.scrollableValue);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public boolean isActive() {
        return this.isActive.get();
    }

    public boolean canInteract(class_1657 player) {
        return this.canInteract.test(player);
    }

    public boolean testHit(class_243 hit) {
        class_2680 state = this.tileEntity.method_11010();
        class_243 localHit = hit.method_1020(class_243.method_24954((class_2382)this.tileEntity.method_11016()));
        return this.slotPositioning.testHit(state, localHit);
    }

    public void setLabel(class_2561 label) {
        this.label = label;
    }

    public static class StepContext {
        public int currentValue;
        public boolean forward;
        public boolean shift;
        public boolean control;
    }
}

