/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2636;
import net.minecraft.class_5250;

public final class NBTProcessors {
    private static final Map<class_2591<?>, UnaryOperator<class_2487>> processors = new HashMap();
    private static final Map<class_2591<?>, UnaryOperator<class_2487>> survivalProcessors = new HashMap();

    public static synchronized void addProcessor(class_2591<?> type, UnaryOperator<class_2487> processor) {
        processors.put(type, processor);
    }

    public static synchronized void addSurvivalProcessor(class_2591<?> type, UnaryOperator<class_2487> processor) {
        survivalProcessors.put(type, processor);
    }

    public static boolean textComponentHasClickEvent(String json) {
        class_5250 component = class_2561.class_2562.method_10877((String)(json.isEmpty() ? "\"\"" : json));
        return component != null && component.method_10866() != null && component.method_10866().method_10970() != null;
    }

    private NBTProcessors() {
    }

    @Nullable
    public static class_2487 process(class_2586 tileEntity, class_2487 compound, boolean survival) {
        if (compound == null) {
            return null;
        }
        class_2591 type = tileEntity.method_11017();
        if (survival && survivalProcessors.containsKey(type)) {
            compound = (class_2487)survivalProcessors.get(type).apply(compound);
        }
        if (compound != null && processors.containsKey(type)) {
            return (class_2487)processors.get(type).apply(compound);
        }
        if (tileEntity instanceof class_2636) {
            return compound;
        }
        if (tileEntity.method_11011()) {
            return null;
        }
        return compound;
    }

    static {
        NBTProcessors.addProcessor(class_2591.field_11911, data -> {
            for (int i = 0; i < 4; ++i) {
                if (!NBTProcessors.textComponentHasClickEvent(data.method_10558("Text" + (i + 1)))) continue;
                return null;
            }
            return data;
        });
        NBTProcessors.addProcessor(class_2591.field_16412, data -> {
            if (!data.method_10573("Book", 10)) {
                return data;
            }
            class_2487 book = data.method_10562("Book");
            if (!book.method_10573("tag", 10)) {
                return data;
            }
            class_2487 tag = book.method_10562("tag");
            if (!tag.method_10573("pages", 9)) {
                return data;
            }
            class_2499 pages = tag.method_10554("pages", 8);
            for (class_2520 inbt : pages) {
                if (!NBTProcessors.textComponentHasClickEvent(inbt.method_10714())) continue;
                return null;
            }
            return data;
        });
    }
}

