/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.worldgen;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.simibubi.create.foundation.config.ConfigBase;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.worldgen.AllFeatures;
import com.simibubi.create.foundation.worldgen.ConfigDrivenLayeredOreFeatureConfiguration;
import com.simibubi.create.foundation.worldgen.ConfigDrivenOreFeatureConfiguration;
import com.simibubi.create.foundation.worldgen.ConfigDrivenPlacement;
import com.simibubi.create.foundation.worldgen.LayerPattern;
import com.simibubi.create.foundation.worldgen.LayeredOreFeature;
import com.simibubi.create.foundation.worldgen.StandardOreFeature;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3124;
import net.minecraft.class_3825;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6796;
import net.minecraft.class_6806;
import net.minecraft.class_6880;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.Nullable;

public class OreFeatureConfigEntry
extends ConfigBase {
    public static final Map<class_2960, OreFeatureConfigEntry> ALL = new HashMap<class_2960, OreFeatureConfigEntry>();
    public static final Codec<OreFeatureConfigEntry> CODEC = class_2960.field_25139.comapFlatMap(OreFeatureConfigEntry::read, entry -> entry.id);
    public final class_2960 id;
    public final ConfigBase.ConfigInt clusterSize;
    public final ConfigBase.ConfigFloat frequency;
    public final ConfigBase.ConfigInt minHeight;
    public final ConfigBase.ConfigInt maxHeight;
    private BiomeExtension biomeExt;
    private DatagenExtension datagenExt;

    public OreFeatureConfigEntry(class_2960 id, int clusterSize, float frequency, int minHeight, int maxHeight) {
        this.id = id;
        this.clusterSize = this.i(clusterSize, 0, "clusterSize", new String[0]);
        this.frequency = this.f(frequency, 0.0f, 512.0f, "frequency", "Amount of clusters generated per Chunk.", "  >1 to spawn multiple.", "  <1 to make it a chance.", "  0 to disable.");
        this.minHeight = this.i(minHeight, "minHeight", new String[0]);
        this.maxHeight = this.i(maxHeight, "maxHeight", new String[0]);
        ALL.put(id, this);
    }

    public BiomeExtension biomeExt() {
        if (this.biomeExt == null) {
            this.biomeExt = new BiomeExtension();
        }
        return this.biomeExt;
    }

    @Nullable
    public StandardDatagenExtension standardDatagenExt() {
        DatagenExtension datagenExtension;
        if (this.datagenExt == null) {
            this.datagenExt = new StandardDatagenExtension();
        }
        if ((datagenExtension = this.datagenExt) instanceof StandardDatagenExtension) {
            StandardDatagenExtension standard = (StandardDatagenExtension)datagenExtension;
            return standard;
        }
        return null;
    }

    @Nullable
    public LayeredDatagenExtension layeredDatagenExt() {
        DatagenExtension datagenExtension;
        if (this.datagenExt == null) {
            this.datagenExt = new LayeredDatagenExtension();
        }
        if ((datagenExtension = this.datagenExt) instanceof LayeredDatagenExtension) {
            LayeredDatagenExtension layered = (LayeredDatagenExtension)datagenExtension;
            return layered;
        }
        return null;
    }

    @Nullable
    public DatagenExtension datagenExt() {
        if (this.datagenExt != null) {
            return this.datagenExt;
        }
        return null;
    }

    public void addToConfig(ForgeConfigSpec.Builder builder) {
        this.registerAll(builder);
    }

    @Override
    public String getName() {
        return this.id.method_12832();
    }

    public static DataResult<OreFeatureConfigEntry> read(class_2960 id) {
        OreFeatureConfigEntry entry = ALL.get(id);
        if (entry != null) {
            return DataResult.success((Object)entry);
        }
        return DataResult.error((String)("Not a valid OreFeatureConfigEntry: " + id));
    }

    public class BiomeExtension {
        public class_2960 placedFeatureLocation;
        public Predicate<BiomeSelectionContext> biomePredicate;

        public BiomeExtension() {
            this.placedFeatureLocation = OreFeatureConfigEntry.this.id;
            this.biomePredicate = e -> false;
        }

        public BiomeExtension feature(class_2960 placedFeature) {
            this.placedFeatureLocation = placedFeature;
            return this;
        }

        public BiomeExtension predicate(Predicate<BiomeSelectionContext> predicate) {
            this.biomePredicate = predicate;
            return this;
        }

        public void modifyBiomes(class_2378<class_6796> registry) {
            class_5321 key = class_5321.method_29179((class_5321)class_2378.field_35758, (class_2960)this.placedFeatureLocation);
            Optional optionalFeature = registry.method_40264(key);
            if (optionalFeature.isPresent()) {
                BiomeModifications.addFeature(this.biomePredicate, (class_2893.class_2895)class_2893.class_2895.field_13176, (class_5321)key);
            }
        }

        public OreFeatureConfigEntry parent() {
            return OreFeatureConfigEntry.this;
        }
    }

    public abstract class DatagenExtension {
        public abstract class_2975<?, ?> createConfiguredFeature(class_5455 var1);

        public class_6796 createPlacedFeature(class_5455 registryAccess) {
            class_2378 featureRegistry = registryAccess.method_30530(class_2378.field_25914);
            class_6880 featureHolder = featureRegistry.method_40268(class_5321.method_29179((class_5321)class_2378.field_25914, (class_2960)OreFeatureConfigEntry.this.id));
            return new class_6796(featureHolder, List.of(new ConfigDrivenPlacement(OreFeatureConfigEntry.this)));
        }

        public OreFeatureConfigEntry parent() {
            return OreFeatureConfigEntry.this;
        }
    }

    public class StandardDatagenExtension
    extends DatagenExtension {
        public NonNullSupplier<? extends class_2248> block;
        public NonNullSupplier<? extends class_2248> deepBlock;
        public NonNullSupplier<? extends class_2248> netherBlock;

        public StandardDatagenExtension withBlock(NonNullSupplier<? extends class_2248> block) {
            this.block = block;
            this.deepBlock = block;
            return this;
        }

        public StandardDatagenExtension withBlocks(Couple<NonNullSupplier<? extends class_2248>> blocks) {
            this.block = (NonNullSupplier)blocks.getFirst();
            this.deepBlock = (NonNullSupplier)blocks.getSecond();
            return this;
        }

        public StandardDatagenExtension withNetherBlock(NonNullSupplier<? extends class_2248> block) {
            this.netherBlock = block;
            return this;
        }

        @Override
        public class_2975<?, ?> createConfiguredFeature(class_5455 registryAccess) {
            ArrayList<class_3124.class_5876> targetStates = new ArrayList<class_3124.class_5876>();
            if (this.block != null) {
                targetStates.add(class_3124.method_33994((class_3825)class_6806.field_35858, (class_2680)((class_2248)this.block.get()).method_9564()));
            }
            if (this.deepBlock != null) {
                targetStates.add(class_3124.method_33994((class_3825)class_6806.field_35859, (class_2680)((class_2248)this.deepBlock.get()).method_9564()));
            }
            if (this.netherBlock != null) {
                targetStates.add(class_3124.method_33994((class_3825)class_6806.field_35861, (class_2680)((class_2248)this.netherBlock.get()).method_9564()));
            }
            ConfigDrivenOreFeatureConfiguration config = new ConfigDrivenOreFeatureConfiguration(OreFeatureConfigEntry.this, 0.0f, targetStates);
            return new class_2975((class_3031)((StandardOreFeature)((Object)AllFeatures.STANDARD_ORE.get())), (class_3037)config);
        }
    }

    public class LayeredDatagenExtension
    extends DatagenExtension {
        public final List<NonNullSupplier<LayerPattern>> layerPatterns = new ArrayList<NonNullSupplier<LayerPattern>>();

        public LayeredDatagenExtension withLayerPattern(NonNullSupplier<LayerPattern> pattern) {
            this.layerPatterns.add(pattern);
            return this;
        }

        @Override
        public class_2975<?, ?> createConfiguredFeature(class_5455 registryAccess) {
            List<LayerPattern> layerPatterns = this.layerPatterns.stream().map(Supplier::get).toList();
            ConfigDrivenLayeredOreFeatureConfiguration config = new ConfigDrivenLayeredOreFeatureConfiguration(OreFeatureConfigEntry.this, 0.0f, layerPatterns);
            return new class_2975((class_3031)((LayeredOreFeature)((Object)AllFeatures.LAYERED_ORE.get())), (class_3037)config);
        }
    }
}

