/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import de.keksuccino.konkrete.Konkrete;
import de.keksuccino.konkrete.command.ClientCommandSourceStack;
import de.keksuccino.konkrete.command.ClientExecutor;
import de.keksuccino.konkrete.events.SubscribeEvent;
import de.keksuccino.konkrete.events.client.ClientCommandRegistrationEvent;
import de.keksuccino.konkrete.events.client.ClientPlayerLoginEvent;
import de.keksuccino.konkrete.mixin.mixins.client.IMixinClientPacketListener;
import de.keksuccino.konkrete.mixin.mixins.client.IMixinLocalPlayer;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_2164;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2321;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientCommandHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"konkrete/ClientCommandHandler");
    private static CommandDispatcher<class_2168> dispatcher;

    public static void init() {
        Konkrete.getEventHandler().registerEventsFrom(new ClientCommandHandler());
        ClientExecutor.init();
    }

    @SubscribeEvent
    public void onPlayerLogin(ClientPlayerLoginEvent e) {
        CommandDispatcher<class_2172> d = ClientCommandHandler.mergeWithServerCommands((CommandDispatcher<class_2172>)new CommandDispatcher());
        class_2547 class_25472 = e.connection.method_10744();
        if (class_25472 instanceof class_634) {
            class_634 listener = (class_634)class_25472;
            ((IMixinClientPacketListener)listener).setCommandsKonkrete(d);
        }
    }

    public static CommandDispatcher<class_2172> mergeWithServerCommands(CommandDispatcher<class_2172> serverCommands) {
        CommandDispatcher commandsTemp = new CommandDispatcher();
        Konkrete.getEventHandler().callEventsFor(new ClientCommandRegistrationEvent((CommandDispatcher<class_2168>)commandsTemp));
        dispatcher = new CommandDispatcher();
        ClientCommandHandler.copy(commandsTemp.getRoot(), dispatcher.getRoot());
        RootCommandNode serverCommandsRoot = serverCommands.getRoot();
        CommandDispatcher newServerCommands = new CommandDispatcher();
        ClientCommandHandler.copy(serverCommandsRoot, newServerCommands.getRoot());
        ClientCommandHandler.mergeCommandNode(dispatcher.getRoot(), newServerCommands.getRoot(), new IdentityHashMap(), ClientCommandHandler.getSource(), context -> 0, suggestions -> {
            SuggestionProvider suggestionProvider = class_2321.method_10026((SuggestionProvider)suggestions);
            if (suggestionProvider == class_2321.field_10933) {
                suggestionProvider = (context, builder) -> {
                    ClientCommandSourceStack source = ClientCommandHandler.getSource();
                    StringReader reader = new StringReader(context.getInput());
                    if (reader.canRead() && reader.peek() == '/') {
                        reader.skip();
                    }
                    ParseResults parse = dispatcher.parse(reader, (Object)source);
                    return dispatcher.getCompletionSuggestions(parse);
                };
            }
            return suggestionProvider;
        });
        return newServerCommands;
    }

    private static <S, T> void mergeCommandNode(CommandNode<S> sourceNode, CommandNode<T> resultNode, Map<CommandNode<S>, CommandNode<T>> sourceToResult, S canUse, Command<T> execute, Function<SuggestionProvider<S>, SuggestionProvider<T>> sourceToResultSuggestion) {
        sourceToResult.put(sourceNode, resultNode);
        for (CommandNode sourceChild : sourceNode.getChildren()) {
            if (!sourceChild.canUse(canUse)) continue;
            resultNode.addChild(ClientCommandHandler.toResult(sourceChild, sourceToResult, canUse, execute, sourceToResultSuggestion));
        }
    }

    private static <S, T> CommandNode<T> toResult(CommandNode<S> sourceNode, Map<CommandNode<S>, CommandNode<T>> sourceToResult, S canUse, Command<T> execute, Function<SuggestionProvider<S>, SuggestionProvider<T>> sourceToResultSuggestion) {
        LiteralArgumentBuilder resultBuilder;
        if (sourceToResult.containsKey(sourceNode)) {
            return sourceToResult.get(sourceNode);
        }
        if (sourceNode instanceof ArgumentCommandNode) {
            ArgumentCommandNode sourceArgument = (ArgumentCommandNode)sourceNode;
            RequiredArgumentBuilder resultArgumentBuilder = RequiredArgumentBuilder.argument((String)sourceArgument.getName(), (ArgumentType)sourceArgument.getType());
            if (sourceArgument.getCustomSuggestions() != null) {
                resultArgumentBuilder.suggests(sourceToResultSuggestion.apply(sourceArgument.getCustomSuggestions()));
            }
            resultBuilder = resultArgumentBuilder;
        } else if (sourceNode instanceof LiteralCommandNode) {
            LiteralCommandNode sourceLiteral = (LiteralCommandNode)sourceNode;
            resultBuilder = LiteralArgumentBuilder.literal((String)sourceLiteral.getLiteral());
        } else {
            if (sourceNode instanceof RootCommandNode) {
                RootCommandNode resultNode = new RootCommandNode();
                ClientCommandHandler.mergeCommandNode(sourceNode, resultNode, sourceToResult, canUse, execute, sourceToResultSuggestion);
                return resultNode;
            }
            throw new IllegalStateException("Node type " + sourceNode + " is not a standard node type");
        }
        if (sourceNode.getCommand() != null) {
            resultBuilder.executes(execute);
        }
        if (sourceNode.getRedirect() != null) {
            resultBuilder.redirect(ClientCommandHandler.toResult(sourceNode.getRedirect(), sourceToResult, canUse, execute, sourceToResultSuggestion));
        }
        CommandNode resultNode = resultBuilder.build();
        ClientCommandHandler.mergeCommandNode(sourceNode, resultNode, sourceToResult, canUse, execute, sourceToResultSuggestion);
        return resultNode;
    }

    public static CommandDispatcher<class_2168> getDispatcher() {
        return dispatcher;
    }

    public static ClientCommandSourceStack getSource() {
        class_746 player = class_310.method_1551().field_1724;
        return new ClientCommandSourceStack((class_2165)player, player.method_19538(), player.method_5802(), ((IMixinLocalPlayer)player).getPermissionLevelKonkrete(), player.method_5477().getString(), player.method_5476(), (class_1297)player);
    }

    private static <S> void copy(CommandNode<S> sourceNode, CommandNode<S> resultNode) {
        IdentityHashMap<Object, Object> newNodes = new IdentityHashMap<Object, Object>();
        newNodes.put(sourceNode, resultNode);
        for (CommandNode child : sourceNode.getChildren()) {
            CommandNode copy = newNodes.computeIfAbsent(child, innerChild -> {
                ArgumentBuilder builder = innerChild.createBuilder();
                CommandNode innerCopy = builder.build();
                ClientCommandHandler.copy(innerChild, innerCopy);
                return innerCopy;
            });
            resultNode.addChild(copy);
        }
    }

    public static boolean executeClientCommand(String command) {
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        StringReader reader = new StringReader(command);
        ClientCommandSourceStack source = ClientCommandHandler.getSource();
        try {
            dispatcher.execute(reader, (Object)source);
        }
        catch (class_2164 ex) {
            class_310.method_1551().field_1724.method_9203((class_2561)new class_2585("").method_10852(ex.method_9199()).method_27692(class_124.field_1061), class_156.field_25140);
        }
        catch (CommandSyntaxException ex) {
            if (ex.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand() || ex.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument()) {
                return false;
            }
            class_310.method_1551().field_1724.method_9203((class_2561)new class_2585("").method_10852(class_2564.method_10883((Message)ex.getRawMessage())).method_27692(class_124.field_1061), class_156.field_25140);
        }
        catch (Exception ex) {
            class_310.method_1551().field_1724.method_9203((class_2561)new class_2588("command.failed").method_27692(class_124.field_1061), class_156.field_25140);
            LOGGER.error("Error while trying to execute client-only command '" + command + "'!");
        }
        return true;
    }
}

