/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.sniffer.setup.config;

import com.minecraftserverzone.sniffer.setup.config.ModConfigProvider;
import com.minecraftserverzone.sniffer.setup.config.SimpleConfig;
import com.mojang.datafixers.util.Pair;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfigs {
    public static SimpleConfig CONFIG;
    private static ModConfigProvider configs;
    public static int WEIGHT;
    public static int MIN;
    public static int MAX;
    public static String BIOMES;

    public static void changeConfig() throws IOException {
        try {
            Path path = FabricLoader.getInstance().getConfigDir();
            String filename = "sniffer.properties";
            FileWriter fw = new FileWriter(String.valueOf(path + "\\" + filename), false);
            PrintWriter pw = new PrintWriter((Writer)fw, Boolean.parseBoolean("UTF-8"));
            pw.println("sniffer.weight=" + WEIGHT + " #int | default: 10");
            pw.println("sniffer.min=" + MIN + " #int | default: 0");
            pw.println("sniffer.max=" + MAX + " #int | default: 0");
            pw.println("sniffer.biomes=" + BIOMES + " #String | default: meadow,sunflower_plains");
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void registerConfigs() {
        configs = new ModConfigProvider();
        ModConfigs.createConfigs();
        CONFIG = SimpleConfig.of("snifferconfig").provider(configs).request();
        ModConfigs.assignConfigs();
    }

    private static void createConfigs() {
        configs.addKeyValuePair(new Pair((Object)"sniffer.weight", (Object)10), "int");
        configs.addKeyValuePair(new Pair((Object)"sniffer.min", (Object)0), "int");
        configs.addKeyValuePair(new Pair((Object)"sniffer.max", (Object)0), "int");
        configs.addKeyValuePair(new Pair((Object)"sniffer.biomes", (Object)"meadow,sunflower_plains"), "String");
    }

    private static void assignConfigs() {
        WEIGHT = CONFIG.getOrDefault("sniffer.weight", 10);
        MIN = CONFIG.getOrDefault("sniffer.min", 0);
        MAX = CONFIG.getOrDefault("sniffer.max", 0);
        BIOMES = CONFIG.getOrDefault("sniffer.biomes", "meadow,sunflower_plains");
        System.out.println("All " + configs.getConfigsList().size() + " have been set properly");
    }

    static {
        BIOMES = "meadow,sunflower_plains";
    }
}

