/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.ears.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;

public final class Slice {
    public static final Slice EMPTY = new Slice(new byte[0]);
    private final byte[] arr;
    private final int ofs;
    private final int len;

    public Slice(byte[] arr) {
        this(arr, 0, arr.length);
    }

    public Slice(byte[] arr, int ofs, int len) {
        if (ofs < 0) {
            throw new IllegalArgumentException("offset cannot be negative");
        }
        if (ofs > arr.length) {
            throw new IllegalArgumentException("offset cannot be > length");
        }
        if (ofs + len > arr.length) {
            throw new IllegalArgumentException("slice cannot extend past the end of the array");
        }
        this.arr = arr;
        this.ofs = ofs;
        this.len = len;
    }

    public byte get(int idx) {
        if (idx >= this.len) {
            throw new IndexOutOfBoundsException(idx + " >= " + this.len);
        }
        return this.arr[this.ofs + idx];
    }

    public int size() {
        return this.len;
    }

    public Slice slice(int offset, int length) {
        return new Slice(this.arr, this.ofs + offset, length);
    }

    public Slice slice(int offset) {
        return new Slice(this.arr, this.ofs + offset, this.arr.length - (this.ofs + offset));
    }

    public byte[] toByteArray() {
        return Slice.of(this.arr, this.ofs, this.len);
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.arr, this.ofs, this.len);
    }

    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.len; ++i) {
            hashCode = 31 * hashCode + this.get(i);
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Slice other = (Slice)obj;
        if (this.len != other.len) {
            return false;
        }
        for (int i = 0; i < this.len; ++i) {
            if (this.get(i) == other.get(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(byte[] bys) {
        return this.equals(bys, 0, bys.length);
    }

    public boolean equals(byte[] bys, int ofs, int len) {
        if (ofs < 0 || len < 0 || ofs + len > bys.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len != this.len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.get(i) == bys[ofs + i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder val = new StringBuilder();
        StringBuilder asc = new StringBuilder();
        for (int i = 0; i < this.len; ++i) {
            int v = this.get(i) & 0xFF;
            val.append(Integer.toHexString(v | 0xF00).substring(1).toUpperCase(Locale.ROOT));
            val.append(" ");
            asc.append(v < 32 || v > 127 ? (char)'.' : (char)v);
        }
        val.setLength(val.length() - 1);
        return "Slice[" + this.len + " bytes; " + val + " | " + asc + "]";
    }

    public static byte[] of(byte[] arr, int ofs, int len) {
        byte[] dst = new byte[len];
        System.arraycopy(arr, ofs, dst, 0, len);
        return dst;
    }

    public static Slice parse(String str) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean inGroup = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (inGroup) {
                if (c == ']') {
                    inGroup = false;
                    continue;
                }
                baos.write(c & 0xFF);
                continue;
            }
            if (c == '[') {
                inGroup = true;
                continue;
            }
            char other = str.charAt(i + 1);
            int lhs = Character.digit(c, 16);
            int rhs = Character.digit(other, 16);
            int value = lhs << 4 | rhs;
            baos.write(value);
            ++i;
        }
        return new Slice(baos.toByteArray());
    }
}

