/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.ears.common;

import com.unascribed.ears.EarsFeaturesLookup;
import com.unascribed.ears.api.features.EarsFeatures;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class SimpleEarsFeatureStorage
implements EarsFeaturesLookup {
    private final Map<UUID, EarsFeatures> byId = new ConcurrentHashMap<UUID, EarsFeatures>();
    private final Map<String, EarsFeatures> byName = new ConcurrentHashMap<String, EarsFeatures>();

    public void put(String username, UUID id, EarsFeatures features) {
        if (id != null && this.byId.get(id) != features) {
            this.byId.put(id, features);
        }
        if (username != null && this.byName.get(username) != features) {
            this.byName.put(username, features);
        }
    }

    @Override
    public EarsFeatures getById(UUID id) {
        EarsFeatures feat = this.byId.get(id);
        if (feat == null) {
            return EarsFeatures.DISABLED;
        }
        return feat;
    }

    @Override
    public EarsFeatures getByUsername(String username) {
        EarsFeatures feat = this.byName.get(username);
        if (feat == null) {
            return EarsFeatures.DISABLED;
        }
        return feat;
    }
}

