/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.block;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;
import satisfyu.vinery.item.GrapeBushSeedItem;
import satisfyu.vinery.registry.ObjectRegistry;
import satisfyu.vinery.util.GrapevineType;

public class GrapevineStemBlock
extends class_2248
implements class_3737,
class_2256 {
    private static final class_265 SHAPE = class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final int MAX_AGE = 4;
    private static final class_2758 AGE = class_2758.method_11867((String)"age", (int)0, (int)4);
    private static final class_2754<GrapevineType> TYPE = class_2754.method_11850((String)"type", GrapevineType.class);
    private static final class_2746 HAS_GROWTH_LEAVES = class_2746.method_11825((String)"has_growth_leaves");

    public GrapevineStemBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0))).method_11657((class_2769)HAS_GROWTH_LEAVES, (Comparable)Boolean.valueOf(false)));
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        int age = (Integer)state.method_11654((class_2769)AGE);
        if (this.hasTrunk(world, pos)) {
            class_1799 stack = player.method_5998(hand);
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof GrapeBushSeedItem) {
                GrapeBushSeedItem seed = (GrapeBushSeedItem)class_17922;
                if (age == 0) {
                    if (!player.method_7337()) {
                        stack.method_7934(1);
                    }
                    world.method_8652(pos, this.withAge(age + 1, seed.getType() == GrapevineType.RED ? GrapevineType.RED : GrapevineType.WHITE), 3);
                    world.method_8396(player, pos, class_3417.field_17616, class_3419.field_15256, 1.0f, 1.0f);
                    return class_1269.field_5812;
                }
            } else {
                if (!stack.method_31574(class_1802.field_8324) && age > 2) {
                    this.dropGrapes(world, state, pos);
                    return class_1269.method_29236((boolean)world.field_9236);
                }
                return class_1269.field_5811;
            }
        }
        return class_1269.field_5811;
    }

    private void dropGrapes(class_1937 world, class_2680 state, class_2338 pos) {
        int x = 1 + world.field_9229.nextInt(this.isMature(state) ? 2 : 1);
        int bonus = this.isMature(state) ? 2 : 1;
        GrapevineStemBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)(state.method_11654(TYPE) == GrapevineType.RED ? ObjectRegistry.RED_GRAPE : ObjectRegistry.WHITE_GRAPE), x + bonus));
        world.method_8396(null, pos, class_3417.field_17617, class_3419.field_15245, 1.0f, 0.8f + world.field_9229.nextFloat() * 0.4f);
        world.method_8652(pos, (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(2)), 2);
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, Random random) {
        int i;
        if (!this.isMature(state) && this.hasTrunk((class_1937)world, pos) && (Integer)state.method_11654((class_2769)AGE) > 0 && world.method_22335(pos, 0) >= 9 && (i = ((Integer)state.method_11654((class_2769)AGE)).intValue()) < 4) {
            world.method_8652(pos, this.withAge(i + 1, (GrapevineType)((Object)state.method_11654(TYPE))), 2);
        }
        if (this.hasGrowthLeaves(state)) {
            return;
        }
        if (this.hasTrunk((class_1937)world, pos) && (Integer)state.method_11654((class_2769)AGE) > 2) {
            class_2338 belowPos = pos.method_10074();
            int count = class_3532.method_15395((Random)world.field_9229, (int)1, (int)4);
            for (int i2 = 0; i2 < count; ++i2) {
                class_2338 offset;
                int dirId = class_3532.method_15395((Random)world.field_9229, (int)3, (int)5);
                class_2350 dir = class_2350.method_10143((int)dirId);
                if (dir == class_2350.field_11033 || dir == class_2350.field_11036 || !world.method_8320(offset = belowPos.method_10093(dir)).method_26215()) continue;
                world.method_8652(offset, (class_2680)ObjectRegistry.GRAPEVINE_LEAVES.method_9564().method_11657((class_2769)class_2741.field_12514, (Comparable)Boolean.valueOf(true)), 2);
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)HAS_GROWTH_LEAVES, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    public boolean hasGrowthLeaves(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)HAS_GROWTH_LEAVES);
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2338 abovePos;
        class_2680 aboveState;
        if ((Integer)state.method_11654((class_2769)AGE) > 2) {
            this.dropGrapes(world, state, pos);
        }
        if ((aboveState = world.method_8320(abovePos = pos.method_10084())).method_26204() == this) {
            if ((Integer)aboveState.method_11654((class_2769)AGE) > 2) {
                this.dropGrapes(world, aboveState, pos);
            }
            world.method_8650(abovePos, false);
            world.method_8649((class_1297)new class_1542(world, (double)pos.method_10263(), (double)abovePos.method_10264(), (double)pos.method_10260(), new class_1799((class_1935)this)));
        }
        super.method_9576(world, pos, state, player);
    }

    public boolean hasTrunk(class_1937 world, class_2338 pos) {
        return world.method_8320(pos.method_10074()).method_26204() == this;
    }

    private void boneMealGrow(class_1937 world, class_2680 state, class_2338 pos) {
        int age = (Integer)state.method_11654((class_2769)AGE) + class_3532.method_15395((Random)world.method_8409(), (int)1, (int)2);
        int j = 4;
        if (age > 4) {
            age = j;
        }
        world.method_8652(pos, this.withAge(age, (GrapevineType)((Object)state.method_11654(TYPE))), 2);
    }

    public class_2680 withAge(int age, GrapevineType type) {
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)AGE, (Comparable)Integer.valueOf(age))).method_11657(TYPE, (Comparable)((Object)type));
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)((class_2680)((class_2680)Objects.requireNonNull(super.method_9605(ctx)).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(ctx.method_8045().method_8316(ctx.method_8037()).method_15772() == class_3612.field_15910))).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0))).method_11657((class_2769)HAS_GROWTH_LEAVES, (Comparable)Boolean.valueOf(false));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED, AGE, TYPE, HAS_GROWTH_LEAVES});
    }

    public boolean isMature(class_2680 state) {
        return (Integer)state.method_11654((class_2769)AGE) >= 4;
    }

    public boolean method_9651(class_1922 world, class_2338 pos, class_2680 state, boolean isClient) {
        return !this.isMature(state) && world.method_8320(pos.method_10074()).method_26204() == this && (Integer)state.method_11654((class_2769)AGE) > 0;
    }

    public boolean method_9650(class_1937 world, Random random, class_2338 pos, class_2680 state) {
        return true;
    }

    public void method_9652(class_3218 world, Random random, class_2338 pos, class_2680 state) {
        this.boneMealGrow((class_1937)world, state, pos);
    }

    public void method_9568(class_1799 itemStack, class_1922 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        tooltip.add((class_2561)new class_2588("block.vinery.stem.tooltip").method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}));
    }
}

