/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.block.entity;

import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_5558;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.jetbrains.annotations.Nullable;
import satisfyu.vinery.block.CookingPotBlock;
import satisfyu.vinery.client.gui.handler.CookingPotGuiHandler;
import satisfyu.vinery.recipe.CookingPotRecipe;
import satisfyu.vinery.registry.VineryBlockEntityTypes;
import satisfyu.vinery.registry.VineryRecipeTypes;
import satisfyu.vinery.util.VineryTags;
import satisfyu.vinery.util.VineryUtils;

public class CookingPotEntity
extends class_2586
implements class_5558<CookingPotEntity>,
class_1263,
class_3908 {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)8, (Object)class_1799.field_8037);
    private static final int MAX_CAPACITY = 8;
    public static final int MAX_COOKING_TIME = 600;
    private int cookingTime;
    public static final int BOTTLE_INPUT_SLOT = 6;
    public static final int OUTPUT_SLOT = 7;
    private static final int INGREDIENTS_AREA = 6;
    private boolean isBeingBurned;
    private final class_3913 delegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> CookingPotEntity.this.cookingTime;
                case 1 -> {
                    if (CookingPotEntity.this.isBeingBurned) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    CookingPotEntity.this.cookingTime = value;
                    break;
                }
                case 1: {
                    CookingPotEntity.this.isBeingBurned = value != 0;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public CookingPotEntity(class_2338 pos, class_2680 state) {
        super(VineryBlockEntityTypes.COOKING_POT_BLOCK_ENTITY, pos, state);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.cookingTime = nbt.method_10550("CookingTime");
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("CookingTime", this.cookingTime);
    }

    public boolean isBeingBurned() {
        if (this.method_10997() == null) {
            throw new NullPointerException("Null world invoked");
        }
        class_2680 belowState = this.method_10997().method_8320(this.method_11016().method_10074());
        Optional optionalList = class_2378.field_11146.method_40266(VineryTags.ALLOWS_COOKING_ON_POT);
        class_6885.class_6888 entryList = optionalList.orElse(null);
        if (entryList == null) {
            return false;
        }
        if (!entryList.method_40241((class_6880)belowState.method_26204().method_40142())) {
            return false;
        }
        return (Boolean)belowState.method_11654((class_2769)class_2741.field_12548);
    }

    private boolean canCraft(class_1860<?> recipe) {
        if (recipe == null || recipe.method_8110().method_7960()) {
            return false;
        }
        if (recipe instanceof CookingPotRecipe) {
            CookingPotRecipe c = (CookingPotRecipe)recipe;
            if (!this.method_5438(6).method_31574(c.getContainer().method_7909())) {
                return false;
            }
            if (this.method_5438(7).method_7960()) {
                return true;
            }
            class_1799 recipeOutput = c.method_8110();
            class_1799 outputSlotStack = this.method_5438(7);
            int outputSlotCount = outputSlotStack.method_7947();
            if (!outputSlotStack.method_7962(recipeOutput)) {
                return false;
            }
            if (outputSlotCount < this.method_5444() && outputSlotCount < outputSlotStack.method_7914()) {
                return true;
            }
            return outputSlotCount < recipeOutput.method_7914();
        }
        return false;
    }

    private void craft(class_1860<?> recipe) {
        if (!this.canCraft(recipe)) {
            return;
        }
        class_1799 recipeOutput = recipe.method_8110();
        class_1799 outputSlotStack = this.method_5438(7);
        if (outputSlotStack.method_7960()) {
            this.method_5447(7, recipeOutput.method_7972());
        } else if (outputSlotStack.method_31574(recipeOutput.method_7909())) {
            outputSlotStack.method_7933(recipeOutput.method_7947());
        }
        class_2371 ingredients = recipe.method_8117();
        boolean[] slotUsed = new boolean[6];
        for (int i = 0; i < recipe.method_8117().size(); ++i) {
            class_1799 bestSlot;
            class_1856 ingredient = (class_1856)ingredients.get(i);
            if (ingredient.method_8093(bestSlot = this.method_5438(i)) && !slotUsed[i]) {
                slotUsed[i] = true;
                bestSlot.method_7934(1);
                continue;
            }
            for (int j = 0; j < 6; ++j) {
                class_1799 stack = this.method_5438(j);
                if (!ingredient.method_8093(stack) || slotUsed[j]) continue;
                slotUsed[j] = true;
                stack.method_7934(1);
            }
        }
        this.method_5438(6).method_7934(1);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, CookingPotEntity blockEntity) {
        boolean canCraft;
        if (world.method_8608()) {
            return;
        }
        this.isBeingBurned = this.isBeingBurned();
        if (!this.isBeingBurned) {
            if (((Boolean)state.method_11654((class_2769)CookingPotBlock.LIT)).booleanValue()) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)CookingPotBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
            }
            return;
        }
        class_1860 recipe = world.method_8433().method_8132(VineryRecipeTypes.COOKING_POT_RECIPE_TYPE, (class_1263)this, world).orElse(null);
        if (recipe != null || VineryUtils.isFDLoaded()) {
            // empty if block
        }
        if (canCraft = this.canCraft(recipe)) {
            ++this.cookingTime;
            if (this.cookingTime >= 600) {
                this.cookingTime = 0;
                this.craft(recipe);
            }
        } else if (!this.canCraft(recipe)) {
            this.cookingTime = 0;
        }
        if (canCraft) {
            world.method_8652(pos, (class_2680)((class_2680)this.method_11010().method_26204().method_9564().method_11657((class_2769)CookingPotBlock.COOKING, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)CookingPotBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
        } else if (((Boolean)state.method_11654((class_2769)CookingPotBlock.COOKING)).booleanValue()) {
            world.method_8652(pos, (class_2680)((class_2680)this.method_11010().method_26204().method_9564().method_11657((class_2769)CookingPotBlock.COOKING, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)CookingPotBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
        } else if ((Boolean)state.method_11654((class_2769)CookingPotBlock.LIT) != this.isBeingBurned) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)CookingPotBlock.LIT, (Comparable)Boolean.valueOf(this.isBeingBurned)), 3);
        }
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        return this.inventory.stream().allMatch(class_1799::method_7960);
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1262.method_5430(this.inventory, (int)slot, (int)amount);
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.inventory, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.method_5431();
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public class_2561 method_5476() {
        return new class_2588(this.method_11010().method_26204().method_9539());
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new CookingPotGuiHandler(syncId, inv, this, this.delegate);
    }
}

