/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.block.entity;

import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import satisfyu.vinery.client.gui.handler.FermentationBarrelGuiHandler;
import satisfyu.vinery.recipe.FermentationBarrelRecipe;
import satisfyu.vinery.registry.ObjectRegistry;
import satisfyu.vinery.registry.VineryBlockEntityTypes;
import satisfyu.vinery.registry.VineryRecipeTypes;
import satisfyu.vinery.util.WineYears;

public class FermentationBarrelBlockEntity
extends class_2586
implements class_1263,
class_5558<FermentationBarrelBlockEntity>,
class_3908 {
    private class_2371<class_1799> inventory;
    public static final int CAPACITY = 6;
    public static final int COOKING_TIME_IN_TICKS = 1800;
    private static final int BOTTLE_INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private int fermentationTime = 0;
    private int totalFermentationTime;
    private final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> FermentationBarrelBlockEntity.this.fermentationTime;
                case 1 -> FermentationBarrelBlockEntity.this.totalFermentationTime;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    FermentationBarrelBlockEntity.this.fermentationTime = value;
                    break;
                }
                case 1: {
                    FermentationBarrelBlockEntity.this.totalFermentationTime = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public FermentationBarrelBlockEntity(class_2338 pos, class_2680 state) {
        super(VineryBlockEntityTypes.FERMENTATION_BARREL_ENTITY, pos, state);
        this.inventory = class_2371.method_10213((int)6, (Object)class_1799.field_8037);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.fermentationTime = nbt.method_10568("FermentationTime");
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10575("FermentationTime", (short)this.fermentationTime);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, FermentationBarrelBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
        boolean dirty = false;
        FermentationBarrelRecipe recipeType = world.method_8433().method_8132(VineryRecipeTypes.FERMENTATION_BARREL_RECIPE_TYPE, (class_1263)blockEntity, world).orElse(null);
        if (this.canCraft(recipeType)) {
            ++this.fermentationTime;
            if (this.fermentationTime == this.totalFermentationTime) {
                this.fermentationTime = 0;
                this.craft(recipeType);
                dirty = true;
            }
        } else {
            this.fermentationTime = 0;
        }
        if (dirty) {
            this.method_5431();
        }
    }

    private boolean canCraft(FermentationBarrelRecipe recipe) {
        if (recipe == null || recipe.method_8110().method_7960()) {
            return false;
        }
        if (this.areInputsEmpty()) {
            return false;
        }
        if (this.method_5438(0).method_7960()) {
            return false;
        }
        class_2248 block = class_2248.method_9503((class_1792)this.method_5438(0).method_7909());
        if (block != ObjectRegistry.WINE_BOTTLE) {
            return false;
        }
        return this.method_5438(1).method_7960();
    }

    private boolean areInputsEmpty() {
        int emptyStacks = 0;
        for (int i = 2; i < 6; ++i) {
            if (!this.method_5438(i).method_7960()) continue;
            ++emptyStacks;
        }
        return emptyStacks == 4;
    }

    private void craft(FermentationBarrelRecipe recipe) {
        class_1799 bottle;
        if (!this.canCraft(recipe)) {
            return;
        }
        class_1799 recipeOutput = recipe.method_8110();
        class_1799 outputSlotStack = this.method_5438(1);
        if (outputSlotStack.method_7960()) {
            class_1799 output = recipeOutput.method_7972();
            WineYears.setWineYear(output, this.field_11863);
            this.method_5447(1, output);
        }
        if ((bottle = this.method_5438(0)).method_7947() > 1) {
            this.method_5434(0, 1);
        } else if (bottle.method_7947() == 1) {
            this.method_5447(0, class_1799.field_8037);
        }
        for (class_1856 entry : recipe.method_8117()) {
            if (entry.method_8093(this.method_5438(2))) {
                this.method_5434(2, 1);
            }
            if (entry.method_8093(this.method_5438(3))) {
                this.method_5434(3, 1);
            }
            if (entry.method_8093(this.method_5438(4))) {
                this.method_5434(4, 1);
            }
            if (!entry.method_8093(this.method_5438(5))) continue;
            this.method_5434(5, 1);
        }
    }

    public int method_5439() {
        return 6;
    }

    public boolean method_5442() {
        return this.inventory.stream().allMatch(class_1799::method_7960);
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1262.method_5430(this.inventory, (int)slot, (int)amount);
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.inventory, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        class_1799 stackInSlot = (class_1799)this.inventory.get(slot);
        boolean dirty = !stack.method_7960() && stack.method_7962(stackInSlot) && class_1799.method_7975((class_1799)stack, (class_1799)stackInSlot);
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        if (!(slot != 0 && slot != 2 && slot != 3 && slot != 4 && slot != 5 || dirty)) {
            this.totalFermentationTime = 50;
            this.fermentationTime = 0;
            this.method_5431();
        }
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public class_2561 method_5476() {
        return new class_2588(this.method_11010().method_26204().method_9539());
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new FermentationBarrelGuiHandler(syncId, inv, this, this.propertyDelegate);
    }
}

