/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.block.entity;

import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import satisfyu.vinery.block.WoodFiredOvenBlock;
import satisfyu.vinery.client.gui.handler.StoveGuiHandler;
import satisfyu.vinery.recipe.WoodFiredOvenRecipe;
import satisfyu.vinery.registry.VineryBlockEntityTypes;
import satisfyu.vinery.registry.VineryRecipeTypes;

public class WoodFiredOvenBlockEntity
extends class_2586
implements class_5558<WoodFiredOvenBlockEntity>,
class_1263,
class_3908 {
    private class_2371<class_1799> inventory;
    protected int burnTime;
    protected int burnTimeTotal;
    protected int cookTime;
    protected int cookTimeTotal;
    protected float experience;
    protected static final int FUEL_SLOT = 3;
    protected static final int[] INGREDIENT_SLOTS = new int[]{0, 1, 2};
    protected static final int OUTPUT_SLOT = 4;
    public static final int TOTAL_COOKING_TIME = 240;
    private final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> WoodFiredOvenBlockEntity.this.burnTime;
                case 1 -> WoodFiredOvenBlockEntity.this.burnTimeTotal;
                case 2 -> WoodFiredOvenBlockEntity.this.cookTime;
                case 3 -> WoodFiredOvenBlockEntity.this.cookTimeTotal;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    WoodFiredOvenBlockEntity.this.burnTime = value;
                    break;
                }
                case 1: {
                    WoodFiredOvenBlockEntity.this.burnTimeTotal = value;
                    break;
                }
                case 2: {
                    WoodFiredOvenBlockEntity.this.cookTime = value;
                    break;
                }
                case 3: {
                    WoodFiredOvenBlockEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int method_17389() {
            return 4;
        }
    };

    public WoodFiredOvenBlockEntity(class_2338 pos, class_2680 state) {
        super(VineryBlockEntityTypes.WOOD_FIRED_OVEN_BLOCK_ENTITY, pos, state);
        this.inventory = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
    }

    public void dropExperience(class_3218 world, class_243 pos) {
        class_1303.method_31493((class_3218)world, (class_243)pos, (int)((int)this.experience));
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.burnTime = nbt.method_10568("BurnTime");
        this.cookTime = nbt.method_10568("CookTime");
        this.cookTimeTotal = nbt.method_10568("CookTimeTotal");
        this.burnTimeTotal = this.getTotalBurnTime(this.method_5438(3));
        this.experience = nbt.method_10583("Experience");
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10575("BurnTime", (short)this.burnTime);
        nbt.method_10575("CookTime", (short)this.cookTime);
        nbt.method_10575("CookTimeTotal", (short)this.cookTimeTotal);
        nbt.method_10548("Experience", this.experience);
        class_1262.method_5426((class_2487)nbt, this.inventory);
    }

    protected boolean isBurning() {
        return this.burnTime > 0;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, WoodFiredOvenBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
        boolean initialBurningState = blockEntity.isBurning();
        boolean dirty = false;
        if (initialBurningState) {
            --this.burnTime;
        }
        WoodFiredOvenRecipe recipe = world.method_8433().method_8132(VineryRecipeTypes.WOOD_FIRED_OVEN_RECIPE_TYPE, (class_1263)this, world).orElse(null);
        if (!initialBurningState && this.canCraft(recipe)) {
            this.burnTime = this.burnTimeTotal = this.getTotalBurnTime(this.method_5438(3));
            if (this.burnTime > 0) {
                dirty = true;
                class_1799 fuelStack = this.method_5438(3);
                if (fuelStack.method_7909().method_7857()) {
                    this.method_5447(3, new class_1799((class_1935)fuelStack.method_7909().method_7858()));
                } else if (fuelStack.method_7947() > 1) {
                    this.method_5434(3, 1);
                } else if (fuelStack.method_7947() == 1) {
                    this.method_5447(3, class_1799.field_8037);
                }
            }
        }
        if (this.isBurning() && this.canCraft(recipe)) {
            ++this.cookTime;
            if (this.cookTime == this.cookTimeTotal) {
                this.cookTime = 0;
                this.craft(recipe);
                dirty = true;
            }
        } else if (!this.canCraft(recipe)) {
            this.cookTime = 0;
        }
        if (initialBurningState != this.isBurning() && (Boolean)state.method_11654((class_2769)WoodFiredOvenBlock.LIT) != this.burnTime > 0) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)WoodFiredOvenBlock.LIT, (Comparable)Boolean.valueOf(this.burnTime > 0)), 3);
            dirty = true;
        }
        if (dirty) {
            this.method_5431();
        }
    }

    protected boolean canCraft(WoodFiredOvenRecipe recipe) {
        if (recipe == null || recipe.method_8110().method_7960()) {
            return false;
        }
        if (this.method_5438(3).method_7960()) {
            return false;
        }
        if (this.method_5438(4).method_7960()) {
            return true;
        }
        class_1799 recipeOutput = recipe.method_8110();
        class_1799 outputSlotStack = this.method_5438(4);
        int outputSlotCount = outputSlotStack.method_7947();
        if (!outputSlotStack.method_7962(recipeOutput)) {
            return false;
        }
        if (outputSlotCount < this.method_5444() && outputSlotCount < outputSlotStack.method_7914()) {
            return true;
        }
        return outputSlotCount < recipeOutput.method_7914();
    }

    protected void craft(WoodFiredOvenRecipe recipe) {
        if (recipe == null || !this.canCraft(recipe)) {
            return;
        }
        class_1799 recipeOutput = recipe.method_8110();
        class_1799 outputSlotStack = this.method_5438(4);
        if (outputSlotStack.method_7960()) {
            this.method_5447(4, recipeOutput.method_7972());
        } else if (outputSlotStack.method_31574(recipeOutput.method_7909())) {
            outputSlotStack.method_7933(recipeOutput.method_7947());
        }
        class_2371<class_1856> ingredients = recipe.method_8117();
        boolean[] slotUsed = new boolean[3];
        for (int i = 0; i < recipe.method_8117().size(); ++i) {
            class_1799 bestSlot;
            class_1856 ingredient = (class_1856)ingredients.get(i);
            if (ingredient.method_8093(bestSlot = this.method_5438(i)) && !slotUsed[i]) {
                slotUsed[i] = true;
                class_1799 remainderStack = this.getRemainderItem(bestSlot);
                bestSlot.method_7934(1);
                if (remainderStack.method_7960()) continue;
                this.method_5447(i, remainderStack);
                continue;
            }
            for (int j = 0; j < 3; ++j) {
                class_1799 stack = this.method_5438(j);
                if (!ingredient.method_8093(stack) || slotUsed[j]) continue;
                slotUsed[j] = true;
                class_1799 remainderStack = this.getRemainderItem(stack);
                stack.method_7934(1);
                if (remainderStack.method_7960()) continue;
                this.method_5447(j, remainderStack);
            }
        }
        this.experience += recipe.getExperience();
    }

    protected int getTotalBurnTime(class_1799 fuel) {
        if (fuel.method_7960()) {
            return 0;
        }
        class_1792 item = fuel.method_7909();
        return class_2609.method_11196().getOrDefault(item, 0);
    }

    private class_1799 getRemainderItem(class_1799 stack) {
        if (stack.method_7909().method_7857()) {
            return new class_1799((class_1935)stack.method_7909().method_7858());
        }
        return class_1799.field_8037;
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        return this.inventory.stream().allMatch(class_1799::method_7960);
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1262.method_5430(this.inventory, (int)slot, (int)amount);
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.inventory, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        class_1799 stackInSlot = (class_1799)this.inventory.get(slot);
        boolean dirty = !stack.method_7960() && stack.method_7962(stackInSlot) && class_1799.method_7975((class_1799)stack, (class_1799)stackInSlot);
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        if (slot == INGREDIENT_SLOTS[0] || slot == INGREDIENT_SLOTS[1] || slot == INGREDIENT_SLOTS[2] && !dirty) {
            this.cookTimeTotal = 240;
            this.cookTime = 0;
            this.method_5431();
        }
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public class_2561 method_5476() {
        return new class_2588(this.method_11010().method_26204().method_9539());
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new StoveGuiHandler(syncId, inv, this, this.propertyDelegate);
    }
}

