/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.item;

import java.util.List;
import lekavar.lma.drinkbeer.DrinkBeer;
import lekavar.lma.drinkbeer.block.MixedBeerBlock;
import lekavar.lma.drinkbeer.item.BeerBlockItem;
import lekavar.lma.drinkbeer.manager.MixedBeerManager;
import lekavar.lma.drinkbeer.manager.SpiceAndFlavorManager;
import lekavar.lma.drinkbeer.util.beer.Beers;
import lekavar.lma.drinkbeer.util.mixedbeer.Flavors;
import lekavar.lma.drinkbeer.util.mixedbeer.Spices;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_4174;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class MixedBeerBlockItem
extends BeerBlockItem {
    public MixedBeerBlockItem() {
        super(DrinkBeer.MIXED_BEER, new class_1792.class_1793().method_7892(DrinkBeer.DRINK_BEER).method_7889(1).method_19265(new class_4174.class_4175().method_19240().method_19242()));
    }

    @Environment(value=EnvType.CLIENT)
    public void appendMixedBeerTooltip(class_1799 stack, List<class_2561> tooltip) {
        tooltip.add((class_2561)new class_2588(MixedBeerManager.getBaseBeerToolTipTranslationKey()).method_27693(":").method_27692(class_124.field_1068));
        int beerId = MixedBeerManager.getBeerId(stack);
        class_1792 beerItem = Beers.byId(beerId).getBeerItem();
        String beerName = beerId > 0 ? beerItem.method_7876() : MixedBeerManager.getUnmixedToolTipTranslationKey();
        tooltip.add((class_2561)new class_2588(beerName).method_27692(class_124.field_1078));
        if (beerId > 0) {
            String name = beerItem.method_8389().toString();
            if (Beers.byId(beerId).getHasStatusEffectTooltip()) {
                tooltip.add((class_2561)new class_2588("item.drinkbeer." + name + ".tooltip").method_27692(class_124.field_1078));
            }
        }
        if (beerId > 0) {
            class_2561 hunger = class_2561.method_30163((String)String.valueOf(beerItem.method_19264().method_19230()));
            tooltip.add((class_2561)new class_2588("drinkbeer.restores_hunger").method_27692(class_124.field_1078).method_10852(hunger));
        }
        tooltip.add((class_2561)new class_2588(SpiceAndFlavorManager.getFlavorToolTipTranslationKey()).method_27693(":").method_27692(class_124.field_1068));
        List<Integer> spiceList = MixedBeerManager.getSpiceList(stack);
        if (!spiceList.isEmpty()) {
            for (int spiceId : spiceList) {
                Flavors flavor = Spices.byId(spiceId).getFlavor();
                tooltip.add((class_2561)new class_2588(SpiceAndFlavorManager.getFlavorTranslationKey(flavor.getId())).method_27693("(").method_10852((class_2561)new class_2588(SpiceAndFlavorManager.getFlavorToolTipTranslationKey(flavor.getId()))).method_27693(")").method_27692(class_124.field_1061));
            }
        } else {
            tooltip.add((class_2561)new class_2588(SpiceAndFlavorManager.getNoFlavorToolTipTranslationKey()).method_27692(class_124.field_1061));
        }
        Flavors combinedFlavor = SpiceAndFlavorManager.getCombinedFlavor(spiceList);
        if (combinedFlavor != null) {
            tooltip.add((class_2561)new class_2588("").method_27693("\"").method_10852((class_2561)new class_2588(SpiceAndFlavorManager.getFlavorTranslationKey(combinedFlavor.getId()))).method_27693("\"").method_27692(class_124.field_1079));
        }
    }

    public class_2561 method_7864(class_1799 stack) {
        return this.getMixedBeerName(stack);
    }

    @Environment(value=EnvType.CLIENT)
    public class_2561 getMixedBeerName(class_1799 stack) {
        int beerId = MixedBeerManager.getBeerId(stack);
        class_1792 beerItem = Beers.byId(beerId).getBeerItem();
        String beerName = beerId > 0 ? beerItem.method_7876() : "block.drinkbeer.empty_beer_mug";
        class_5250 name = new class_2588(beerName).method_10852((class_2561)new class_2588(MixedBeerManager.getMixedBeerTranslationKey())).method_27692(class_124.field_1054);
        return name;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        this.appendMixedBeerTooltip(stack, tooltip);
    }

    protected boolean method_7708(class_1750 context, class_2680 state) {
        class_1799 stack = context.method_8041();
        ((MixedBeerBlock)state.method_26204()).setBeerId(MixedBeerManager.getBeerId(stack));
        ((MixedBeerBlock)state.method_26204()).setSpiceList(MixedBeerManager.getSpiceList(stack));
        return super.method_7708(context, state);
    }

    protected boolean method_7709(class_1750 context, class_2680 state) {
        if (this.getDistance(context.method_17698(), context.method_8036().method_19538()) > 2.0f) {
            return false;
        }
        return super.method_7709(context, state);
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        if (!world.method_8608()) {
            MixedBeerManager.useMixedBeer(stack, world, user);
        }
        this.giveEmptyMugBack(user);
        return super.method_7861(stack, world, user);
    }
}

