/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lekavar.lma.drinkbeer.util.tradebox.Good;
import lekavar.lma.drinkbeer.util.tradebox.Goods;
import lekavar.lma.drinkbeer.util.tradebox.Locations;
import lekavar.lma.drinkbeer.util.tradebox.Residents;
import net.minecraft.class_1792;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TradeboxManager {
    public static final int COOLING_TIME_ON_PLACE = 6000;
    public static final int COOLING_TIME_ON_REFRESH = 4800;

    private static List<Good> getGoodListByCondition(@Nullable Integer locationId, @Nullable Integer residentId, @Nullable Integer rarity, @Nullable Integer fromOrToLocation) {
        List<Good> goodList = Goods.getList();
        return TradeboxManager.filterGoodList(goodList, locationId, residentId, rarity, fromOrToLocation);
    }

    public static List<Good> getGoodListByResident(@NotNull Integer residentId, @NotNull Integer fromOrToLocation) {
        return TradeboxManager.getGoodListByCondition(Residents.byId(residentId).getLocation().getId(), residentId, null, fromOrToLocation);
    }

    private static List<Good> filterGoodList(@NotNull List<Good> goodList, @Nullable Integer locationId, @Nullable Integer residentId, @Nullable Integer rarity, @Nullable Integer fromOrToLocation) {
        List<Good> resultGoodList = new ArrayList<Good>(goodList);
        if (locationId != null) {
            int finalLocationId = locationId;
            resultGoodList = resultGoodList.stream().filter(good -> good.getLocation().getId() == finalLocationId).collect(Collectors.toList());
        }
        if (residentId != null) {
            int finalResidentId = residentId;
            resultGoodList = resultGoodList.stream().filter(good -> good.getResident() == null || good.getResident().getId() == finalResidentId).collect(Collectors.toList());
        }
        if (rarity != null) {
            int finalRarity = rarity;
            resultGoodList = resultGoodList.stream().filter(good -> good.getRarity() == finalRarity).collect(Collectors.toList());
        }
        if (fromOrToLocation != null) {
            int finalFromOrToLocation = fromOrToLocation;
            resultGoodList = resultGoodList.stream().filter(good -> good.getFromOrToLocation() == finalFromOrToLocation).collect(Collectors.toList());
        }
        return resultGoodList;
    }

    public static List<Good> filterGoodListByRarity(@NotNull List<Good> goodList, @NotNull Integer rarity) {
        return TradeboxManager.filterGoodList(goodList, null, null, rarity, null);
    }

    public static String getLocationTranslationKey(int locationId) {
        return TradeboxManager.getLocationTranslationKey(Locations.byId(locationId));
    }

    public static String getLocationTranslationKey(Locations location) {
        return "drinkbeer.location." + location.getName();
    }

    public static String getResidentTranslationKey(int residentId) {
        return TradeboxManager.getResidentTranslationKey(Residents.byId(residentId));
    }

    public static String getResidentTranslationKey(Residents resident) {
        return "drinkbeer.resident." + resident.getName();
    }

    public static boolean test(Map<class_1792, Integer> inputGoodMap, Map<class_1792, Integer> neededGoodMap) {
        for (Map.Entry<class_1792, Integer> neededGood : neededGoodMap.entrySet()) {
            if (!inputGoodMap.containsKey(neededGood.getKey())) {
                return false;
            }
            if (inputGoodMap.get(neededGood.getKey()) >= neededGood.getValue()) continue;
            return false;
        }
        return true;
    }
}

