/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.util.tradebox;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import lekavar.lma.drinkbeer.manager.TradeboxManager;
import lekavar.lma.drinkbeer.util.tradebox.Good;
import lekavar.lma.drinkbeer.util.tradebox.GoodsRarity;
import lekavar.lma.drinkbeer.util.tradebox.Locations;
import lekavar.lma.drinkbeer.util.tradebox.Residents;

public class TradeMission {
    private int locationId = Locations.EMPTY_LOCATION.getId();
    private int residentId = Residents.EMPTY_RESIDENT.getId();
    private List<Good> goodToLocationList = new ArrayList<Good>();
    private List<Good> goodFromLocationList = new ArrayList<Good>();

    private void setLocationId(int locationId) {
        this.locationId = locationId;
    }

    private void setResidentId(int residentId) {
        this.residentId = residentId;
    }

    private void setGoodToLocationList(List<Good> goodToLocationList) {
        this.goodToLocationList = goodToLocationList;
    }

    private void setGoodFromLocationList(List<Good> goodFromLocationList) {
        this.goodFromLocationList = goodFromLocationList;
    }

    public int getLocationId() {
        return this.locationId;
    }

    public int getResidentId() {
        return this.residentId;
    }

    public List<Good> getGoodFromLocationList() {
        return this.goodFromLocationList;
    }

    public List<Good> getGoodToLocationList() {
        return this.goodToLocationList;
    }

    public static TradeMission genRandomTradeMission() {
        return TradeMission.genTradeMission(Locations.EMPTY_LOCATION.getId());
    }

    public static TradeMission genSpecificTradeMission(int locationId) {
        return TradeMission.genTradeMission(locationId);
    }

    private static TradeMission genTradeMission(int locationId) {
        TradeMission tradeMission = new TradeMission();
        Random random = new Random();
        int finalLocationId = locationId = locationId == Locations.EMPTY_LOCATION.getId() ? Locations.genRandomLocationId() : locationId;
        int residentId = Residents.genRandomResidentId(locationId);
        int basicGoodNum = random.nextInt(3) + 1;
        int goodToLocationNum = basicGoodNum + random.nextInt(2);
        List<Good> basicGoodToLocationList = TradeboxManager.getGoodListByResident(residentId, 2);
        ArrayList<Good> goodToLocationList = new ArrayList<Good>();
        IntStream.range(0, goodToLocationNum).forEach(i -> {
            Good selectedGood = TradeMission.selectRandomGood(basicGoodToLocationList, 2);
            if (selectedGood == null) {
                System.out.println("Has no good to " + Locations.byId(finalLocationId).getName() + "-" + Residents.byId(residentId).getName() + "?");
            } else {
                goodToLocationList.add(selectedGood);
            }
        });
        int goodFromLocationNum = goodToLocationNum == 4 ? 4 : goodToLocationNum + random.nextInt(2);
        List<Good> basicGoodFromLocationList = TradeboxManager.getGoodListByResident(residentId, 1);
        ArrayList<Good> goodFromLocationList = new ArrayList<Good>();
        IntStream.range(0, goodFromLocationNum).forEach(i -> {
            Good selectedGood = TradeMission.selectRandomGood(basicGoodFromLocationList, 1);
            if (selectedGood == null) {
                System.out.println("Has no good from " + Locations.byId(finalLocationId).getName() + "-" + Residents.byId(residentId).getName() + "?");
            } else {
                goodFromLocationList.add(selectedGood);
            }
        });
        tradeMission.setLocationId(locationId);
        tradeMission.setResidentId(residentId);
        tradeMission.setGoodToLocationList(goodToLocationList);
        tradeMission.setGoodFromLocationList(goodFromLocationList);
        return tradeMission;
    }

    private static Good selectRandomGood(List<Good> goodList, int fromOrToLocation) {
        Good good = new Good();
        int rarity = GoodsRarity.genRandomRarity(fromOrToLocation);
        List<Good> goods = TradeboxManager.filterGoodListByRarity(goodList, rarity);
        while (goods.isEmpty() && rarity > 0) {
            goods = TradeboxManager.filterGoodListByRarity(goodList, --rarity);
        }
        if (goods.isEmpty()) {
            return null;
        }
        good.copy(goods.get(new Random().nextInt(goods.size())));
        good.setCount(good.getMinCount() + new Random().nextInt(good.getMaxCount() - good.getMinCount() + 1));
        return good;
    }
}

