/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fmaudio.audio;

import de.keksuccino.auudio.audio.AudioClip;
import de.keksuccino.fmaudio.util.UrlUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class AudioHandler {
    protected static Map<String, AudioClip> audios = new HashMap<String, AudioClip>();
    protected static List<AudioClip> unfinishedAudioCache = new ArrayList<AudioClip>();

    @Nullable
    public static AudioClip getAudio(String source, AudioClip.SoundType soundType) {
        if (soundType == AudioClip.SoundType.EXTERNAL_LOCAL) {
            File f = new File(source);
            if (!f.isFile() || !f.getPath().toLowerCase().endsWith(".ogg")) {
                return null;
            }
        } else if (soundType == AudioClip.SoundType.EXTERNAL_WEB) {
            if (!UrlUtils.isValidUrl(source)) {
                return null;
            }
        } else {
            return null;
        }
        if (!audios.containsKey(source)) {
            AudioClip c = null;
            try {
                c = AudioClip.buildExternalClip((String)source, (AudioClip.SoundType)soundType);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (c != null) {
                audios.put(source, c);
            } else {
                return null;
            }
        }
        return audios.get(source);
    }

    public static AudioClip getAudioIfRegistered(String source) {
        return audios.get(source);
    }

    public static boolean containsAudio(String source) {
        return audios.containsKey(source);
    }

    public static void removeAudioFromCache(String source) {
        AudioClip c = audios.remove(source);
        if (c != null) {
            c.destroy();
        }
    }

    public static List<AudioClip> getCachedAudios() {
        ArrayList<AudioClip> l = new ArrayList<AudioClip>();
        l.addAll(audios.values());
        return l;
    }

    public static boolean containsPausedOrPlayingAudio() {
        for (AudioClip c : audios.values()) {
            if (!c.paused() && !c.playing()) continue;
            return true;
        }
        return false;
    }

    public static void pauseAll() {
        for (AudioClip c : audios.values()) {
            if (!c.playing() || unfinishedAudioCache.contains(c)) continue;
            unfinishedAudioCache.add(c);
            c.pause();
        }
    }

    public static void stopAll() {
        for (AudioClip c : audios.values()) {
            c.stop();
        }
        unfinishedAudioCache.clear();
    }

    public static void resumeUnfinishedAudios() {
        for (AudioClip c : unfinishedAudioCache) {
            try {
                c.play();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        unfinishedAudioCache.clear();
    }

    public static void clearUnfinishedAudioCache() {
        unfinishedAudioCache.clear();
    }
}

