/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fmaudio.customization.item;

import de.keksuccino.fancymenu.menu.fancy.MenuCustomizationProperties;
import de.keksuccino.fmaudio.FmAudio;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSerializer;
import de.keksuccino.konkrete.properties.PropertiesSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ACIMuteHandler {
    private static final File MUTED_ITEMS_FILE = new File(FmAudio.INSTANCE_DATA_DIR.getPath() + "/muted_audio_items.properties");
    protected static List<String> mutedItems = new ArrayList<String>();

    public static void init() {
        ACIMuteHandler.readProperties();
        ACIMuteHandler.removeUnusedItems();
    }

    public static void setMuted(String id, boolean muted) {
        if (muted) {
            if (!mutedItems.contains(id)) {
                mutedItems.add(id);
            }
        } else if (mutedItems.contains(id)) {
            mutedItems.remove(id);
        }
        ACIMuteHandler.writeProperties();
    }

    public static boolean isMuted(String id) {
        return mutedItems.contains(id);
    }

    protected static void removeUnusedItems() {
        try {
            ArrayList sets = new ArrayList();
            sets.addAll(MenuCustomizationProperties.getProperties());
            sets.addAll(MenuCustomizationProperties.getDisabledProperties());
            ArrayList<String> audioItemIdentifiers = new ArrayList<String>();
            for (PropertiesSet set : sets) {
                for (PropertiesSection sec : set.getPropertiesOfType("customization")) {
                    String id;
                    String action = sec.getEntryValue("action");
                    if (action == null || !action.equals("custom_layout_element:fancymenu_extension:audio_item") || (id = sec.getEntryValue("actionid")) == null) continue;
                    audioItemIdentifiers.add(id);
                }
            }
            ArrayList<String> removeItems = new ArrayList<String>();
            for (String s : mutedItems) {
                if (audioItemIdentifiers.contains(s)) continue;
                removeItems.add(s);
            }
            for (String s : removeItems) {
                mutedItems.remove(s);
            }
            ACIMuteHandler.writeProperties();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void writeProperties() {
        try {
            if (!MUTED_ITEMS_FILE.isFile()) {
                MUTED_ITEMS_FILE.createNewFile();
            }
            PropertiesSet set = new PropertiesSet("muted_audio_items");
            PropertiesSection sec = new PropertiesSection("muted-items");
            for (String s : mutedItems) {
                sec.addEntry(s, "---");
            }
            set.addProperties(sec);
            PropertiesSerializer.writeProperties((PropertiesSet)set, (String)MUTED_ITEMS_FILE.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void readProperties() {
        try {
            List secs;
            PropertiesSet set;
            mutedItems.clear();
            if (!MUTED_ITEMS_FILE.isFile()) {
                ACIMuteHandler.writeProperties();
            }
            if ((set = PropertiesSerializer.getProperties((String)MUTED_ITEMS_FILE.getPath())) != null && !(secs = set.getPropertiesOfType("muted-items")).isEmpty()) {
                PropertiesSection sec = (PropertiesSection)secs.get(0);
                for (Map.Entry m : sec.getEntries().entrySet()) {
                    mutedItems.add((String)m.getKey());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

