/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.net.CreateObjectResponseMessage;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.server.MinecraftServer;

public class CopyQuestMessage
extends BaseC2SMessage {
    private final long id;
    private final long chapterId;
    private final double qx;
    private final double qy;
    private final boolean copyDeps;

    public CopyQuestMessage(Quest toCopy, Chapter chapter, double qx, double qy, boolean copyDeps) {
        this.id = toCopy.id;
        this.chapterId = chapter.id;
        this.qx = qx;
        this.qy = qy;
        this.copyDeps = copyDeps;
    }

    public CopyQuestMessage(class_2540 buf) {
        this.id = buf.readLong();
        this.chapterId = buf.readLong();
        this.qx = buf.readDouble();
        this.qy = buf.readDouble();
        this.copyDeps = buf.readBoolean();
    }

    public MessageType getType() {
        return FTBQuestsNetHandler.COPY_QUEST;
    }

    public void write(class_2540 buf) {
        buf.writeLong(this.id);
        buf.writeLong(this.chapterId);
        buf.writeDouble(this.qx);
        buf.writeDouble(this.qy);
        buf.writeBoolean(this.copyDeps);
    }

    public void handle(NetworkManager.PacketContext context) {
        QuestFile file = FTBQuests.PROXY.getQuestFile(false);
        QuestObject questObject = file.get(this.id);
        if (questObject instanceof Quest) {
            Quest toCopy = (Quest)questObject;
            questObject = file.get(this.chapterId);
            if (questObject instanceof Chapter) {
                class_2487 tag1;
                Chapter chapter = (Chapter)questObject;
                class_2487 tag = new class_2487();
                toCopy.writeData(tag);
                Quest newQuest = new Quest(chapter);
                newQuest.readData(tag);
                if (!this.copyDeps) {
                    newQuest.clearDependencies();
                }
                newQuest.id = file.newID();
                newQuest.x = this.qx;
                newQuest.y = this.qy;
                newQuest.onCreated();
                for (Task task2 : toCopy.tasks) {
                    Task newTask = TaskType.createTask(newQuest, task2.getType().getTypeForNBT());
                    if (newTask == null) continue;
                    tag1 = new class_2487();
                    task2.writeData(tag1);
                    newTask.readData(tag1);
                    newTask.id = file.newID();
                    newTask.onCreated();
                }
                for (Reward reward2 : toCopy.rewards) {
                    Reward newReward = RewardType.createReward(newQuest, reward2.getType().getTypeForNBT());
                    if (newReward == null) continue;
                    tag1 = new class_2487();
                    reward2.writeData(tag1);
                    newReward.readData(tag1);
                    newReward.id = file.newID();
                    newReward.onCreated();
                }
                MinecraftServer server = context.getPlayer().method_5682();
                new CreateObjectResponseMessage(newQuest, null).sendToAll(server);
                newQuest.tasks.forEach(task -> {
                    class_2487 extra = new class_2487();
                    extra.method_10582("type", task.getType().getTypeForNBT());
                    new CreateObjectResponseMessage((QuestObjectBase)task, extra).sendToAll(server);
                });
                newQuest.rewards.forEach(reward -> {
                    class_2487 extra = new class_2487();
                    extra.method_10582("type", reward.getType().getTypeForNBT());
                    new CreateObjectResponseMessage((QuestObjectBase)reward, extra).sendToAll(server);
                });
                ServerQuestFile.INSTANCE.refreshIDMap();
                ServerQuestFile.INSTANCE.clearCachedData();
                ServerQuestFile.INSTANCE.save();
            }
        }
    }
}

