/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import com.mojang.util.UUIDTypeAdapter;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.events.QuestProgressEventData;
import dev.ftb.mods.ftbquests.net.ClaimRewardResponseMessage;
import dev.ftb.mods.ftbquests.net.ObjectCompletedMessage;
import dev.ftb.mods.ftbquests.net.ObjectCompletedResetMessage;
import dev.ftb.mods.ftbquests.net.ObjectStartedMessage;
import dev.ftb.mods.ftbquests.net.ObjectStartedResetMessage;
import dev.ftb.mods.ftbquests.net.ResetRewardMessage;
import dev.ftb.mods.ftbquests.net.SyncEditingModeMessage;
import dev.ftb.mods.ftbquests.net.SyncLockMessage;
import dev.ftb.mods.ftbquests.net.SyncRewardBlockingMessage;
import dev.ftb.mods.ftbquests.net.TogglePinnedResponseMessage;
import dev.ftb.mods.ftbquests.net.UpdateTaskProgressMessage;
import dev.ftb.mods.ftbquests.quest.ProgressionMode;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import dev.ftb.mods.ftbquests.quest.reward.RewardClaimType;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.util.FTBQuestsInventoryListener;
import dev.ftb.mods.ftbquests.util.QuestKey;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2ByteOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class TeamData {
    public static int VERSION = 1;
    private static final byte BOOL_NONE = -1;
    private static final byte BOOL_FALSE = 0;
    private static final byte BOOL_TRUE = 1;
    private static final Comparator<Long2LongMap.Entry> LONG2LONG_COMPARATOR = (e1, e2) -> Long.compareUnsigned(e1.getLongValue(), e2.getLongValue());
    private static final Comparator<Object2LongMap.Entry<QuestKey>> OBJECT2LONG_COMPARATOR = (e1, e2) -> Long.compareUnsigned(e1.getLongValue(), e2.getLongValue());
    public final UUID uuid;
    public QuestFile file;
    public String name;
    public boolean shouldSave;
    private boolean locked;
    private boolean rewardsBlocked;
    private final Long2LongOpenHashMap taskProgress;
    private final Object2LongOpenHashMap<QuestKey> claimedRewards;
    private final Long2LongOpenHashMap started;
    private final Long2LongOpenHashMap completed;
    private boolean canEdit;
    private boolean autoPin;
    private boolean chapterPinned;
    public final LongOpenHashSet pinnedQuests;
    private Long2ByteOpenHashMap areDependenciesCompleteCache;
    private Object2ByteOpenHashMap<QuestKey> unclaimedRewardsCache;

    public static TeamData get(class_1657 player) {
        return FTBQuests.PROXY.getQuestFile(player.method_5770().method_8608()).getData((class_1297)player);
    }

    public TeamData(UUID id) {
        this.uuid = id;
        this.name = "";
        this.shouldSave = false;
        this.taskProgress = new Long2LongOpenHashMap();
        this.taskProgress.defaultReturnValue(0L);
        this.claimedRewards = new Object2LongOpenHashMap();
        this.claimedRewards.defaultReturnValue(0L);
        this.started = new Long2LongOpenHashMap();
        this.started.defaultReturnValue(0L);
        this.completed = new Long2LongOpenHashMap();
        this.completed.defaultReturnValue(0L);
        this.canEdit = false;
        this.autoPin = false;
        this.pinnedQuests = new LongOpenHashSet();
    }

    public void save() {
        this.shouldSave = true;
    }

    public String toString() {
        return this.name.isEmpty() ? this.uuid.toString() : this.name;
    }

    public long getProgress(long task) {
        return this.taskProgress.get(task);
    }

    public long getProgress(Task task) {
        return this.getProgress(task.id);
    }

    @Nullable
    public Date getStartedTime(long id) {
        long t = this.started.get(id);
        return t == 0L ? null : new Date(t);
    }

    public boolean setStarted(long id, @Nullable Date time) {
        if (this.locked) {
            return false;
        }
        if (time == null) {
            if (this.started.remove(id) >= 0L) {
                this.clearCachedProgress();
                this.save();
                if (this.file.isServerSide()) {
                    new ObjectStartedResetMessage(this.uuid, id).sendToAll(((ServerQuestFile)this.file).server);
                }
                return true;
            }
        } else if (this.started.put(id, time.getTime()) == 0L) {
            this.clearCachedProgress();
            this.save();
            if (this.file.isServerSide()) {
                new ObjectStartedMessage(this.uuid, id).sendToAll(((ServerQuestFile)this.file).server);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public Date getCompletedTime(long id) {
        long t = this.completed.get(id);
        return t == 0L ? null : new Date(t);
    }

    public boolean setCompleted(long id, @Nullable Date time) {
        if (this.locked) {
            return false;
        }
        if (time == null) {
            if (this.completed.remove(id) >= 0L) {
                this.clearCachedProgress();
                this.save();
                if (this.file.isServerSide()) {
                    new ObjectCompletedResetMessage(this.uuid, id).sendToAll(((ServerQuestFile)this.file).server);
                }
                return true;
            }
        } else if (this.completed.put(id, time.getTime()) == 0L) {
            this.clearCachedProgress();
            this.save();
            if (this.file.isServerSide()) {
                new ObjectCompletedMessage(this.uuid, id).sendToAll(((ServerQuestFile)this.file).server);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public Date getRewardClaimTime(UUID player, Reward reward) {
        QuestKey key = QuestKey.of(reward.isTeamReward() ? class_156.field_25140 : player, reward.id);
        long t = this.claimedRewards.getLong((Object)key);
        return t == 0L ? null : new Date(t);
    }

    public boolean areRewardsBlocked() {
        return this.rewardsBlocked;
    }

    public boolean isRewardBlocked(Reward reward) {
        return this.areRewardsBlocked() && !reward.ignoreRewardBlocking() && !reward.quest.ignoreRewardBlocking();
    }

    public boolean setRewardsBlocked(boolean rewardsBlocked) {
        if (rewardsBlocked != this.rewardsBlocked) {
            this.rewardsBlocked = rewardsBlocked;
            this.clearCachedProgress();
            this.save();
            if (this.file.isServerSide()) {
                new SyncRewardBlockingMessage(this.uuid, rewardsBlocked).sendToAll(((ServerQuestFile)this.file).server);
            }
            return true;
        }
        return false;
    }

    public boolean isRewardClaimed(UUID player, Reward reward) {
        return this.getRewardClaimTime(player, reward) != null;
    }

    public boolean hasUnclaimedRewards(UUID player, QuestObject object) {
        QuestKey key;
        byte b;
        if (this.unclaimedRewardsCache == null) {
            this.unclaimedRewardsCache = new Object2ByteOpenHashMap();
            this.unclaimedRewardsCache.defaultReturnValue((byte)-1);
        }
        if ((b = this.unclaimedRewardsCache.getByte((Object)(key = QuestKey.of(player, object.id)))) == -1) {
            b = object.hasUnclaimedRewardsRaw(this, player) ? (byte)1 : 0;
            this.unclaimedRewardsCache.put((Object)key, b);
        }
        return b == 1;
    }

    public boolean claimReward(UUID player, Reward reward, long date) {
        if (this.locked || this.isRewardBlocked(reward)) {
            return false;
        }
        QuestKey key = QuestKey.of(reward.isTeamReward() ? class_156.field_25140 : player, reward.id);
        if (!this.claimedRewards.containsKey((Object)key)) {
            this.claimedRewards.put((Object)key, date);
            this.clearCachedProgress();
            this.save();
            if (this.file.isServerSide()) {
                new ClaimRewardResponseMessage(this.uuid, player, reward.id).sendToAll(((ServerQuestFile)this.file).server);
            }
            reward.quest.checkRepeatable(this, player);
            return true;
        }
        return false;
    }

    public void deleteReward(Reward reward) {
        if (!this.locked && this.claimedRewards.object2LongEntrySet().removeIf(e -> ((QuestKey)e.getKey()).id == reward.id)) {
            this.clearCachedProgress();
            this.save();
        }
    }

    public boolean resetReward(UUID player, Reward reward) {
        if (!this.locked && this.claimedRewards.removeLong((Object)QuestKey.of(reward.isTeamReward() ? class_156.field_25140 : player, reward.id)) != 0L) {
            this.clearCachedProgress();
            this.save();
            if (this.file.isServerSide()) {
                new ResetRewardMessage(this.uuid, player, reward.id).sendToAll(((ServerQuestFile)this.file).server);
            }
            return true;
        }
        return false;
    }

    public boolean getCanEdit() {
        return this.canEdit;
    }

    public boolean setCanEdit(boolean mode) {
        if (this.canEdit != mode) {
            this.canEdit = mode;
            this.clearCachedProgress();
            this.save();
            if (this.file.isServerSide()) {
                new SyncEditingModeMessage(this.uuid, this.canEdit).sendToAll(((ServerQuestFile)this.file).server);
            }
            return true;
        }
        return false;
    }

    public boolean getAutoPin() {
        return this.isQuestPinned(1L);
    }

    public void setAutoPin(boolean auto) {
        if (this.autoPin != auto) {
            this.autoPin = auto;
            this.save();
        }
    }

    public boolean isQuestPinned(long id) {
        return this.pinnedQuests.contains(id);
    }

    public void setQuestPinned(long id, boolean pinned) {
        if (pinned ? this.pinnedQuests.add(id) : this.pinnedQuests.remove(id)) {
            this.save();
        }
    }

    public void clearCachedProgress() {
        this.areDependenciesCompleteCache = null;
        this.unclaimedRewardsCache = null;
    }

    public SNBTCompoundTag serializeNBT() {
        SNBTCompoundTag nbt = new SNBTCompoundTag();
        nbt.method_10569("version", VERSION);
        nbt.method_10582("uuid", UUIDTypeAdapter.fromUUID((UUID)this.uuid));
        nbt.method_10582("name", this.name);
        nbt.method_10556("can_edit", this.canEdit);
        nbt.method_10556("lock", this.locked);
        nbt.method_10556("auto_pin", this.autoPin);
        nbt.method_10556("chapter_pinned", this.chapterPinned);
        nbt.method_10556("rewards_blocked", this.rewardsBlocked);
        SNBTCompoundTag taskProgressNBT = new SNBTCompoundTag();
        for (Object entry : this.taskProgress.long2LongEntrySet()) {
            if (entry.getLongValue() <= Integer.MAX_VALUE) {
                taskProgressNBT.method_10569(QuestObjectBase.getCodeString(entry.getLongKey()), (int)entry.getLongValue());
                continue;
            }
            taskProgressNBT.method_10544(QuestObjectBase.getCodeString(entry.getLongKey()), entry.getLongValue());
        }
        nbt.method_10566("task_progress", (class_2520)taskProgressNBT);
        SNBTCompoundTag startedNBT = new SNBTCompoundTag();
        for (Object entry : this.started.long2LongEntrySet().stream().sorted(LONG2LONG_COMPARATOR).collect(Collectors.toList())) {
            startedNBT.method_10544(QuestObjectBase.getCodeString(entry.getLongKey()), entry.getLongValue());
        }
        nbt.method_10566("started", (class_2520)startedNBT);
        SNBTCompoundTag completedNBT = new SNBTCompoundTag();
        for (Object entry : this.completed.long2LongEntrySet().stream().sorted(LONG2LONG_COMPARATOR).collect(Collectors.toList())) {
            completedNBT.method_10544(QuestObjectBase.getCodeString(entry.getLongKey()), entry.getLongValue());
        }
        nbt.method_10566("completed", (class_2520)completedNBT);
        SNBTCompoundTag claimedRewardsNBT = new SNBTCompoundTag();
        for (Object2LongMap.Entry entry : this.claimedRewards.object2LongEntrySet().stream().sorted(OBJECT2LONG_COMPARATOR).collect(Collectors.toList())) {
            claimedRewardsNBT.method_10544(((QuestKey)entry.getKey()).toString(), entry.getLongValue());
        }
        nbt.method_10566("claimed_rewards", (class_2520)claimedRewardsNBT);
        long[] pinnedQuestsArray = this.pinnedQuests.toLongArray();
        Arrays.sort(pinnedQuestsArray);
        class_2499 pinnedQuestsNBT = new class_2499();
        for (long l : pinnedQuestsArray) {
            pinnedQuestsNBT.add((Object)class_2519.method_23256((String)QuestObjectBase.getCodeString(l)));
        }
        nbt.method_10566("pinned_quests", (class_2520)pinnedQuestsNBT);
        return nbt;
    }

    public void deserializeNBT(SNBTCompoundTag nbt) {
        int fileVersion = nbt.method_10550("version");
        if (fileVersion != VERSION) {
            this.save();
        }
        this.name = nbt.method_10558("name");
        this.canEdit = nbt.method_10577("can_edit");
        this.locked = nbt.method_10577("lock");
        this.autoPin = nbt.method_10577("auto_pin");
        this.chapterPinned = nbt.method_10577("chapter_pinned");
        this.rewardsBlocked = nbt.method_10577("rewards_blocked");
        this.taskProgress.clear();
        this.claimedRewards.clear();
        this.pinnedQuests.clear();
        SNBTCompoundTag claimedRewardsNBT = nbt.getCompound("claimed_rewards");
        for (String s : claimedRewardsNBT.method_10541()) {
            this.claimedRewards.put((Object)QuestKey.of(s), claimedRewardsNBT.method_10537(s));
        }
        class_2499 pinnedQuestsNBT = nbt.method_10554("pinned_quests", 8);
        for (int i = 0; i < pinnedQuestsNBT.size(); ++i) {
            this.pinnedQuests.add(this.file.getID(pinnedQuestsNBT.method_10608(i)));
        }
        SNBTCompoundTag taskProgressNBT = nbt.getCompound("task_progress");
        for (Object s : taskProgressNBT.method_10541()) {
            this.taskProgress.put(this.file.getID(s), taskProgressNBT.method_10537((String)s));
        }
        SNBTCompoundTag startedNBT = nbt.getCompound("started");
        for (String s : startedNBT.method_10541()) {
            this.started.put(this.file.getID(s), startedNBT.method_10537(s));
        }
        SNBTCompoundTag completedNBT = nbt.getCompound("completed");
        for (String s : completedNBT.method_10541()) {
            this.completed.put(this.file.getID(s), completedNBT.method_10537(s));
        }
    }

    public void write(class_2540 buffer, boolean self) {
        buffer.method_10788(this.name, Short.MAX_VALUE);
        buffer.method_10804(this.taskProgress.size());
        for (Long2LongMap.Entry entry : this.taskProgress.long2LongEntrySet()) {
            buffer.writeLong(entry.getLongKey());
            buffer.method_10791(entry.getLongValue());
        }
        long now = System.currentTimeMillis();
        buffer.method_10804(this.started.size());
        for (Long2LongMap.Entry entry : this.started.long2LongEntrySet()) {
            buffer.writeLong(entry.getLongKey());
            buffer.method_10791(now - entry.getValue());
        }
        buffer.method_10804(this.completed.size());
        for (Long2LongMap.Entry entry : this.completed.long2LongEntrySet()) {
            buffer.writeLong(entry.getLongKey());
            buffer.method_10791(now - entry.getValue());
        }
        buffer.writeBoolean(this.locked);
        buffer.writeBoolean(this.rewardsBlocked);
        if (self) {
            buffer.method_10804(this.claimedRewards.size());
            for (Long2LongMap.Entry entry : this.claimedRewards.object2LongEntrySet()) {
                ((QuestKey)entry.getKey()).write(buffer);
                buffer.method_10791(now - entry.getLongValue());
            }
            buffer.writeBoolean(this.canEdit);
            buffer.writeBoolean(this.autoPin);
            buffer.writeBoolean(this.chapterPinned);
            buffer.method_10804(this.pinnedQuests.size());
            ObjectIterator objectIterator = this.pinnedQuests.iterator();
            while (objectIterator.hasNext()) {
                long reward = (Long)objectIterator.next();
                buffer.writeLong(reward);
            }
        }
    }

    public void read(class_2540 buffer, boolean self) {
        this.name = buffer.method_10800(Short.MAX_VALUE);
        this.taskProgress.clear();
        int ts = buffer.method_10816();
        for (int i = 0; i < ts; ++i) {
            this.taskProgress.put(buffer.readLong(), buffer.method_10792());
        }
        long now = System.currentTimeMillis();
        this.started.clear();
        int ss = buffer.method_10816();
        for (int i = 0; i < ss; ++i) {
            this.started.put(buffer.readLong(), now - buffer.method_10792());
        }
        this.completed.clear();
        int cs = buffer.method_10816();
        for (int i = 0; i < cs; ++i) {
            this.completed.put(buffer.readLong(), now - buffer.method_10792());
        }
        this.locked = buffer.readBoolean();
        this.rewardsBlocked = buffer.readBoolean();
        this.claimedRewards.clear();
        this.canEdit = false;
        this.autoPin = false;
        this.pinnedQuests.clear();
        if (self) {
            int crs = buffer.method_10816();
            for (int i = 0; i < crs; ++i) {
                QuestKey key = QuestKey.of(buffer);
                this.claimedRewards.put((Object)key, now - buffer.method_10792());
            }
            this.canEdit = buffer.readBoolean();
            this.autoPin = buffer.readBoolean();
            this.chapterPinned = buffer.readBoolean();
            int pqs = buffer.method_10816();
            for (int i = 0; i < pqs; ++i) {
                this.pinnedQuests.add(buffer.readLong());
            }
        }
    }

    public int getRelativeProgress(QuestObject object) {
        if (this.isCompleted(object)) {
            return 100;
        }
        if (!this.isStarted(object)) {
            return 0;
        }
        return object.getRelativeProgressFromChildren(this);
    }

    public boolean isStarted(QuestObject object) {
        return this.started.containsKey(object.id);
    }

    public boolean isCompleted(QuestObject object) {
        return this.completed.containsKey(object.id);
    }

    public boolean areDependenciesComplete(Quest quest) {
        byte b;
        if (!quest.hasDependencies()) {
            return true;
        }
        if (this.areDependenciesCompleteCache == null) {
            this.areDependenciesCompleteCache = new Long2ByteOpenHashMap();
            this.areDependenciesCompleteCache.defaultReturnValue((byte)-1);
        }
        if ((b = this.areDependenciesCompleteCache.get(quest.id)) == -1) {
            b = this.areDependenciesComplete0(quest) ? (byte)1 : 0;
            this.areDependenciesCompleteCache.put(quest.id, b);
        }
        return b == 1;
    }

    private boolean areDependenciesComplete0(Quest quest) {
        if (quest.minRequiredDependencies > 0) {
            return quest.getDependencies().filter(dep -> this.isCompleted((QuestObject)dep) && !dep.invalid).limit(quest.minRequiredDependencies).count() == (long)quest.minRequiredDependencies;
        }
        if (quest.dependencyRequirement.one) {
            return quest.getDependencies().anyMatch(dep -> !dep.invalid && (quest.dependencyRequirement.completed ? this.isCompleted((QuestObject)dep) : this.isStarted((QuestObject)dep)));
        }
        return quest.getDependencies().allMatch(dep -> !dep.invalid && (quest.dependencyRequirement.completed ? this.isCompleted((QuestObject)dep) : this.isStarted((QuestObject)dep)));
    }

    public boolean canStartTasks(Quest quest) {
        return quest.getProgressionMode() == ProgressionMode.FLEXIBLE || this.areDependenciesComplete(quest);
    }

    public void claimReward(class_3222 player, Reward reward, boolean notify) {
        if (this.claimReward(player.method_5667(), reward, System.currentTimeMillis())) {
            reward.claim(player, notify);
            if (this.file.isServerSide()) {
                new ClaimRewardResponseMessage(this.uuid, player.method_5667(), reward.id).sendToAll(((ServerQuestFile)this.file).server);
            }
        }
    }

    public List<class_3222> getOnlineMembers() {
        Team team = FTBTeamsAPI.getManager().getTeamByID(this.uuid);
        return team == null ? Collections.emptyList() : team.getOnlineMembers();
    }

    public void checkAutoCompletion(Quest quest) {
        if (quest.rewards.isEmpty() || !this.isCompleted(quest)) {
            return;
        }
        List<class_3222> online = null;
        for (Reward reward : quest.rewards) {
            RewardAutoClaim auto = reward.getAutoClaimType();
            if (auto == RewardAutoClaim.DISABLED) continue;
            if (online == null && (online = this.getOnlineMembers()).isEmpty()) {
                return;
            }
            for (class_3222 player : online) {
                this.claimReward(player, reward, auto == RewardAutoClaim.ENABLED);
            }
        }
    }

    public RewardClaimType getClaimType(UUID player, Reward reward) {
        boolean r = this.isRewardClaimed(player, reward);
        if (r) {
            return RewardClaimType.CLAIMED;
        }
        if (this.isCompleted(reward.quest)) {
            return RewardClaimType.CAN_CLAIM;
        }
        return RewardClaimType.CANT_CLAIM;
    }

    public void resetProgress(Task task) {
        if (this.taskProgress.remove(task.id) > 0L) {
            this.save();
        }
    }

    public final void setProgress(Task task, long progress) {
        if (this.locked) {
            return;
        }
        long maxProgress = task.getMaxProgress();
        progress = Math.max(0L, Math.min(progress, maxProgress));
        long prevProgress = this.getProgress(task);
        if (prevProgress != progress || progress == 0L && this.isStarted(task)) {
            if (progress == 0L) {
                this.taskProgress.remove(task.id);
                this.started.remove(task.id);
                this.completed.remove(task.id);
            } else {
                this.taskProgress.put(task.id, progress);
            }
            this.clearCachedProgress();
            if (this.file.isServerSide()) {
                Date now = new Date();
                new UpdateTaskProgressMessage(this, task.id, progress).sendToAll(((ServerQuestFile)this.file).server);
                if (prevProgress == 0L) {
                    task.onStarted(new QuestProgressEventData<Task>(now, this, task, this.getOnlineMembers(), Collections.emptyList()));
                }
                if (progress >= maxProgress && this.areDependenciesComplete(task.quest)) {
                    this.markTaskCompleted(task);
                }
            }
            this.save();
        }
    }

    public void markTaskCompleted(Task task) {
        List<class_3222> onlineMembers = this.getOnlineMembers();
        List<Object> notifiedPlayers = !task.quest.chapter.alwaysInvisible && QuestObjectBase.sendNotifications.get(true) ? onlineMembers : Collections.emptyList();
        task.onCompleted(new QuestProgressEventData<Task>(new Date(), this, task, onlineMembers, notifiedPlayers));
        for (class_3222 player : onlineMembers) {
            FTBQuestsInventoryListener.detect(player, class_1799.field_8037, task.id);
        }
        if (this.isCompleted(task.quest)) {
            this.setQuestPinned(task.quest.id, false);
            new TogglePinnedResponseMessage(task.quest.id, false).sendTo(onlineMembers);
        }
    }

    public final void addProgress(Task task, long p) {
        this.setProgress(task, this.getProgress(task) + p);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean setLocked(boolean b) {
        if (this.locked != b) {
            this.locked = b;
            this.clearCachedProgress();
            this.save();
            if (this.file.isServerSide()) {
                new SyncLockMessage(this.uuid, this.locked).sendToAll(((ServerQuestFile)this.file).server);
            }
            return true;
        }
        return false;
    }

    public void mergeData(TeamData from) {
        for (Long2LongMap.Entry entry : from.taskProgress.long2LongEntrySet()) {
            this.taskProgress.put(entry.getLongKey(), Long.max(entry.getLongValue(), this.taskProgress.getOrDefault(entry.getLongKey(), 0L)));
        }
        for (Long2LongMap.Entry entry : from.claimedRewards.object2LongEntrySet()) {
            if (this.claimedRewards.containsKey(entry.getKey())) continue;
            this.claimedRewards.put((Object)((QuestKey)entry.getKey()), entry.getLongValue());
        }
        for (Long2LongMap.Entry entry : from.started.long2LongEntrySet()) {
            if (this.started.containsKey(entry.getLongKey())) continue;
            this.started.put(entry.getLongKey(), entry.getLongValue());
        }
        for (Long2LongMap.Entry entry : from.completed.long2LongEntrySet()) {
            if (this.completed.containsKey(entry.getLongKey())) continue;
            this.completed.put(entry.getLongKey(), entry.getLongValue());
        }
    }

    public void copyData(TeamData from) {
        this.locked = from.locked;
        this.taskProgress.putAll((Map)from.taskProgress);
        this.claimedRewards.putAll(from.claimedRewards);
        this.started.putAll((Map)from.started);
        this.completed.putAll((Map)from.completed);
        this.canEdit = from.canEdit;
        this.autoPin = from.autoPin;
        this.pinnedQuests.addAll((LongCollection)from.pinnedQuests);
        this.rewardsBlocked = from.rewardsBlocked;
    }

    public void setChapterPinned(boolean pinned) {
        this.chapterPinned = pinned;
        this.save();
    }

    public boolean isChapterPinned() {
        return this.chapterPinned;
    }
}

