/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.loot;

import dev.ftb.mods.ftbquests.quest.reward.Reward;

public class WeightedReward
implements Comparable<WeightedReward> {
    public final Reward reward;
    public int weight;

    public WeightedReward(Reward r, int w) {
        this.reward = r;
        this.weight = Math.max(w, 0);
    }

    public static String chanceString(int weight, int totalWeight, boolean empty) {
        if (totalWeight <= 0) {
            return "??%";
        }
        if (weight <= 0) {
            return empty ? "0%" : "100%";
        }
        if (weight >= totalWeight) {
            return "100%";
        }
        int chance = weight * 100 / totalWeight;
        double chanced = (double)weight * 100.0 / (double)totalWeight;
        if ((double)chance != chanced) {
            if (chanced < 0.01) {
                return "<0.01%";
            }
            return String.format("%.2f%%", chanced);
        }
        return chance + "%";
    }

    public static String chanceString(int weight, int totalWeight) {
        return WeightedReward.chanceString(weight, totalWeight, false);
    }

    @Override
    public int compareTo(WeightedReward o) {
        return Integer.compare(this.weight, o.weight);
    }
}

