/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.util;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;

public class NetUtils {
    public static boolean canEdit(NetworkManager.PacketContext context) {
        class_1657 playerEntity = context.getPlayer();
        return playerEntity != null && ServerQuestFile.INSTANCE.getData((class_1297)playerEntity).getCanEdit();
    }

    public static <T> void write(class_2540 buffer, Collection<T> list, BiConsumer<class_2540, T> writer) {
        buffer.method_10804(list.size());
        for (T value : list) {
            writer.accept(buffer, (class_2540)value);
        }
    }

    public static <K, V> void write(class_2540 buffer, Map<K, V> map, BiConsumer<class_2540, K> keyWriter, BiConsumer<class_2540, V> valueWriter) {
        buffer.method_10804(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            keyWriter.accept(buffer, entry.getKey());
            valueWriter.accept(buffer, entry.getValue());
        }
    }

    public static void writeStrings(class_2540 buffer, Collection<String> list) {
        NetUtils.write(buffer, list, (b, s) -> b.method_10788(s, Short.MAX_VALUE));
    }

    public static <T> void read(class_2540 buffer, Collection<T> list, Function<class_2540, T> reader) {
        list.clear();
        int s = buffer.method_10816();
        for (int i = 0; i < s; ++i) {
            list.add(reader.apply(buffer));
        }
    }

    public static <K, V> void read(class_2540 buffer, Map<K, V> map, Function<class_2540, K> keyReader, BiFunction<K, class_2540, V> valueReader) {
        map.clear();
        int s = buffer.method_10816();
        for (int i = 0; i < s; ++i) {
            K key = keyReader.apply(buffer);
            map.put(key, valueReader.apply(key, buffer));
        }
    }

    public static void readStrings(class_2540 buffer, Collection<String> list) {
        NetUtils.read(buffer, list, b -> b.method_10800(Short.MAX_VALUE));
    }

    public static void writeIcon(class_2540 buffer, Icon icon) {
        buffer.method_10788(icon.toString(), Short.MAX_VALUE);
    }

    public static Icon readIcon(class_2540 buffer) {
        return Icon.getIcon((String)buffer.method_10800(Short.MAX_VALUE));
    }
}

