/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.mysticaloaktree.block;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mehvahdjukaar.mysticaloaktree.MysticalOakTree;
import net.mehvahdjukaar.mysticaloaktree.block.Relationship;
import net.mehvahdjukaar.mysticaloaktree.block.WiseOakBlock;
import net.mehvahdjukaar.mysticaloaktree.client.TreeLoreManager;
import net.mehvahdjukaar.mysticaloaktree.client.dialogues.DialogueInstance;
import net.mehvahdjukaar.mysticaloaktree.client.dialogues.ITreeDialogue;
import net.mehvahdjukaar.mysticaloaktree.client.dialogues.TreeDialogueTypes;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2622;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;

public class WiseOakTile
extends class_2586 {
    public static final int BLOW_DURATION = 34;
    public static final int FOLLOW_TIME = 60;
    public static final int DIALOGUES_TO_SLEEP = 6;
    public static final int BLINK_TIME = 5;
    private static final double BLOW_DIST = 11.0;
    private static final double THICC_CHANCE = 0.03;
    private final Map<UUID, Relationship> playerRelationship = new HashMap<UUID, Relationship>();
    private class_1657 playerTarget;
    private int blowCounter;
    private int followCounter;
    private int dialoguesUntilSlept = 0;
    @Nullable
    private DialogueInstance currentDialogue = null;

    public WiseOakTile(class_2338 blockPos, class_2680 blockState) {
        super(MysticalOakTree.TILE.get(), blockPos, blockState);
    }

    @NotNull
    private Relationship getRelationship(class_1657 player) {
        return this.playerRelationship.computeIfAbsent(player.method_5667(), u -> new Relationship(0));
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, WiseOakTile tile) {
        if (tile.blowCounter > 0) {
            --tile.blowCounter;
        }
        if (((WiseOakBlock.State)((Object)state.method_11654(WiseOakBlock.STATE))).isBlowing()) {
            if (tile.blowCounter <= 0) {
                tile.stopBlowing(level, pos, state, tile);
            }
            if (tile.playerTarget != null && WiseOakTile.isInLineOfSight((class_2350)state.method_11654((class_2769)WiseOakBlock.field_11177), pos, level, (class_1297)tile.playerTarget)) {
                if (level.field_9236) {
                    tile.blowParticles(state, level, pos);
                }
                tile.blowPlayer(state, level, pos);
            }
        }
        if (level.field_9236) {
            if (tile.currentDialogue != null && !tile.currentDialogue.tick(pos)) {
                tile.currentDialogue = null;
            }
        } else {
            if (tile.followCounter > 0) {
                if (tile.playerTarget != null) {
                    WiseOakTile.rotateTowardPlayer(state, level, pos, tile.playerTarget);
                }
                --tile.followCounter;
                if (tile.followCounter == 0) {
                    tile.playerTarget = null;
                }
            }
            if (tile.blowCounter == 0 && level.method_8510() % 23L == 0L && level.field_9229.nextInt(21) == 0) {
                if (tile.dialoguesUntilSlept > 6 && state.method_11654(WiseOakBlock.STATE) == WiseOakBlock.State.NONE) {
                    tile.goToSleep(level, pos, state);
                } else {
                    tile.randomTick(state, (class_3218)level, pos, level.field_9229);
                }
            }
        }
    }

    public void randomTick(class_2680 state, class_3218 level, class_2338 pos, Random random) {
        boolean isDay;
        WiseOakBlock.State s = (WiseOakBlock.State)((Object)state.method_11654(WiseOakBlock.STATE));
        if (s == WiseOakBlock.State.ANGRY && random.nextInt(3) == 0) {
            level.method_8501(pos, (class_2680)state.method_11657(WiseOakBlock.STATE, (Comparable)((Object)WiseOakBlock.State.NONE)));
            return;
        }
        boolean bl = isDay = !level.method_23886();
        if (s.canSleep() && isDay) {
            this.goToSleep((class_1937)level, pos, state);
            return;
        }
        if (s == WiseOakBlock.State.SLEEPING && !isDay) {
            this.wakeUp((class_1937)level, pos, state);
            return;
        }
        if (s.canBlink() && random.nextFloat() < 1.0f) {
            level.method_39279(pos, state.method_26204(), 5);
            level.method_8652(pos, (class_2680)state.method_11657(WiseOakBlock.STATE, (Comparable)((Object)WiseOakBlock.State.getBlinking(s))), 3);
        }
    }

    private void goToSleep(class_1937 level, class_2338 pos, class_2680 state) {
        this.playerTarget = null;
        this.followCounter = 0;
        this.blowCounter = 0;
        level.method_8501(pos, (class_2680)state.method_11657(WiseOakBlock.STATE, (Comparable)((Object)WiseOakBlock.State.SLEEPING)));
    }

    private void wakeUp(class_1937 level, class_2338 pos, class_2680 state) {
        this.dialoguesUntilSlept = 0;
        level.method_8501(pos, (class_2680)state.method_11657(WiseOakBlock.STATE, (Comparable)((Object)WiseOakBlock.State.NONE)));
    }

    public class_1269 onInteract(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand) {
        boolean wokenUp;
        WiseOakBlock.State treeState = (WiseOakBlock.State)((Object)state.method_11654(WiseOakBlock.STATE));
        if (treeState.isAngry()) {
            return class_1269.field_5811;
        }
        Relationship r = this.getRelationship(player);
        boolean bl = wokenUp = treeState == WiseOakBlock.State.SLEEPING;
        if (wokenUp || r.checkTalkCooldown(level)) {
            ++this.dialoguesUntilSlept;
            if (level.field_9236) {
                DialogueInstance dialogue = this.getOrCreateDialogue(wokenUp ? TreeDialogueTypes.WOKEN_UP : TreeDialogueTypes.TALKED_TO, level.field_9229, r);
                if (dialogue != null) {
                    dialogue.interact(pos);
                }
            } else {
                if (wokenUp || r.isInConfidence()) {
                    this.setTrackedTarget(player);
                }
                if (wokenUp || r.isFriendlyAt()) {
                    WiseOakTile.rotateTowardPlayer(state, level, pos, player);
                }
            }
            if (wokenUp) {
                this.wakeUp(level, pos, state);
                r.decrease();
                this.spawnAngryParticles(level, pos, state);
            }
            return class_1269.method_29236((boolean)level.field_9236);
        }
        return class_1269.field_5811;
    }

    @Nullable
    private DialogueInstance getOrCreateDialogue(ITreeDialogue.Type<?> source, Random Random2, Relationship r) {
        if (this.currentDialogue == null) {
            this.createRandomDialogue(source, Random2, r);
        }
        return this.currentDialogue;
    }

    private DialogueInstance createRandomDialogue(ITreeDialogue.Type<?> source, Random Random2, Relationship r) {
        ITreeDialogue dialogue = TreeLoreManager.getRandomDialogue(source, Random2, r.getTrust());
        if (dialogue != null) {
            this.currentDialogue = dialogue.createInstance();
            return this.currentDialogue;
        }
        return null;
    }

    public void onAttack(class_2680 state, class_1937 level, class_2338 pos, class_1657 player) {
        DialogueInstance dialogue;
        Relationship r = this.getRelationship(player);
        this.spawnAngryParticles(level, pos, state);
        this.startBlowingAt(player, state, pos, level);
        if (level.field_9236 && (dialogue = this.createRandomDialogue(TreeDialogueTypes.HURT, level.field_9229, r)) != null) {
            dialogue.tick(pos);
        }
        r.decrease();
    }

    private void spawnAngryParticles(class_1937 level, class_2338 pos, class_2680 state) {
        level.method_8427(pos, state.method_26204(), 1, 0);
    }

    private void blowParticles(class_2680 state, class_1937 level, class_2338 pos) {
        if (this.playerTarget != null) {
            class_2350 dir = (class_2350)state.method_11654((class_2769)WiseOakBlock.field_11177);
            class_243 p = class_243.method_24953((class_2382)pos);
            p = p.method_1019(new class_243((double)dir.method_10163().method_10263(), (double)dir.method_10163().method_10264(), (double)dir.method_10163().method_10260()).method_1021(0.6));
            class_243 speed = p.method_1020(this.playerTarget.method_19538().method_1031(0.0, (double)(this.playerTarget.method_5751() * 2.0f / 3.0f), 0.0));
            speed = speed.method_1029();
            speed = speed.method_1021((double)-0.4f);
            for (int j = 0; j < 2; ++j) {
                level.method_8406((class_2394)MysticalOakTree.WIND.get(), p.field_1352 + (double)((level.field_9229.nextFloat() - level.field_9229.nextFloat()) * 0.05f), p.field_1351 - 0.33 + (double)((level.field_9229.nextFloat() - level.field_9229.nextFloat()) * 0.05f), p.field_1350, speed.field_1352, speed.field_1351, speed.field_1350);
            }
        }
    }

    private void blowPlayer(class_2680 state, class_1937 level, class_2338 pos) {
        double max;
        double dist;
        if (this.playerTarget != null && (dist = pos.method_19770((class_2374)this.playerTarget.method_19538())) < (max = 121.0)) {
            double strength = 1.0 - dist / max;
            class_243 direction = WiseOakTile.getViewVector(pos, (class_1297)this.playerTarget);
            direction = direction.method_1021((strength *= 1.0 - 0.25 * class_3532.method_15350((double)this.playerTarget.method_26825(class_5134.field_23718), (double)0.0, (double)1.0)) * 0.25);
            class_243 vec3 = this.playerTarget.method_18798();
            this.playerTarget.method_18800(vec3.field_1352 + direction.field_1352, vec3.field_1351 + (double)(this.playerTarget.method_24828() ? 0.0f : 0.0f), vec3.field_1350 + direction.field_1350);
        }
    }

    private static class_243 getViewVector(class_2338 pos, class_1297 entity) {
        class_243 p = class_243.method_24953((class_2382)pos);
        class_243 speed = entity.method_19538().method_1020(p);
        speed = speed.method_1029();
        return speed;
    }

    private void stopBlowing(class_1937 level, class_2338 pos, class_2680 state, WiseOakTile tile) {
        tile.playerTarget = null;
        tile.followCounter = 0;
        level.method_8501(pos, (class_2680)state.method_11657(WiseOakBlock.STATE, (Comparable)((Object)WiseOakBlock.State.ANGRY)));
    }

    private void startBlowingAt(class_1657 player, class_2680 state, class_2338 pos, class_1937 level) {
        WiseOakTile.rotateTowardPlayer(state, level, pos, player);
        this.blowCounter = 34;
        level.method_8501(pos, (class_2680)level.method_8320(pos).method_11657(WiseOakBlock.STATE, (Comparable)((Object)((double)level.field_9229.nextFloat() < 0.03 ? WiseOakBlock.State.THICC : WiseOakBlock.State.BLOWING))));
        this.setTrackedTarget(player);
    }

    private void setTrackedTarget(class_1657 player) {
        this.playerTarget = player;
        this.followCounter = 60;
    }

    public static void rotateTowardPlayer(class_2680 state, class_1937 level, class_2338 pos, class_1657 player) {
        class_243 v = player.method_19538().method_1023((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        class_2350 d = class_2350.method_10142((double)v.field_1352, (double)0.0, (double)v.field_1350);
        if (d.method_10166() != class_2350.class_2351.field_11052 && state.method_11654((class_2769)class_2383.field_11177) != d) {
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2383.field_11177, (Comparable)d));
        }
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_2499 list = new class_2499();
        for (Map.Entry<UUID, Relationship> v : this.playerRelationship.entrySet()) {
            class_2487 comp = new class_2487();
            comp.method_10569("trust", v.getValue().getTrust());
            comp.method_25927("id", v.getKey());
            list.add((Object)comp);
        }
        if (!list.isEmpty()) {
            tag.method_10566("relationship", (class_2520)list);
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.playerRelationship.clear();
        class_2499 list = tag.method_10554("relationship", 10);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                class_2487 effectsCompound = list.method_10602(i);
                UUID id = effectsCompound.method_25926("id");
                Integer level = effectsCompound.method_10550("trust");
                if (id == null) continue;
                this.playerRelationship.put(id, new Relationship(level));
            }
        }
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    private static boolean isInLineOfSight(class_2350 dir, class_2338 pos, class_1937 level, class_1297 target) {
        class_243 startPos = class_243.method_24953((class_2382)pos).method_1031((double)dir.method_10163().method_10263() * 0.6, (double)dir.method_10163().method_10264() * 0.6, (double)dir.method_10163().method_10260() * 0.6);
        if (target.method_5707(startPos) > 121.0) {
            return false;
        }
        return WiseOakTile.clip(level, startPos, target.method_33571()).method_17783() == class_239.class_240.field_1333;
    }

    public static class_3965 clip(class_1937 level, class_243 startPos, class_243 endPos) {
        class_3959.class_3960 blockGetter = class_3959.class_3960.field_17558;
        class_3959.class_242 fluidGetter = class_3959.class_242.field_1348;
        class_3726 collision = class_3726.method_16194();
        return (class_3965)class_1922.method_17744((class_243)startPos, (class_243)endPos, null, (Null, pos) -> {
            class_2680 blockstate = level.method_8320(pos);
            class_3610 fluidstate = level.method_8316(pos);
            class_265 voxelShape = blockGetter.get(blockstate, (class_1922)level, pos, collision);
            class_3965 blockHitResult = level.method_17745(startPos, endPos, pos, voxelShape, blockstate);
            class_265 fluidShape = fluidGetter.method_17751(fluidstate) ? fluidstate.method_17776((class_1922)level, pos) : class_259.method_1073();
            class_3965 fluidHirResult = fluidShape.method_1092(startPos, endPos, pos);
            double d0 = blockHitResult == null ? Double.MAX_VALUE : startPos.method_1025(blockHitResult.method_17784());
            double d1 = fluidHirResult == null ? Double.MAX_VALUE : startPos.method_1025(fluidHirResult.method_17784());
            return d0 <= d1 ? blockHitResult : fluidHirResult;
        }, arg -> {
            class_243 vec3 = startPos.method_1020(endPos);
            return class_3965.method_17778((class_243)endPos, (class_2350)class_2350.method_10142((double)vec3.field_1352, (double)vec3.field_1351, (double)vec3.field_1350), (class_2338)new class_2338(endPos));
        });
    }
}

