/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen;

import de.keksuccino.drippyloadingscreen.api.PlaceholderTextValueRegistry;
import de.keksuccino.drippyloadingscreen.api.item.CustomizationItemRegistry;
import de.keksuccino.drippyloadingscreen.customization.CustomizationHandler;
import de.keksuccino.drippyloadingscreen.customization.helper.CustomizationHelper;
import de.keksuccino.drippyloadingscreen.customization.items.v2.Items;
import de.keksuccino.drippyloadingscreen.customization.rendering.SimpleTextRenderer;
import de.keksuccino.drippyloadingscreen.customization.rendering.slideshow.SlideshowHandler;
import de.keksuccino.drippyloadingscreen.keybinding.Keybinding;
import de.keksuccino.konkrete.Konkrete;
import de.keksuccino.konkrete.config.Config;
import de.keksuccino.konkrete.localization.Locals;
import java.io.File;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DrippyLoadingScreen
implements ModInitializer {
    public static final String VERSION = "1.6.6";
    public static final String MOD_LOADER = "fabric";
    private static final Logger LOGGER = LogManager.getLogger((String)"drippyloadingscreen/DrippyLoadingScreen");
    public static final File HOME_DIR = new File("config/drippyloadingscreen");
    public static final File CUSTOMIZATION_DIR = new File(HOME_DIR.getPath() + "/customization");
    public static final File SLIDESHOW_DIR = new File(HOME_DIR.getPath() + "/slideshows");
    public static Config config;
    private static boolean fancymenuLoaded;

    public void onInitialize() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            if (!HOME_DIR.exists()) {
                HOME_DIR.mkdirs();
            }
            if (!CUSTOMIZATION_DIR.exists()) {
                CUSTOMIZATION_DIR.mkdirs();
            }
            if (!SLIDESHOW_DIR.exists()) {
                SLIDESHOW_DIR.mkdirs();
            }
            try {
                Class.forName("de.keksuccino.fancymenu.FancyMenu");
                LOGGER.info("[DRIPPY LOADING SCREEN] FancyMenu detected!");
                fancymenuLoaded = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            DrippyLoadingScreen.updateConfig();
            Items.registerItems();
            SlideshowHandler.init();
            CustomizationHandler.init();
            CustomizationHelper.init();
            SimpleTextRenderer.init();
            if (((Boolean)config.getOrDefault("enablekeybinds", (Object)true)).booleanValue()) {
                Keybinding.init();
            }
            Konkrete.addPostLoadingEvent((String)"drippyloadingscreen", this::onClientSetup);
            if (DrippyLoadingScreen.isOptifineCompatibilityMode()) {
                LOGGER.info("Optifine compatibility mode!");
            }
        } else {
            LOGGER.warn("WARNING: Drippy Loading Screen is a client mod and has no effect when loaded on a server!");
        }
    }

    private void onClientSetup() {
        try {
            DrippyLoadingScreen.initLocals();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean isFancyMenuLoaded() {
        return fancymenuLoaded;
    }

    @Deprecated
    public static boolean isOptifineLoaded() {
        return DrippyLoadingScreen.isOptifineCompatibilityMode();
    }

    public static boolean isOptifineCompatibilityMode() {
        return Konkrete.isOptifineLoaded;
    }

    public static void updateConfig() {
        try {
            config = new Config(HOME_DIR.getPath() + "/config.cfg");
            config.registerValue("printwarnings", Boolean.valueOf(true), "logging");
            config.registerValue("editordeleteconfirmation", Boolean.valueOf(true), "layouteditor");
            config.registerValue("showgrid", Boolean.valueOf(false), "layouteditor");
            config.registerValue("gridsize", Integer.valueOf(10), "layouteditor");
            config.registerValue("showcustomizationcontrols", Boolean.valueOf(true), "customization");
            config.registerValue("enablekeybinds", Boolean.valueOf(true), "customization");
            config.registerValue("custom_sound_engine_reloading", Boolean.valueOf(true), "loading_behaviour");
            config.registerValue("uiscale", Float.valueOf(1.0f), "ui");
            config.syncConfig();
            config.clearUnusedValues();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initLocals() {
        String baseresdir = "locals/";
        File f = new File("config/drippyloadingscreen/locals");
        if (!f.exists()) {
            f.mkdirs();
        }
        Locals.copyLocalsFileToDir((class_2960)new class_2960("drippyloadingscreen", baseresdir + "en_us.local"), (String)"en_us", (String)f.getPath());
        Locals.getLocalsFromDir((String)f.getPath());
    }

    public static PlaceholderTextValueRegistry getDynamicValueRegistry() {
        return PlaceholderTextValueRegistry.getInstance();
    }

    public static CustomizationItemRegistry getCustomizationItemRegistry() {
        return CustomizationItemRegistry.getInstance();
    }

    public static boolean isAuudioLoaded() {
        try {
            Class.forName("de.keksuccino.auudio.Auudio");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static {
        fancymenuLoaded = false;
    }
}

