/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.api.item.v2;

import de.keksuccino.drippyloadingscreen.api.item.v2.CustomizationItem;
import de.keksuccino.drippyloadingscreen.api.item.v2.CustomizationItemContainer;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.LayoutEditorScreen;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.elements.LayoutElement;
import de.keksuccino.konkrete.properties.PropertiesSection;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_4587;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class LayoutEditorElement
extends LayoutElement {
    private static final Logger LOGGER = LogManager.getLogger((String)"drippyloadingscreen/LayoutEditorElement");
    public final CustomizationItemContainer parentItemContainer;

    public LayoutEditorElement(@NotNull CustomizationItemContainer parentContainer, @NotNull CustomizationItem customizationItemInstance, boolean destroyable, @NotNull LayoutEditorScreen handler) {
        super(customizationItemInstance, destroyable, handler);
        this.parentItemContainer = parentContainer;
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void render(class_4587 matrix, int mouseX, int mouseY) {
        super.render(matrix, mouseX, mouseY);
    }

    public abstract SimplePropertiesSection serializeItem();

    @Override
    public List<PropertiesSection> getProperties() {
        ArrayList<PropertiesSection> l = new ArrayList<PropertiesSection>();
        SimplePropertiesSection sec = this.serializeItem();
        if (sec == null) {
            sec = new SimplePropertiesSection();
        }
        if (sec.hasEntry("action")) {
            LOGGER.warn("WARNING: Entry key 'action' for serialized customization item instances is reserved by the system. Overriding entry!");
            sec.removeEntry("action");
        }
        sec.addEntry("action", "custom_layout_element:" + this.parentItemContainer.getIdentifier());
        sec.addEntry("actionid", this.object.getActionId());
        if (this.object.delayAppearance) {
            sec.addEntry("delayappearance", "true");
            sec.addEntry("delayappearanceeverytime", "" + this.object.delayAppearanceEverytime);
            sec.addEntry("delayappearanceseconds", "" + this.object.delayAppearanceSec);
            if (this.object.fadeIn) {
                sec.addEntry("fadein", "true");
                sec.addEntry("fadeinspeed", "" + this.object.fadeInSpeed);
            }
        }
        sec.addEntry("x", "" + this.object.posX);
        sec.addEntry("y", "" + this.object.posY);
        sec.addEntry("orientation", this.object.orientation);
        if (this.object.orientation.equals("element") && this.object.orientationElementIdentifier != null) {
            sec.addEntry("orientation_element", this.object.orientationElementIdentifier);
        }
        if (this.stretchX) {
            sec.addEntry("x", "0");
            sec.addEntry("width", "%guiwidth%");
        } else {
            sec.addEntry("x", "" + this.object.posX);
            sec.addEntry("width", "" + this.object.width);
        }
        if (this.stretchY) {
            sec.addEntry("y", "0");
            sec.addEntry("height", "%guiheight%");
        } else {
            sec.addEntry("y", "" + this.object.posY);
            sec.addEntry("height", "" + this.object.height);
        }
        l.add(sec);
        return l;
    }

    public class SimplePropertiesSection
    extends PropertiesSection {
        public SimplePropertiesSection() {
            super("customization");
        }
    }
}

