/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.helper.editor;

import com.google.common.io.Files;
import de.keksuccino.drippyloadingscreen.DrippyLoadingScreen;
import de.keksuccino.drippyloadingscreen.api.item.CustomizationItemContainer;
import de.keksuccino.drippyloadingscreen.api.item.CustomizationItemRegistry;
import de.keksuccino.drippyloadingscreen.customization.CustomizationHandler;
import de.keksuccino.drippyloadingscreen.customization.CustomizationPropertiesHandler;
import de.keksuccino.drippyloadingscreen.customization.helper.CustomizationHelperScreen;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.AutoScalingPopup;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.LayoutEditorScreen;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.elements.LayoutElement;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.elements.custombars.LayoutCustomProgressBar;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.elements.vanilla.VanillaLayoutSplashElement;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.UIBase;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.content.CustomizationButton;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.content.FHContextMenu;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.content.MenuBar;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.popup.ChooseFilePopup;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.popup.DynamicValueInputPopup;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.popup.FHTextInputPopup;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.popup.FHYesNoPopup;
import de.keksuccino.drippyloadingscreen.customization.items.ShapeCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.custombars.CustomProgressBarCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.rendering.slideshow.SlideshowHandler;
import de.keksuccino.drippyloadingscreen.utils.WebUtils;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedImageButton;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.gui.screens.popup.TextInputPopup;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.resources.TextureHandler;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class LayoutEditorUI
extends UIBase {
    public MenuBar bar;
    public LayoutEditorScreen parent;
    protected int tick = 0;
    protected static final class_2960 CLOSE_BUTTON_TEXTURE = new class_2960("drippyloadingscreen", "close_btn.png");

    public LayoutEditorUI(LayoutEditorScreen parent) {
        this.parent = parent;
        this.updateUI();
    }

    public void updateUI() {
        try {
            boolean extended = true;
            if (this.bar != null) {
                extended = this.bar.isExtended();
            }
            this.bar = new MenuBar();
            this.bar.setExtended(extended);
            FHContextMenu layoutMenu = new FHContextMenu();
            layoutMenu.setAutoclose(true);
            this.bar.addChild(layoutMenu, "fm.editor.ui.tab.layout", MenuBar.ElementAlignment.LEFT);
            AdvancedButton newLayoutButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.editor.ui.layout.new", (String[])new String[0]), true, press -> this.displayUnsavedWarning(call -> {
                if (call.booleanValue()) {
                    class_310.method_1551().method_1507((class_437)new LayoutEditorScreen());
                }
            }));
            layoutMenu.addContent(newLayoutButton);
            OpenLayoutContextMenu openLayoutMenu = new OpenLayoutContextMenu(this);
            openLayoutMenu.setAutoclose(true);
            layoutMenu.addChild(openLayoutMenu);
            AdvancedButton openLayoutButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.editor.ui.layout.open", (String[])new String[0]), true, press -> {
                openLayoutMenu.setParentButton((AdvancedButton)press);
                openLayoutMenu.openMenuAt(0, press.field_22761);
            });
            layoutMenu.addContent(openLayoutButton);
            AdvancedButton layoutSaveButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.editor.ui.layout.save", (String[])new String[0]), true, press -> this.parent.saveLayout());
            layoutMenu.addContent(layoutSaveButton);
            AdvancedButton layoutSaveAsButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.editor.ui.layout.saveas", (String[])new String[0]), true, press -> this.parent.saveLayoutAs());
            layoutMenu.addContent(layoutSaveAsButton);
            LayoutPropertiesContextMenu layoutPropertiesMenu = new LayoutPropertiesContextMenu(this.parent, false);
            layoutPropertiesMenu.setAutoclose(true);
            layoutMenu.addChild(layoutPropertiesMenu);
            AdvancedButton layoutPropertiesButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.editor.ui.layout.properties", (String[])new String[0]), true, press -> {
                layoutPropertiesMenu.setParentButton((AdvancedButton)press);
                layoutPropertiesMenu.openMenuAt(0, press.field_22761);
            });
            layoutMenu.addContent(layoutPropertiesButton);
            AdvancedButton exitButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.editor.ui.exit", (String[])new String[0]), true, press -> this.closeEditor());
            layoutMenu.addContent(exitButton);
            CustomizationButton layoutTab = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.editor.ui.layout", (String[])new String[0]), true, press -> {
                layoutMenu.setParentButton((AdvancedButton)press);
                layoutMenu.openMenuAt(press.field_22760, press.field_22761 + press.method_25364());
            });
            this.bar.addElement(layoutTab, "fm.editor.ui.tab.layout", MenuBar.ElementAlignment.LEFT, false);
            FHContextMenu editMenu = new FHContextMenu();
            editMenu.setAutoclose(true);
            this.bar.addChild(editMenu, "fm.editor.ui.tab.edit", MenuBar.ElementAlignment.LEFT);
            AdvancedButton undoButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.editor.ui.edit.undo", (String[])new String[0]), true, press -> {
                this.parent.history.stepBack();
                try {
                    ((LayoutEditorScreen)class_310.method_1551().field_1755).ui.bar.getChild("fm.editor.ui.tab.edit").openMenuAt(editMenu.getX(), editMenu.getY());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            editMenu.addContent(undoButton);
            AdvancedButton redoButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.editor.ui.edit.redo", (String[])new String[0]), true, press -> {
                this.parent.history.stepForward();
                try {
                    ((LayoutEditorScreen)class_310.method_1551().field_1755).ui.bar.getChild("fm.editor.ui.tab.edit").openMenuAt(editMenu.getX(), editMenu.getY());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            editMenu.addContent(redoButton);
            editMenu.addSeparator();
            AdvancedButton copyButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.editor.ui.edit.copy", (String[])new String[0]), true, press -> this.parent.copySelectedElements());
            editMenu.addContent(copyButton);
            AdvancedButton pasteButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.editor.ui.edit.paste", (String[])new String[0]), true, press -> this.parent.pasteElements());
            editMenu.addContent(pasteButton);
            CustomizationButton editTab = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.editor.ui.edit", (String[])new String[0]), true, press -> {
                editMenu.setParentButton((AdvancedButton)press);
                editMenu.openMenuAt(press.field_22760, press.field_22761 + press.method_25364());
            });
            this.bar.addElement(editTab, "fm.editor.ui.tab.edit", MenuBar.ElementAlignment.LEFT, false);
            FHContextMenu elementMenu = new FHContextMenu();
            elementMenu.setAutoclose(true);
            this.bar.addChild(elementMenu, "fm.editor.ui.tab.element", MenuBar.ElementAlignment.LEFT);
            NewElementContextMenu newElementMenu = new NewElementContextMenu(this.parent);
            newElementMenu.setAutoclose(true);
            elementMenu.addChild(newElementMenu);
            AdvancedButton newElementButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.editor.ui.element.new", (String[])new String[0]), true, press -> {
                newElementMenu.setParentButton((AdvancedButton)press);
                newElementMenu.openMenuAt(0, press.field_22761);
            });
            elementMenu.addContent(newElementButton);
            HiddenVanillaElementsContextMenu hiddenVanillaMenu = new HiddenVanillaElementsContextMenu(this.parent);
            hiddenVanillaMenu.setAutoclose(true);
            elementMenu.addChild(hiddenVanillaMenu);
            AdvancedButton hiddenVanillaButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.editor.elements.vanilla.managedeleted", (String[])new String[0]), true, press -> {
                hiddenVanillaMenu.setParentButton((AdvancedButton)press);
                hiddenVanillaMenu.openMenuAt(0, press.field_22761);
            });
            elementMenu.addContent(hiddenVanillaButton);
            CustomizationButton elementTab = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.editor.ui.element", (String[])new String[0]), true, press -> {
                elementMenu.setParentButton((AdvancedButton)press);
                elementMenu.openMenuAt(press.field_22760, press.field_22761 + press.method_25364());
            });
            this.bar.addElement(elementTab, "fm.editor.ui.tab.element", MenuBar.ElementAlignment.LEFT, false);
            AdvancedImageButton exitEditorButtonTab = new AdvancedImageButton(20, 20, 0, 0, CLOSE_BUTTON_TEXTURE, true, press -> this.closeEditor()){

                public void method_25394(class_4587 matrix, int mouseX, int mouseY, float partialTicks) {
                    this.field_22758 = this.field_22759;
                    super.method_25394(matrix, mouseX, mouseY, partialTicks);
                }
            };
            exitEditorButtonTab.ignoreLeftMouseDownClickBlock = true;
            exitEditorButtonTab.ignoreBlockedInput = true;
            exitEditorButtonTab.enableRightclick = true;
            exitEditorButtonTab.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.editor.ui.exit.desc", (String[])new String[0]), (String)"%n%"));
            this.bar.addElement((AdvancedButton)exitEditorButtonTab, "fm.editor.ui.tab.exit", MenuBar.ElementAlignment.RIGHT, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void render(class_4587 matrix, class_437 screen) {
        try {
            if (this.bar != null && !PopupHandler.isPopupActive() && screen instanceof LayoutEditorScreen) {
                this.bar.render(matrix, screen);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void displayUnsavedWarning(Consumer<Boolean> callback) {
        PopupHandler.displayPopup((Popup)new FHYesNoPopup(300, new Color(0, 0, 0, 0), 240, callback, Locals.localize((String)"drippyloadingscreen.helper.editor.ui.unsavedwarning", (String[])new String[0])));
    }

    public void closeEditor() {
        this.displayUnsavedWarning(call -> {
            if (call.booleanValue()) {
                LayoutEditorScreen.isActive = false;
                CustomizationHandler.stopSounds();
                CustomizationHandler.resetSounds();
                CustomizationHandler.reloadSystem();
                class_310.method_1551().method_22683().method_15997((double)class_310.method_1551().method_22683().method_4476(class_310.method_1551().field_1690.field_1868, class_310.method_1551().method_1573()));
                this.parent.field_22790 = class_310.method_1551().method_22683().method_4502();
                this.parent.field_22789 = class_310.method_1551().method_22683().method_4486();
                class_310.method_1551().method_1507((class_437)new CustomizationHelperScreen());
            }
        });
    }

    private static class OpenLayoutContextMenu
    extends FHContextMenu {
        private LayoutEditorUI ui;

        public OpenLayoutContextMenu(LayoutEditorUI ui) {
            this.ui = ui;
        }

        @Override
        public void openMenuAt(int x, int y, int screenWidth, int screenHeight) {
            List<PropertiesSet> disabled;
            this.content.clear();
            List<PropertiesSet> enabled = CustomizationPropertiesHandler.getProperties();
            if (!enabled.isEmpty()) {
                for (PropertiesSet s : enabled) {
                    List secs = s.getPropertiesOfType("customization-meta");
                    if (secs.isEmpty()) {
                        secs = s.getPropertiesOfType("type-meta");
                    }
                    if (secs.isEmpty()) continue;
                    String name = "<missing name>";
                    PropertiesSection meta = (PropertiesSection)secs.get(0);
                    File f = new File(meta.getEntryValue("path"));
                    if (!f.isFile()) continue;
                    name = Files.getNameWithoutExtension((String)f.getName());
                    int totalactions = s.getProperties().size() - 1;
                    AdvancedButton layoutEntryBtn = new AdvancedButton(0, 0, 0, 0, "\u00a7a" + name, press -> this.ui.displayUnsavedWarning(call -> CustomizationHandler.editLayout(f)));
                    layoutEntryBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.buttons.customization.managelayouts.layout.btndesc", (String[])new String[]{Locals.localize((String)"drippyloadingscreen.helper.buttons.customization.managelayouts.enabled", (String[])new String[0]), "" + totalactions}), (String)"%n%"));
                    this.addContent(layoutEntryBtn);
                }
            }
            if (!(disabled = CustomizationPropertiesHandler.getDisabledProperties()).isEmpty()) {
                for (PropertiesSet s : disabled) {
                    List secs = s.getPropertiesOfType("customization-meta");
                    if (secs.isEmpty()) {
                        secs = s.getPropertiesOfType("type-meta");
                    }
                    if (secs.isEmpty()) continue;
                    String name = "<missing name>";
                    PropertiesSection meta = (PropertiesSection)secs.get(0);
                    File f = new File(meta.getEntryValue("path"));
                    if (!f.isFile()) continue;
                    name = Files.getNameWithoutExtension((String)f.getName());
                    int totalactions = s.getProperties().size() - 1;
                    AdvancedButton layoutEntryBtn = new AdvancedButton(0, 0, 0, 0, "\u00a7c" + name, press -> this.ui.displayUnsavedWarning(call -> CustomizationHandler.editLayout(f)));
                    layoutEntryBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.buttons.customization.managelayouts.layout.btndesc", (String[])new String[]{Locals.localize((String)"drippyloadingscreen.helper.buttons.customization.managelayouts.disabled", (String[])new String[0]), "" + totalactions}), (String)"%n%"));
                    this.addContent(layoutEntryBtn);
                }
            }
            if (enabled.isEmpty() && disabled.isEmpty()) {
                AdvancedButton emptyBtn = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.creator.empty", (String[])new String[0]), press -> {});
                this.addContent(emptyBtn);
            }
            super.openMenuAt(x, y, screenWidth, screenHeight);
        }
    }

    public static class LayoutPropertiesContextMenu
    extends FHContextMenu {
        private LayoutEditorScreen parent;
        private AdvancedButton renderingOrderBackgroundButton;
        private AdvancedButton renderingOrderForegroundButton;
        private boolean isRightclickOpened;

        public LayoutPropertiesContextMenu(LayoutEditorScreen parent, boolean openedByRightclick) {
            this.parent = parent;
            this.isRightclickOpened = openedByRightclick;
        }

        @Override
        public void openMenuAt(int x, int y, int screenWidth, int screenHeight) {
            this.content.clear();
            String randomModeString = Locals.localize((String)"drippyloadingscreen.helper.editor.layoutoptions.randommode.on", (String[])new String[0]);
            if (!this.parent.randomMode) {
                randomModeString = Locals.localize((String)"drippyloadingscreen.helper.editor.layoutoptions.randommode.off", (String[])new String[0]);
            }
            AdvancedButton randomModeButton = new AdvancedButton(0, 0, 0, 16, randomModeString, true, press -> {
                if (this.parent.randomMode) {
                    ((AdvancedButton)press).setMessage(Locals.localize((String)"drippyloadingscreen.helper.editor.layoutoptions.randommode.off", (String[])new String[0]));
                    this.parent.randomMode = false;
                } else {
                    ((AdvancedButton)press).setMessage(Locals.localize((String)"drippyloadingscreen.helper.editor.layoutoptions.randommode.on", (String[])new String[0]));
                    this.parent.randomMode = true;
                }
            });
            randomModeButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.editor.layoutoptions.randommode.btn.desc", (String[])new String[0]), (String)"%n%"));
            this.addContent(randomModeButton);
            AdvancedButton randomModeGroupButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.editor.layoutoptions.randommode.setgroup", (String[])new String[0]), true, press -> {
                FHTextInputPopup pop = new FHTextInputPopup(new Color(0, 0, 0, 0), Locals.localize((String)"drippyloadingscreen.helper.editor.layoutoptions.randommode.setgroup", (String[])new String[0]), CharacterFilter.getIntegerCharacterFiler(), 240, call -> {
                    if (call != null) {
                        if (!MathUtils.isInteger((String)call)) {
                            call = "1";
                        }
                        if (!call.equalsIgnoreCase(this.parent.randomGroup)) {
                            this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                        }
                        this.parent.randomGroup = call;
                    }
                });
                if (this.parent.randomGroup != null) {
                    pop.setText(this.parent.randomGroup);
                }
                PopupHandler.displayPopup((Popup)pop);
            }){

                public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
                    this.field_22763 = parent.randomMode;
                    super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
                }
            };
            randomModeGroupButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.editor.layoutoptions.randommode.setgroup.btn.desc", (String[])new String[0]), (String)"%n%"));
            this.addContent(randomModeGroupButton);
            String randomModeFirstTimeString = Locals.localize((String)"drippyloadingscreen.helper.editor.layoutoptions.randommode.onlyfirsttime.on", (String[])new String[0]);
            if (!this.parent.randomOnlyFirstTime) {
                randomModeFirstTimeString = Locals.localize((String)"drippyloadingscreen.helper.editor.layoutoptions.randommode.onlyfirsttime.off", (String[])new String[0]);
            }
            AdvancedButton randomModeFirstTimeButton = new AdvancedButton(0, 0, 0, 16, randomModeFirstTimeString, true, press -> {
                if (this.parent.randomOnlyFirstTime) {
                    ((AdvancedButton)press).setMessage(Locals.localize((String)"drippyloadingscreen.helper.editor.layoutoptions.randommode.onlyfirsttime.off", (String[])new String[0]));
                    this.parent.randomOnlyFirstTime = false;
                } else {
                    ((AdvancedButton)press).setMessage(Locals.localize((String)"drippyloadingscreen.helper.editor.layoutoptions.randommode.onlyfirsttime.on", (String[])new String[0]));
                    this.parent.randomOnlyFirstTime = true;
                }
            }){

                public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
                    this.field_22763 = parent.randomMode;
                    super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
                }
            };
            randomModeFirstTimeButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.editor.layoutoptions.randommode.onlyfirsttime.btn.desc", (String[])new String[0]), (String)"%n%"));
            this.addContent(randomModeFirstTimeButton);
            this.addSeparator();
            FHContextMenu renderingOrderMenu = new FHContextMenu();
            renderingOrderMenu.setAutoclose(true);
            this.addChild(renderingOrderMenu);
            this.renderingOrderBackgroundButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.creator.layoutoptions.renderorder.background", (String[])new String[0]), true, press -> {
                ((AdvancedButton)press).setMessage("\u00a7a" + Locals.localize((String)"drippyloadingscreen.helper.creator.layoutoptions.renderorder.background", (String[])new String[0]));
                this.renderingOrderForegroundButton.setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.layoutoptions.renderorder.foreground", (String[])new String[0]));
                if (!this.parent.renderorder.equals("background")) {
                    this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                }
                this.parent.renderorder = "background";
            });
            renderingOrderMenu.addContent(this.renderingOrderBackgroundButton);
            this.renderingOrderForegroundButton = new AdvancedButton(0, 0, 0, 16, "\u00a7a" + Locals.localize((String)"drippyloadingscreen.helper.creator.layoutoptions.renderorder.foreground", (String[])new String[0]), true, press -> {
                ((AdvancedButton)press).setMessage("\u00a7a" + Locals.localize((String)"drippyloadingscreen.helper.creator.layoutoptions.renderorder.foreground", (String[])new String[0]));
                this.renderingOrderBackgroundButton.setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.layoutoptions.renderorder.background", (String[])new String[0]));
                if (!this.parent.renderorder.equals("foreground")) {
                    this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                }
                this.parent.renderorder = "foreground";
            });
            renderingOrderMenu.addContent(this.renderingOrderForegroundButton);
            if (this.parent.renderorder.equals("background")) {
                this.renderingOrderForegroundButton.setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.layoutoptions.renderorder.foreground", (String[])new String[0]));
                this.renderingOrderBackgroundButton.setMessage("\u00a7a" + Locals.localize((String)"drippyloadingscreen.helper.creator.layoutoptions.renderorder.background", (String[])new String[0]));
            }
            AdvancedButton renderingOrderButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.creator.layoutoptions.renderorder", (String[])new String[0]), true, press -> {
                renderingOrderMenu.setParentButton((AdvancedButton)press);
                renderingOrderMenu.openMenuAt(0, press.field_22761, screenWidth, screenHeight);
            });
            renderingOrderButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.editor.properties.renderingorder.desc", (String[])new String[0]), (String)"%n%"));
            this.addContent(renderingOrderButton);
            AdvancedButton requiredModsButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.creator.layoutoptions.requiredmods", (String[])new String[0]), true, press -> {
                FHTextInputPopup p = new FHTextInputPopup(new Color(0, 0, 0, 0), "\u00a7l" + Locals.localize((String)"drippyloadingscreen.helper.creator.layoutoptions.requiredmods.desc", (String[])new String[0]), null, 240, call -> {
                    if (call != null) {
                        if (this.parent.requiredmods != call) {
                            this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                        }
                        this.parent.requiredmods = call;
                    }
                });
                if (this.parent.requiredmods != null) {
                    p.setText(this.parent.requiredmods);
                }
                PopupHandler.displayPopup((Popup)p);
            });
            this.addContent(requiredModsButton);
            FHContextMenu mcVersionMenu = new FHContextMenu();
            mcVersionMenu.setAutoclose(true);
            this.addChild(mcVersionMenu);
            AdvancedButton minMcVersionButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.creator.layoutoptions.version.minimum", (String[])new String[0]), true, press -> {
                FHTextInputPopup p = new FHTextInputPopup(new Color(0, 0, 0, 0), "\u00a7l" + Locals.localize((String)"drippyloadingscreen.helper.creator.layoutoptions.version.minimum.mc", (String[])new String[0]), null, 240, call -> {
                    if (call != null) {
                        if (this.parent.minimumMC != call) {
                            this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                        }
                        this.parent.minimumMC = call;
                    }
                });
                if (this.parent.minimumMC != null) {
                    p.setText(this.parent.minimumMC);
                }
                PopupHandler.displayPopup((Popup)p);
            });
            mcVersionMenu.addContent(minMcVersionButton);
            AdvancedButton maxMcVersionButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.creator.layoutoptions.version.maximum", (String[])new String[0]), true, press -> {
                FHTextInputPopup p = new FHTextInputPopup(new Color(0, 0, 0, 0), "\u00a7l" + Locals.localize((String)"drippyloadingscreen.helper.creator.layoutoptions.version.maximum.mc", (String[])new String[0]), null, 240, call -> {
                    if (call != null) {
                        if (this.parent.maximumMC != call) {
                            this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                        }
                        this.parent.maximumMC = call;
                    }
                });
                if (this.parent.maximumMC != null) {
                    p.setText(this.parent.maximumMC);
                }
                PopupHandler.displayPopup((Popup)p);
            });
            mcVersionMenu.addContent(maxMcVersionButton);
            AdvancedButton mcVersionButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.creator.layoutoptions.version.mc", (String[])new String[0]), true, press -> {
                mcVersionMenu.setParentButton((AdvancedButton)press);
                mcVersionMenu.openMenuAt(0, press.field_22761, screenWidth, screenHeight);
            });
            this.addContent(mcVersionButton);
            FHContextMenu fmVersionMenu = new FHContextMenu();
            fmVersionMenu.setAutoclose(true);
            this.addChild(fmVersionMenu);
            AdvancedButton minFmVersionButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.creator.layoutoptions.version.minimum", (String[])new String[0]), true, press -> {
                FHTextInputPopup p = new FHTextInputPopup(new Color(0, 0, 0, 0), "\u00a7l" + Locals.localize((String)"drippyloadingscreen.helper.creator.layoutoptions.version.minimum.fh", (String[])new String[0]), null, 240, call -> {
                    if (call != null) {
                        if (this.parent.minimumDL != call) {
                            this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                        }
                        this.parent.minimumDL = call;
                    }
                });
                if (this.parent.minimumDL != null) {
                    p.setText(this.parent.minimumDL);
                }
                PopupHandler.displayPopup((Popup)p);
            });
            fmVersionMenu.addContent(minFmVersionButton);
            AdvancedButton maxFmVersionButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.creator.layoutoptions.version.maximum", (String[])new String[0]), true, press -> {
                FHTextInputPopup p = new FHTextInputPopup(new Color(0, 0, 0, 0), "\u00a7l" + Locals.localize((String)"drippyloadingscreen.helper.creator.layoutoptions.version.maximum.dl", (String[])new String[0]), null, 240, call -> {
                    if (call != null) {
                        if (this.parent.maximumDL != call) {
                            this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                        }
                        this.parent.maximumDL = call;
                    }
                });
                if (this.parent.maximumDL != null) {
                    p.setText(this.parent.maximumDL);
                }
                PopupHandler.displayPopup((Popup)p);
            });
            fmVersionMenu.addContent(maxFmVersionButton);
            AdvancedButton fmVersionButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.creator.layoutoptions.version.dl", (String[])new String[0]), true, press -> {
                fmVersionMenu.setParentButton((AdvancedButton)press);
                fmVersionMenu.openMenuAt(0, press.field_22761, screenWidth, screenHeight);
            });
            this.addContent(fmVersionButton);
            this.addSeparator();
            AdvancedButton backgroundColorButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.editor.backgroundcolor", (String[])new String[0]), press -> {
                FHTextInputPopup pop = new FHTextInputPopup(new Color(0, 0, 0, 0), Locals.localize((String)"drippyloadingscreen.helper.editor.backgroundcolor", (String[])new String[0]), null, 240, call -> {
                    if (call != null) {
                        if (!call.equals(this.parent.splashLayer.customBackgroundHex)) {
                            this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                        }
                        this.parent.splashLayer.customBackgroundHex = call;
                    }
                });
                if (this.parent.splashLayer.customBackgroundHex != null) {
                    pop.setText(this.parent.splashLayer.customBackgroundHex);
                }
                PopupHandler.displayPopup((Popup)pop);
            });
            backgroundColorButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.editor.backgroundcolor.btn.desc", (String[])new String[0]), (String)"%n%"));
            this.addContent(backgroundColorButton);
            AdvancedButton backgroundImageButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.editor.backgroundimage", (String[])new String[0]), true, press -> {
                ChooseFilePopup pop = new ChooseFilePopup(call -> {
                    if (call != null) {
                        if (!call.equals(this.parent.splashLayer.backgroundImagePath)) {
                            this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                        }
                        if (call.replace(" ", "").equals("")) {
                            this.parent.splashLayer.backgroundImagePath = null;
                            this.parent.splashLayer.backgroundImageSource = null;
                            this.parent.splashLayer.backgroundImage = null;
                        } else {
                            File f = new File((String)call);
                            if (f.exists() && f.isFile() && (f.getPath().toLowerCase().endsWith(".jpg") || f.getPath().toLowerCase().endsWith(".jpeg") || f.getPath().toLowerCase().endsWith(".png"))) {
                                this.parent.splashLayer.backgroundImagePath = call;
                                ExternalTextureResourceLocation tex = TextureHandler.getResource((String)call);
                                tex.loadTexture();
                                this.parent.splashLayer.backgroundImageSource = tex;
                                this.parent.splashLayer.backgroundImage = tex.getResourceLocation();
                            }
                        }
                    }
                }, "jpg", "jpeg", "png");
                if (this.parent.splashLayer.backgroundImagePath != null) {
                    pop.setText(this.parent.splashLayer.backgroundImagePath);
                }
                PopupHandler.displayPopup((Popup)pop);
            });
            backgroundImageButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.editor.backgroundimage.btn.desc", (String[])new String[0]), (String)"%n%"));
            this.addContent(backgroundImageButton);
            String backgroundAspectLabel = Locals.localize((String)"drippyloadingscreen.helper.editor.layoutoptions.backgroundoptions.keepaspect.on", (String[])new String[0]);
            if (!this.parent.splashLayer.keepBackgroundAspectRatio) {
                backgroundAspectLabel = Locals.localize((String)"drippyloadingscreen.helper.editor.layoutoptions.backgroundoptions.keepaspect.off", (String[])new String[0]);
            }
            AdvancedButton backgroundAspectButton = new AdvancedButton(0, 0, 0, 16, backgroundAspectLabel, true, press -> {
                if (this.parent.splashLayer.keepBackgroundAspectRatio) {
                    this.parent.splashLayer.keepBackgroundAspectRatio = false;
                    ((AdvancedButton)press).setMessage(Locals.localize((String)"drippyloadingscreen.helper.editor.layoutoptions.backgroundoptions.keepaspect.off", (String[])new String[0]));
                } else {
                    this.parent.splashLayer.keepBackgroundAspectRatio = true;
                    ((AdvancedButton)press).setMessage(Locals.localize((String)"drippyloadingscreen.helper.editor.layoutoptions.backgroundoptions.keepaspect.on", (String[])new String[0]));
                }
            });
            this.addContent(backgroundAspectButton);
            this.addSeparator();
            AdvancedButton forceScaleButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.editor.forcescale", (String[])new String[0]), press -> {
                FHTextInputPopup pop = new FHTextInputPopup(new Color(0, 0, 0, 0), Locals.localize((String)"drippyloadingscreen.helper.editor.forcescale", (String[])new String[0]), CharacterFilter.getIntegerCharacterFiler(), 240, call -> {
                    if (call != null) {
                        if (!call.replace(" ", "").equals("")) {
                            if (MathUtils.isInteger((String)call)) {
                                int newScale = Integer.parseInt(call);
                                if (newScale != this.parent.scale) {
                                    this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                                }
                                this.parent.scale = newScale;
                            }
                        } else {
                            if (this.parent.scale != 0) {
                                this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                            }
                            this.parent.scale = 0;
                        }
                        this.parent.method_25426();
                    }
                });
                pop.setText("" + this.parent.scale);
                PopupHandler.displayPopup((Popup)pop);
            });
            forceScaleButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.editor.forcescale.btn.desc", (String[])new String[0]), (String)"%n%"));
            this.addContent(forceScaleButton);
            String autoScalingLabel = Locals.localize((String)"drippyloadingscreen.helper.editor.properties.autoscale.off", (String[])new String[0]);
            if (this.parent.autoScalingWidth != 0 && this.parent.autoScalingHeight != 0) {
                autoScalingLabel = Locals.localize((String)"drippyloadingscreen.helper.editor.properties.autoscale.on", (String[])new String[0]);
            }
            AdvancedButton autoScalingButton = new AdvancedButton(0, 0, 0, 16, autoScalingLabel, true, press -> {
                if (this.parent.autoScalingWidth != 0 && this.parent.autoScalingHeight != 0) {
                    ((AdvancedButton)press).setMessage(Locals.localize((String)"drippyloadingscreen.helper.editor.properties.autoscale.off", (String[])new String[0]));
                    this.parent.autoScalingWidth = 0;
                    this.parent.autoScalingHeight = 0;
                    this.parent.method_25423(class_310.method_1551(), class_310.method_1551().method_22683().method_4486(), class_310.method_1551().method_22683().method_4502());
                } else {
                    PopupHandler.displayPopup((Popup)new AutoScalingPopup(this.parent, call -> {
                        if (call.booleanValue()) {
                            ((AdvancedButton)press).setMessage(Locals.localize((String)"drippyloadingscreen.helper.editor.properties.autoscale.on", (String[])new String[0]));
                            this.parent.method_25423(class_310.method_1551(), class_310.method_1551().method_22683().method_4486(), class_310.method_1551().method_22683().method_4502());
                        }
                    }));
                }
            }){

                public void method_25394(class_4587 p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                    if (parent.scale != 0) {
                        this.field_22763 = true;
                        this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.editor.properties.autoscale.btn.desc", (String[])new String[0]), (String)"%n%"));
                    } else {
                        this.field_22763 = false;
                        this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.editor.properties.autoscale.forced_scale_needed", (String[])new String[0]), (String)"%n%"));
                    }
                    super.method_25394(p_93657_, p_93658_, p_93659_, p_93660_);
                }
            };
            this.addContent(autoScalingButton);
            String fadeOutLabel = Locals.localize((String)"drippyloadingscreen.helper.editor.fadeout.on", (String[])new String[0]);
            if (!this.parent.fadeOut) {
                fadeOutLabel = Locals.localize((String)"drippyloadingscreen.helper.editor.fadeout.off", (String[])new String[0]);
            }
            AdvancedButton fadeOutButton = new AdvancedButton(0, 0, 0, 16, fadeOutLabel, press -> {
                if (this.parent.fadeOut) {
                    ((AdvancedButton)press).setMessage(Locals.localize((String)"drippyloadingscreen.helper.editor.fadeout.off", (String[])new String[0]));
                    this.parent.fadeOut = false;
                } else {
                    ((AdvancedButton)press).setMessage(Locals.localize((String)"drippyloadingscreen.helper.editor.fadeout.on", (String[])new String[0]));
                    this.parent.fadeOut = true;
                }
            });
            fadeOutButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.editor.fadeout.btn.desc", (String[])new String[0]), (String)"%n%"));
            this.addContent(fadeOutButton);
            if (this.isRightclickOpened) {
                this.addSeparator();
                AdvancedButton pasteButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.editor.ui.edit.paste", (String[])new String[0]), press -> this.parent.pasteElements());
                this.addContent(pasteButton);
                NewElementContextMenu newElementMenu = new NewElementContextMenu(this.parent);
                newElementMenu.setAutoclose(true);
                this.addChild(newElementMenu);
                AdvancedButton newElementButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.editor.ui.layoutproperties.newelement", (String[])new String[0]), press -> {
                    newElementMenu.setParentButton((AdvancedButton)press);
                    newElementMenu.openMenuAt(0, press.field_22761, screenWidth, screenHeight);
                });
                this.addContent(newElementButton);
            }
            super.openMenuAt(x, y, screenWidth, screenHeight);
        }
    }

    public static class NewElementContextMenu
    extends FHContextMenu {
        private LayoutEditorScreen parent;

        public NewElementContextMenu(LayoutEditorScreen parent) {
            this.parent = parent;
        }

        @Override
        public void openMenuAt(int x, int y, int screenWidth, int screenHeight) {
            this.content.clear();
            AdvancedButton imageButton = new AdvancedButton(0, 0, 0, 20, Locals.localize((String)"drippyloadingscreen.helper.creator.add.image", (String[])new String[0]), press -> PopupHandler.displayPopup((Popup)new ChooseFilePopup(this.parent::addTexture, "jpg", "jpeg", "png", "gif")));
            this.addContent(imageButton);
            AdvancedButton webImageButton = new AdvancedButton(0, 0, 0, 20, Locals.localize((String)"drippyloadingscreen.helper.creator.add.webimage", (String[])new String[0]), press -> PopupHandler.displayPopup((Popup)new DynamicValueInputPopup(new Color(0, 0, 0, 0), "\u00a7l" + Locals.localize((String)"drippyloadingscreen.helper.creator.web.enterurl", (String[])new String[0]), null, 240, this.parent::addWebTexture)));
            this.addContent(webImageButton);
            AdvancedButton textButton = new AdvancedButton(0, 0, 0, 20, Locals.localize((String)"drippyloadingscreen.helper.creator.add.text", (String[])new String[0]), press -> PopupHandler.displayPopup((Popup)new DynamicValueInputPopup(new Color(0, 0, 0, 0), "\u00a7l" + Locals.localize((String)"drippyloadingscreen.helper.creator.add.text.newtext", (String[])new String[0]) + ":", null, 240, this.parent::addText)));
            textButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.editor.elements.text.onlybasicchars", (String[])new String[0]), (String)"%n%"));
            this.addContent(textButton);
            AdvancedButton webTextButton = new AdvancedButton(0, 0, 0, 20, Locals.localize((String)"drippyloadingscreen.helper.creator.add.webtext", (String[])new String[0]), press -> PopupHandler.displayPopup((Popup)new DynamicValueInputPopup(new Color(0, 0, 0, 0), "\u00a7l" + Locals.localize((String)"drippyloadingscreen.helper.creator.web.enterurl", (String[])new String[0]), null, 240, this.parent::addWebText)));
            this.addContent(webTextButton);
            FHContextMenu splashMenu = new FHContextMenu();
            splashMenu.setAutoclose(true);
            this.addChild(splashMenu);
            AdvancedButton singleSplashButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.creator.add.splash.single", (String[])new String[0]), true, press -> PopupHandler.displayPopup((Popup)new DynamicValueInputPopup(new Color(0, 0, 0, 0), Locals.localize((String)"drippyloadingscreen.helper.creator.add.splash.single.popup.headline", (String[])new String[0]), null, 240, this.parent::addSingleSplashText)));
            singleSplashButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.creator.add.splash.single.btn.desc", (String[])new String[0]), (String)"%n%"));
            splashMenu.addContent(singleSplashButton);
            AdvancedButton multiSplashButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.creator.add.splash.multi", (String[])new String[0]), true, press -> PopupHandler.displayPopup((Popup)new ChooseFilePopup(this.parent::addMultiSplashText, "txt")));
            multiSplashButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.creator.add.splash.multi.btn.desc", (String[])new String[0]), (String)"%n%"));
            splashMenu.addContent(multiSplashButton);
            AdvancedButton splashButton = new AdvancedButton(0, 0, 0, 20, Locals.localize((String)"drippyloadingscreen.helper.creator.add.splash", (String[])new String[0]), press -> {
                splashMenu.setParentButton((AdvancedButton)press);
                splashMenu.openMenuAt(0, press.field_22761, screenWidth, screenHeight);
            });
            this.addContent(splashButton);
            FHContextMenu slideshowMenu = new FHContextMenu();
            slideshowMenu.setAutoclose(true);
            this.addChild(slideshowMenu);
            AdvancedButton inputSlideshowButton = new AdvancedButton(0, 0, 0, 20, Locals.localize((String)"drippyloadingscreen.helper.creator.add.slideshow.entername", (String[])new String[0]), true, press -> PopupHandler.displayPopup((Popup)new TextInputPopup(new Color(0, 0, 0, 0), "\u00a7l" + Locals.localize((String)"drippyloadingscreen.helper.creator.add.slideshow.entername.title", (String[])new String[0]) + ":", null, 240, this.parent::addSlideshow)));
            slideshowMenu.addContent(inputSlideshowButton);
            slideshowMenu.addSeparator();
            for (String s : SlideshowHandler.getSlideshowNames()) {
                Object name = s;
                if (class_310.method_1551().field_1772.method_1727((String)name) > 90) {
                    name = class_310.method_1551().field_1772.method_27523((String)name, 90) + "..";
                }
                AdvancedButton slideshowB = new AdvancedButton(0, 0, 0, 20, (String)name, true, press -> {
                    if (SlideshowHandler.slideshowExists(s)) {
                        this.parent.addSlideshow(s);
                    }
                });
                slideshowMenu.addContent(slideshowB);
            }
            AdvancedButton slideshowButton = new AdvancedButton(0, 0, 0, 20, Locals.localize((String)"drippyloadingscreen.helper.creator.add.slideshow", (String[])new String[0]), press -> {
                slideshowMenu.setParentButton((AdvancedButton)press);
                slideshowMenu.openMenuAt(0, press.field_22761, screenWidth, screenHeight);
            });
            this.addContent(slideshowButton);
            FHContextMenu shapesMenu = new FHContextMenu();
            shapesMenu.setAutoclose(true);
            this.addChild(shapesMenu);
            AdvancedButton addRectangleButton = new AdvancedButton(0, 0, 0, 20, Locals.localize((String)"drippyloadingscreen.helper.creator.add.shapes.rectangle", (String[])new String[0]), press -> this.parent.addShape(ShapeCustomizationItem.Shape.RECTANGLE));
            shapesMenu.addContent(addRectangleButton);
            AdvancedButton shapesButton = new AdvancedButton(0, 0, 0, 20, Locals.localize((String)"drippyloadingscreen.helper.creator.add.shapes", (String[])new String[0]), press -> {
                shapesMenu.setParentButton((AdvancedButton)press);
                shapesMenu.openMenuAt(0, press.field_22761, screenWidth, screenHeight);
            });
            this.addContent(shapesButton);
            AdvancedButton progressBarButton = new AdvancedButton(0, 0, 0, 20, Locals.localize((String)"drippyloadingscreen.helper.creator.add.customprogressbar", (String[])new String[0]), press -> {
                this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                PropertiesSection sec = new PropertiesSection("customization");
                sec.addEntry("action", "addcustomprogressbar");
                sec.addEntry("width", "100");
                sec.addEntry("height", "20");
                sec.addEntry("x", "0");
                sec.addEntry("y", "" + (int)((float)this.parent.ui.bar.getHeight() * UIBase.getUIScale()));
                CustomProgressBarCustomizationItem i = new CustomProgressBarCustomizationItem(sec);
                this.parent.addContent(new LayoutCustomProgressBar(i, this.parent));
            });
            this.addContent(progressBarButton);
            if (!DrippyLoadingScreen.isAuudioLoaded()) {
                AdvancedButton dummyAudioElementButton = new AdvancedButton(0, 0, 0, 20, Locals.localize((String)"drippyloadingscreen.audio.item", (String[])new String[0]), press -> {
                    Object link = "https://www.curseforge.com/minecraft/mc-mods/drippy-loading-screen";
                    if ("fabric".equals("fabric")) {
                        link = (String)link + "-fabric";
                    }
                    WebUtils.openWebLink((String)link);
                });
                dummyAudioElementButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.editor.extension.dummy.audio.btn.desc", (String[])new String[0]), (String)"%n%"));
                this.addContent(dummyAudioElementButton);
            }
            for (CustomizationItemContainer customizationItemContainer : CustomizationItemRegistry.getInstance().getElements().values()) {
                AdvancedButton newCustomItemButton = new AdvancedButton(0, 0, 0, 20, customizationItemContainer.displayName, press -> this.parent.addCustomItem(customizationItemContainer));
                this.addContent(newCustomItemButton);
            }
            for (de.keksuccino.drippyloadingscreen.api.item.v2.CustomizationItemContainer customizationItemContainer : de.keksuccino.drippyloadingscreen.api.item.v2.CustomizationItemRegistry.getItems()) {
                AdvancedButton cusItemButton = new AdvancedButton(0, 0, 0, 20, customizationItemContainer.getDisplayName(), press -> this.parent.addContent(customizationItemContainer.constructEditorElementInstance(customizationItemContainer.constructDefaultItemInstance(), this.parent)));
                String[] desc = customizationItemContainer.getDescription();
                if (desc != null && desc.length > 0) {
                    cusItemButton.setDescription(desc);
                }
                this.addContent(cusItemButton);
            }
            super.openMenuAt(x, y, screenWidth, screenHeight);
        }
    }

    public static class HiddenVanillaElementsContextMenu
    extends FHContextMenu {
        private LayoutEditorScreen parent;

        public HiddenVanillaElementsContextMenu(LayoutEditorScreen parent) {
            this.parent = parent;
        }

        @Override
        public void openMenuAt(int x, int y, int screenWidth, int screenHeight) {
            this.content.clear();
            this.separators.clear();
            ArrayList<VanillaLayoutSplashElement> hidden = new ArrayList<VanillaLayoutSplashElement>();
            for (LayoutElement layoutElement : this.parent.content) {
                if (!(layoutElement instanceof VanillaLayoutSplashElement) || ((VanillaLayoutSplashElement)layoutElement).getVanillaObject().vanillaVisible) continue;
                hidden.add((VanillaLayoutSplashElement)layoutElement);
            }
            if (hidden.isEmpty()) {
                AdvancedButton emptyButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.creator.empty", (String[])new String[0]), true, press -> {});
                this.addContent(emptyButton);
            } else {
                for (VanillaLayoutSplashElement vanillaLayoutSplashElement : hidden) {
                    String name = vanillaLayoutSplashElement.object.value;
                    AdvancedButton hiddenButton = new AdvancedButton(0, 0, 0, 0, name, true, press -> {
                        this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                        e.getVanillaObject().vanillaVisible = true;
                        e.getVanillaObject().element.visible = true;
                        this.closeMenu();
                    });
                    hiddenButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.editor.elements.vanilla.managedeleted.entry.desc", (String[])new String[0]), (String)"%n%"));
                    this.addContent(hiddenButton);
                }
            }
            super.openMenuAt(x, y, screenWidth, screenHeight);
        }
    }

    public static class MultiselectContextMenu
    extends FHContextMenu {
        private LayoutEditorScreen parent;

        public MultiselectContextMenu(LayoutEditorScreen parent) {
            this.parent = parent;
        }

        @Override
        public void openMenuAt(int x, int y, int screenWidth, int screenHeight) {
            this.content.clear();
            if (this.parent.isObjectFocused()) {
                this.parent.focusedObjectsCache = this.parent.getFocusedObjects();
                this.parent.multiselectStretchedX = false;
                this.parent.multiselectStretchedY = false;
                AdvancedButton deleteBtn = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.creator.multiselect.object.deleteall", (String[])new String[0]), true, press -> this.parent.deleteFocusedObjects());
                deleteBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.creator.multiselect.object.deleteall.btndesc", (String[])new String[0]), (String)"%n%"));
                this.addContent(deleteBtn);
                FHContextMenu stretchMenu = new FHContextMenu();
                stretchMenu.setAutoclose(true);
                this.addChild(stretchMenu);
                AdvancedButton stretchXBtn = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.creator.object.stretch.x", (String[])new String[0]), true, press -> {
                    this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                    for (LayoutElement o : this.parent.focusedObjectsCache) {
                        if (!o.isStretchable()) continue;
                        o.setStretchedX(!this.parent.multiselectStretchedX, false);
                    }
                    boolean bl = this.parent.multiselectStretchedX = !this.parent.multiselectStretchedX;
                    if (!this.parent.multiselectStretchedX) {
                        press.method_25355((class_2561)new class_2585(Locals.localize((String)"drippyloadingscreen.helper.creator.object.stretch.x", (String[])new String[0])));
                    } else {
                        press.method_25355((class_2561)new class_2585("\u00a7a" + Locals.localize((String)"drippyloadingscreen.helper.creator.object.stretch.x", (String[])new String[0])));
                    }
                });
                stretchMenu.addContent(stretchXBtn);
                AdvancedButton stretchYBtn = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.creator.object.stretch.y", (String[])new String[0]), true, press -> {
                    this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                    for (LayoutElement o : this.parent.focusedObjectsCache) {
                        if (!o.isStretchable()) continue;
                        o.setStretchedY(!this.parent.multiselectStretchedY, false);
                    }
                    boolean bl = this.parent.multiselectStretchedY = !this.parent.multiselectStretchedY;
                    if (!this.parent.multiselectStretchedY) {
                        press.method_25355((class_2561)new class_2585(Locals.localize((String)"drippyloadingscreen.helper.creator.object.stretch.y", (String[])new String[0])));
                    } else {
                        press.method_25355((class_2561)new class_2585("\u00a7a" + Locals.localize((String)"drippyloadingscreen.helper.creator.object.stretch.y", (String[])new String[0])));
                    }
                });
                stretchMenu.addContent(stretchYBtn);
                AdvancedButton stretchBtn = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.creator.multiselect.object.stretchall", (String[])new String[0]), true, press -> {
                    stretchMenu.setParentButton((AdvancedButton)press);
                    stretchMenu.openMenuAt(0, press.field_22761, screenWidth, screenHeight);
                });
                stretchBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.creator.multiselect.object.stretchall.btndesc", (String[])new String[0]), (String)"%n%"));
                this.addContent(stretchBtn);
                AdvancedButton copyButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.editor.ui.edit.copy", (String[])new String[0]), press -> this.parent.copySelectedElements());
                this.addContent(copyButton);
                AdvancedButton pasteButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.editor.ui.edit.paste", (String[])new String[0]), press -> this.parent.pasteElements());
                this.addContent(pasteButton);
            }
            super.openMenuAt(x, y, screenWidth, screenHeight);
        }
    }
}

